/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class ConfigurationFiles_Options_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(ConfigurationFiles.Options.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "ConfigurationFileDirectories": {
                return OptionDescriptor.create((String)"ConfigurationFileDirectories", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Directories directly containing configuration files for dynamic features at runtime.", (Object)this.getContainer(), ConfigurationFiles.Options.ConfigurationFileDirectories, (String)"ConfigurationFileDirectories", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "ConfigurationResourceRoots": {
                return OptionDescriptor.create((String)"ConfigurationResourceRoots", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resource path above configuration resources for dynamic features at runtime.", (Object)this.getContainer(), ConfigurationFiles.Options.ConfigurationResourceRoots, (String)"ConfigurationResourceRoots", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DynamicProxyConfigurationFiles": {
                return OptionDescriptor.create((String)"DynamicProxyConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"One or several (comma-separated) paths to JSON files that specify lists of interfaces that define Java proxy classes.\n\nThe JSON structure is described in the following schema:\n\n  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/proxy-config-schema-v1.0.0.json\n\nAn example file contents follows:\n\n    [\n      {\n        \"condition\" : {\n          \"typeReachable\" : \"org.example.CallingClass\"\n        },\n        \"interfaces\" : [\n          \"java.lang.AutoCloseable\",\n          \"java.util.Comparator\"\n        ]\n      },\n      {\n        \"condition\" : {\n          \"typeReachable\" : \"org.example.CallingClass\"\n        },\n        \"interfaces\" : [\n          \"java.util.Comparator\"\n        ]\n      }\n    ]", (Object)this.getContainer(), ConfigurationFiles.Options.DynamicProxyConfigurationFiles, (String)"DynamicProxyConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "DynamicProxyConfigurationResources": {
                return OptionDescriptor.create((String)"DynamicProxyConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing program elements to be made available for reflection (see ProxyConfigurationFiles).", (Object)this.getContainer(), ConfigurationFiles.Options.DynamicProxyConfigurationResources, (String)"DynamicProxyConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This can be caused by a proxy-config.json file in your META-INF directory. Consider including proxy configuration in the reflection section of reachability-metadata.md instead.");
            }
            case "JNIConfigurationFiles": {
                return OptionDescriptor.create((String)"JNIConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Files describing program elements to be made accessible via JNI according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/jni-config-schema-v1.1.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.JNIConfigurationFiles, (String)"JNIConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIConfigurationResources": {
                return OptionDescriptor.create((String)"JNIConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing program elements to be made accessible via JNI according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/jni-config-schema-v1.1.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.JNIConfigurationResources, (String)"JNIConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PredefinedClassesConfigurationFiles": {
                return OptionDescriptor.create((String)"PredefinedClassesConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Files describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.PredefinedClassesConfigurationFiles, (String)"PredefinedClassesConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PredefinedClassesConfigurationResources": {
                return OptionDescriptor.create((String)"PredefinedClassesConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.PredefinedClassesConfigurationResources, (String)"PredefinedClassesConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReachabilityMetadataResources": {
                return OptionDescriptor.create((String)"ReachabilityMetadataResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing reachability metadata needed for the program https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reachability-metadata-schema-v1.2.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.ReachabilityMetadataResources, (String)"ReachabilityMetadataResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReflectionConfigurationFiles": {
                return OptionDescriptor.create((String)"ReflectionConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"One or several (comma-separated) paths to JSON files that specify which program elements should be made available via reflection.\n\nThe JSON object schema is described at:\n\n   https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reflect-config-schema-v1.1.0.json\n\nExample:\n\n\t[\n\t  {\n\t    \"condition\" : {\n          \"typeReachable\" : \"org.example.CallingClass\"\n        },\n\t    \"name\" : \"java.lang.Class\",\n\t    \"allDeclaredConstructors\" : \"true\",\n\t    \"allPublicConstructors\" : \"true\",\n\t    \"allDeclaredMethods\" : \"true\",\n\t    \"allPublicMethods\" : \"true\"\n\t  },\n\t  {\n\t    \"condition\" : {\n          \"typeReachable\" : \"org.example.CallingClass\"\n        },\n\t    \"name\" : \"java.lang.String\",\n\t    \"fields\" : [\n\t      { \"name\" : \"value\" },\n\t      { \"name\" : \"hash\" }\n\t    ],\n\t    \"methods\" : [\n\t      { \"name\" : \"<init>\", \"parameterTypes\" : [] },\n\t      { \"name\" : \"<init>\", \"parameterTypes\" : [\"char[]\"] },\n\t      { \"name\" : \"charAt\" },\n\t      { \"name\" : \"format\", \"parameterTypes\" : [\"java.lang.String\", \"java.lang.Object[]\"] },\n\t    ]\n\t  },\n      {\n        \"condition\" : {\n          \"typeReachable\" : \"org.example.CallingClass\"\n        },\n        \"name\" : \"java.lang.String$CaseInsensitiveComparator\",\n        \"methods\" : [\n          { \"name\" : \"compare\" }\n        ]\n      }\n\t]", (Object)this.getContainer(), ConfigurationFiles.Options.ReflectionConfigurationFiles, (String)"ReflectionConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReflectionConfigurationResources": {
                return OptionDescriptor.create((String)"ReflectionConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing program elements to be made available for reflection (see ReflectionConfigurationFiles).", (Object)this.getContainer(), ConfigurationFiles.Options.ReflectionConfigurationResources, (String)"ReflectionConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ResourceConfigurationFiles": {
                return OptionDescriptor.create((String)"ResourceConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Files describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.ResourceConfigurationFiles, (String)"ResourceConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ResourceConfigurationResources": {
                return OptionDescriptor.create((String)"ResourceConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json", (Object)this.getContainer(), ConfigurationFiles.Options.ResourceConfigurationResources, (String)"ResourceConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SerializationConfigurationFiles": {
                return OptionDescriptor.create((String)"SerializationConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.\n\nThe structure is described in the following schema:\n\n  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json\n\nExample:\n\n    {\n      \"serialization\": [\n        {\n        \"condition\" : {\n          \"typeReachable\" : \"app.DataSerializer\"\n        },\n        \"name\" : \"java.util.ArrayList\"\n      }\n      ]\n    }\n\n\nIn rare cases an application might explicitly make calls to\n\n    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)\n\nThe specified `constructorToCall` differs from the one that would be automatically used during regular serialization of `cl`.\nWhen a class is registered for run-time serialization, all potential custom constructors are automatically registered.\nAs a result, this use case does not require any additional metadata.", (Object)this.getContainer(), ConfigurationFiles.Options.SerializationConfigurationFiles, (String)"SerializationConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SerializationConfigurationResources": {
                return OptionDescriptor.create((String)"SerializationConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing program elements to be made available for serialization (see SerializationConfigurationFiles).", (Object)this.getContainer(), ConfigurationFiles.Options.SerializationConfigurationResources, (String)"SerializationConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SerializationDenyConfigurationFiles": {
                return OptionDescriptor.create((String)"SerializationDenyConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.\n\nThe structure is described in the following schema:\n\n  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json\n\nExample:\n\n    {\n      \"serialization\": [\n        {\n        \"condition\" : {\n          \"typeReachable\" : \"app.DataSerializer\"\n        },\n        \"name\" : \"java.util.ArrayList\"\n      }\n      ]\n    }\n\n\nIn rare cases an application might explicitly make calls to\n\n    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)\n\nThe specified `constructorToCall` differs from the one that would be automatically used during regular serialization of `cl`.\nWhen a class is registered for run-time serialization, all potential custom constructors are automatically registered.\nAs a result, this use case does not require any additional metadata.", (Object)this.getContainer(), ConfigurationFiles.Options.SerializationDenyConfigurationFiles, (String)"SerializationDenyConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SerializationDenyConfigurationResources": {
                return OptionDescriptor.create((String)"SerializationDenyConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Resources describing program elements that must not be made available for serialization.", (Object)this.getContainer(), ConfigurationFiles.Options.SerializationDenyConfigurationResources, (String)"SerializationDenyConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StrictConfiguration": {
                return OptionDescriptor.create((String)"StrictConfiguration", (OptionType)OptionType.Debug, Boolean.class, (String)"When configuration files do not match their schema, abort the image build instead of emitting a warning.", (Object)this.getContainer(), ConfigurationFiles.Options.StrictConfiguration, (String)"StrictConfiguration", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TrackTypeReachedOnInterfaces": {
                return OptionDescriptor.create((String)"TrackTypeReachedOnInterfaces", (OptionType)OptionType.Debug, Boolean.class, (String)"Testing flag: print 'typeReached' conditions that are used on interfaces without default methods at build time.", (Object)this.getContainer(), ConfigurationFiles.Options.TrackTypeReachedOnInterfaces, (String)"TrackTypeReachedOnInterfaces", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TrackUnsatisfiedTypeReachedConditions": {
                return OptionDescriptor.create((String)"TrackUnsatisfiedTypeReachedConditions", (OptionType)OptionType.Debug, Boolean.class, (String)"Testing flag: the 'typeReached' condition is always satisfied however it prints the stack trace where it would not be satisfied.", (Object)this.getContainer(), ConfigurationFiles.Options.TrackUnsatisfiedTypeReachedConditions, (String)"TrackUnsatisfiedTypeReachedConditions", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TreatAllNameEntriesAsType": {
                return OptionDescriptor.create((String)"TreatAllNameEntriesAsType", (OptionType)OptionType.Debug, Boolean.class, (String)"Testing flag: the 'name' is treated as 'type' in reflection configuration.", (Object)this.getContainer(), ConfigurationFiles.Options.TreatAllNameEntriesAsType, (String)"TreatAllNameEntriesAsType", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TreatAllTypeReachableConditionsAsTypeReached": {
                return OptionDescriptor.create((String)"TreatAllTypeReachableConditionsAsTypeReached", (OptionType)OptionType.Debug, Boolean.class, (String)"Testing flag: the 'typeReachable' condition is treated as typeReached so the semantics of programs can change.", (Object)this.getContainer(), ConfigurationFiles.Options.TreatAllTypeReachableConditionsAsTypeReached, (String)"TreatAllTypeReachableConditionsAsTypeReached", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TreatAllUserSpaceTypesAsTrackedForTypeReached": {
                return OptionDescriptor.create((String)"TreatAllUserSpaceTypesAsTrackedForTypeReached", (OptionType)OptionType.Debug, Boolean.class, (String)"Testing flag: every type is considered as it participates in a typeReachable condition.", (Object)this.getContainer(), ConfigurationFiles.Options.TreatAllUserSpaceTypesAsTrackedForTypeReached, (String)"TreatAllUserSpaceTypesAsTrackedForTypeReached", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "WarnAboutMissingReflectionOrJNIMetadataElements": {
                return OptionDescriptor.create((String)"WarnAboutMissingReflectionOrJNIMetadataElements", (OptionType)OptionType.Expert, Boolean.class, (String)"Warn when reflection and JNI configuration files have elements that could not be found on the classpath or modulepath.", (Object)this.getContainer(), ConfigurationFiles.Options.WarnAboutMissingReflectionOrJNIMetadataElements, (String)"WarnAboutMissingReflectionOrJNIMetadataElements", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 24;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ConfigurationFileDirectories");
                    }
                    case 1: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ConfigurationResourceRoots");
                    }
                    case 2: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("DynamicProxyConfigurationFiles");
                    }
                    case 3: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("DynamicProxyConfigurationResources");
                    }
                    case 4: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("JNIConfigurationFiles");
                    }
                    case 5: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("JNIConfigurationResources");
                    }
                    case 6: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("PredefinedClassesConfigurationFiles");
                    }
                    case 7: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("PredefinedClassesConfigurationResources");
                    }
                    case 8: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ReachabilityMetadataResources");
                    }
                    case 9: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ReflectionConfigurationFiles");
                    }
                    case 10: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ReflectionConfigurationResources");
                    }
                    case 11: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ResourceConfigurationFiles");
                    }
                    case 12: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("ResourceConfigurationResources");
                    }
                    case 13: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("SerializationConfigurationFiles");
                    }
                    case 14: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("SerializationConfigurationResources");
                    }
                    case 15: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("SerializationDenyConfigurationFiles");
                    }
                    case 16: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("SerializationDenyConfigurationResources");
                    }
                    case 17: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("StrictConfiguration");
                    }
                    case 18: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("TrackTypeReachedOnInterfaces");
                    }
                    case 19: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("TrackUnsatisfiedTypeReachedConditions");
                    }
                    case 20: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("TreatAllNameEntriesAsType");
                    }
                    case 21: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("TreatAllTypeReachableConditionsAsTypeReached");
                    }
                    case 22: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("TreatAllUserSpaceTypesAsTrackedForTypeReached");
                    }
                    case 23: {
                        return ConfigurationFiles_Options_OptionDescriptors.this.get("WarnAboutMissingReflectionOrJNIMetadataElements");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

