/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.UnmanagedPrimitiveArray;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public final class UnmanagedPrimitiveArrays {
    private static final UninterruptibleUtils.AtomicLong runtimeArraysInExistence = new UninterruptibleUtils.AtomicLong(0L);
    private static final OutOfMemoryError OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate native array");

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends UnmanagedPrimitiveArray<?>> T createArray(int length, Class<?> arrayType, NmtCategory nmtCategory) {
        DynamicHub hub = SubstrateUtil.cast(arrayType, DynamicHub.class);
        VMError.guarantee(LayoutEncoding.isPrimitiveArray(hub.getLayoutEncoding()));
        UnsignedWord size = Word.unsigned((int)length).shiftLeft(LayoutEncoding.getArrayIndexShift(hub.getLayoutEncoding()));
        Pointer array = (Pointer)NullableNativeMemory.calloc(size, nmtCategory);
        if (array.isNull()) {
            throw OUT_OF_MEMORY_ERROR;
        }
        UnmanagedPrimitiveArrays.trackUnmanagedArray((UnmanagedPrimitiveArray)array);
        return (T)((UnmanagedPrimitiveArray)array);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void trackUnmanagedArray(UnmanagedPrimitiveArray<?> array) {
        assert (!Heap.getHeap().isInImageHeap((Pointer)array)) : "must not track image heap objects";
        assert (array.isNull() || runtimeArraysInExistence.incrementAndGet() > 0L) : "overflow";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void untrackUnmanagedArray(UnmanagedPrimitiveArray<?> array) {
        assert (array.isNull() || runtimeArraysInExistence.getAndDecrement() > 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void releaseUnmanagedArray(UnmanagedPrimitiveArray<?> array) {
        UnmanagedPrimitiveArrays.untrackUnmanagedArray(array);
        NullableNativeMemory.free(array);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T getAddressOf(UnmanagedPrimitiveArray<?> array, int layoutEncoding, int index) {
        assert (index >= 0);
        return (T)((Pointer)array).add(index << LayoutEncoding.getArrayIndexShift(layoutEncoding));
    }

    @Uninterruptible(reason="Destination array must not move.")
    public static <T> T copyToHeap(UnmanagedPrimitiveArray<?> src, int srcPos, T dest, int destPos, int length) {
        DynamicHub destHub = KnownIntrinsics.readHub(dest);
        VMError.guarantee(LayoutEncoding.isPrimitiveArray(destHub.getLayoutEncoding()), "Copying is only supported for primitive arrays");
        VMError.guarantee(srcPos >= 0 && destPos >= 0 && length >= 0 && destPos + length <= ArrayLengthNode.arrayLength(dest));
        Word destAddressAtPos = Word.objectToUntrackedPointer(dest).add(LayoutEncoding.getArrayElementOffset(destHub.getLayoutEncoding(), destPos));
        Pointer srcAddressAtPos = (Pointer)UnmanagedPrimitiveArrays.getAddressOf(src, destHub.getLayoutEncoding(), srcPos);
        JavaMemoryUtil.copyPrimitiveArrayForward(srcAddressAtPos, (Pointer)destAddressAtPos, Word.unsigned((int)length).shiftLeft(LayoutEncoding.getArrayIndexShift(destHub.getLayoutEncoding())));
        return dest;
    }

    @Uninterruptible(reason="Destination array must not move.")
    public static <T> T compareOrCopyToHeap(UnmanagedPrimitiveArray<?> src, int srcPos, T dest, int destPos, int length) {
        DynamicHub destHub = KnownIntrinsics.readHub(dest);
        VMError.guarantee(LayoutEncoding.isPrimitiveArray(destHub.getLayoutEncoding()), "Copying is only supported for primitive arrays");
        VMError.guarantee(srcPos >= 0 && destPos >= 0 && length >= 0 && destPos + length <= ArrayLengthNode.arrayLength(dest));
        Word destAddressAtPos = Word.objectToUntrackedPointer(dest).add(LayoutEncoding.getArrayElementOffset(destHub.getLayoutEncoding(), destPos));
        Pointer srcAddressAtPos = (Pointer)UnmanagedPrimitiveArrays.getAddressOf(src, destHub.getLayoutEncoding(), srcPos);
        UnsignedWord size = Word.unsigned((int)length).shiftLeft(LayoutEncoding.getArrayIndexShift(destHub.getLayoutEncoding()));
        UnsignedWord equalBytes = UnmanagedMemoryUtil.compare(srcAddressAtPos, (Pointer)destAddressAtPos, size);
        if (equalBytes.belowThan(size)) {
            UnsignedWord alignBits = Word.unsigned((int)7);
            UnsignedWord offset = equalBytes.and(alignBits.not());
            JavaMemoryUtil.copyPrimitiveArrayForward(srcAddressAtPos.add(offset), destAddressAtPos.add(offset), size.subtract(offset));
        }
        return dest;
    }

    @Uninterruptible(reason="Destination array must not move.")
    public static <T> UnmanagedPrimitiveArray<?> copyFromHeap(T src, int srcPos, UnmanagedPrimitiveArray<?> dest, int destPos, int length) {
        DynamicHub srcHub = KnownIntrinsics.readHub(src);
        VMError.guarantee(LayoutEncoding.isPrimitiveArray(srcHub.getLayoutEncoding()), "Copying is only supported for primitive arrays");
        VMError.guarantee(srcPos >= 0 && destPos >= 0 && length >= 0 && srcPos + length <= ArrayLengthNode.arrayLength(src));
        Word srcAddressAtPos = Word.objectToUntrackedPointer(src).add(LayoutEncoding.getArrayElementOffset(srcHub.getLayoutEncoding(), srcPos));
        Pointer destAddressAtPos = (Pointer)UnmanagedPrimitiveArrays.getAddressOf(dest, srcHub.getLayoutEncoding(), destPos);
        JavaMemoryUtil.copyPrimitiveArrayForward((Pointer)srcAddressAtPos, destAddressAtPos, Word.unsigned((int)length).shiftLeft(LayoutEncoding.getArrayIndexShift(srcHub.getLayoutEncoding())));
        return dest;
    }
}

