/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

public interface RegisterDumper {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static RegisterDumper singleton() {
        if (!ImageSingletons.contains(RegisterDumper.class)) {
            throw VMError.shouldNotReachHere("RegisterDumper is not available in ImageSingletons");
        }
        return (RegisterDumper)ImageSingletons.lookup(RegisterDumper.class);
    }

    public static void dumpReg(Log log, String label, long value, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        log.string(label).zhex(value);
        if (printLocationInfo) {
            log.spaces(1);
            SubstrateDiagnostics.printLocationInfo(log, Word.unsigned((long)value), allowJavaHeapAccess, allowUnsafeOperations);
        }
        log.newline();
    }

    public void dumpRegisters(Log var1, Context var2, boolean var3, boolean var4, boolean var5);

    public PointerBase getHeapBase(Context var1);

    public PointerBase getThreadPointer(Context var1);

    public PointerBase getSP(Context var1);

    public PointerBase getIP(Context var1);

    public static interface Context
    extends PointerBase {
    }
}

