/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolate;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolateThread;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeObjectCleaner;

public class NativeObject {
    private final NativeIsolate isolate;
    private final long objectHandle;
    private final NativeObjectCleaner<NativeObject> cleanup;

    public NativeObject(NativeIsolate isolate, long objectHandle) {
        this.isolate = isolate;
        this.objectHandle = objectHandle;
        this.cleanup = new NativeObjectCleanerImpl(this).register();
    }

    public final NativeIsolate getIsolate() {
        return this.isolate;
    }

    public final long getHandle() {
        return this.objectHandle;
    }

    public final void release() {
        if (this.isolate.cleaners.remove(this.cleanup)) {
            NativeIsolateThread nativeIsolateThread = this.isolate.enter();
            try {
                this.cleanup.cleanUp(nativeIsolateThread.getIsolateThreadId());
            }
            finally {
                nativeIsolateThread.leave();
            }
        }
    }

    private static final class NativeObjectCleanerImpl
    extends NativeObjectCleaner<NativeObject> {
        private final long handle;

        NativeObjectCleanerImpl(NativeObject nativeObject) {
            super(nativeObject, nativeObject.getIsolate());
            this.handle = nativeObject.getHandle();
        }

        @Override
        public void cleanUp(long isolateThread) {
            this.isolate.getConfig().releaseNativeObject(isolateThread, this.handle);
        }

        public String toString() {
            return "NativeObject 0x" + Long.toHexString(this.handle);
        }
    }
}

