/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class InterpreterMethodPointerHolder {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private CFunctionPointer methodNotCompiledFtnPtr;

    @Fold
    public static InterpreterMethodPointerHolder singleton() {
        return (InterpreterMethodPointerHolder)ImageSingletons.lookup(InterpreterMethodPointerHolder.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CFunctionPointer getMethodNotCompiledHandler() {
        CFunctionPointer ptr = InterpreterMethodPointerHolder.singleton().methodNotCompiledFtnPtr;
        assert (ptr.rawValue() != 0L);
        return ptr;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setMethodNotCompiledHandler(CFunctionPointer ftnptr) {
        assert (InterpreterMethodPointerHolder.singleton().methodNotCompiledFtnPtr == null);
        InterpreterMethodPointerHolder.singleton().methodNotCompiledFtnPtr = ftnptr;
    }
}

