/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public class PolymorphicSignatureWrapperMethod
implements ResolvedJavaMethod,
GraphProvider,
AnnotationWrapper,
OriginalMethodProvider {
    private final SubstitutionMethod substitutionBaseMethod;
    private final ResolvedJavaMethod originalMethod;
    private final ConstantPool constantPool;
    private StackTraceElement stackTraceElement;
    private static final LineNumberTable lineNumberTable = new LineNumberTable(new int[]{1}, new int[]{0});

    PolymorphicSignatureWrapperMethod(SubstitutionMethod substitutionBaseMethod, ResolvedJavaMethod originalMethod) {
        this.substitutionBaseMethod = substitutionBaseMethod;
        this.originalMethod = originalMethod;
        this.constantPool = substitutionBaseMethod.getDeclaringClass().getDeclaredConstructors(false)[0].getConstantPool();
    }

    public ResolvedJavaMethod unwrapTowardsOriginalMethod() {
        return this.originalMethod;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        ArrayList<ValueNode> args = new ArrayList<ValueNode>(kit.getInitialArguments());
        ValueNode receiver = null;
        if (!this.substitutionBaseMethod.isStatic()) {
            receiver = (ValueNode)args.remove(0);
        }
        ValueNode parameterArray = (ValueNode)kit.append((Node)new NewArrayNode((ResolvedJavaType)kit.getMetaAccess().lookupJavaType(Object.class), (ValueNode)kit.createInt(args.size()), true));
        for (int i = 0; i < args.size(); ++i) {
            ValueNode arg = (ValueNode)args.get(i);
            if (arg.getStackKind().isPrimitive()) {
                arg = kit.createBoxing(arg, arg.getStackKind(), (ResolvedJavaType)kit.getMetaAccess().lookupJavaType(arg.getStackKind().toBoxedJavaClass()));
            }
            StateSplit storeIndexedNode = (StateSplit)kit.createStoreIndexed(parameterArray, i, JavaKind.Object, arg);
            storeIndexedNode.setStateAfter(kit.getFrameState().create(kit.bci(), storeIndexedNode));
        }
        AnalysisMethod invokeTarget = kit.getMetaAccess().getUniverse().lookup((JavaMethod)this.substitutionBaseMethod.getOriginal());
        InvokeWithExceptionNode invoke = this.substitutionBaseMethod.isStatic() ? kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)invokeTarget, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{parameterArray}) : kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)invokeTarget, CallTargetNode.InvokeKind.Virtual, kit.getFrameState(), kit.bci(), new ValueNode[]{receiver, parameterArray});
        JavaKind returnKind = this.getSignature().getReturnKind();
        InvokeWithExceptionNode retVal = invoke;
        if (returnKind.isPrimitive() && returnKind != JavaKind.Void) {
            switch (returnKind) {
                case Short: 
                case Int: 
                case Long: {
                    AnalysisMethod unboxMethod;
                    ValueNode methodHandleOrMemberName;
                    try {
                        String unboxMethodName = returnKind.toString() + "Unbox";
                        switch (this.substitutionBaseMethod.getName()) {
                            case "invokeBasic": 
                            case "invokeExact": 
                            case "invoke": {
                                methodHandleOrMemberName = receiver;
                                unboxMethod = kit.getMetaAccess().lookupJavaMethod((Executable)MethodHandleUtils.class.getMethod(unboxMethodName, Object.class, MethodHandle.class));
                                break;
                            }
                            case "linkToVirtual": 
                            case "linkToStatic": 
                            case "linkToInterface": 
                            case "linkToSpecial": {
                                methodHandleOrMemberName = (ValueNode)args.get(args.size() - 1);
                                unboxMethod = kit.getMetaAccess().lookupJavaMethod((Executable)MethodHandleUtils.class.getMethod(unboxMethodName, Object.class, Target_java_lang_invoke_MemberName.class));
                                break;
                            }
                            default: {
                                throw VMError.shouldNotReachHereUnexpectedInput(this.substitutionBaseMethod.getName());
                            }
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw VMError.shouldNotReachHere(e);
                    }
                    retVal = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)unboxMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{retVal, methodHandleOrMemberName});
                    break;
                }
                default: {
                    retVal = kit.createUnboxing((ValueNode)invoke, returnKind);
                }
            }
        }
        kit.createReturn((ValueNode)retVal, returnKind);
        return kit.finalizeGraph();
    }

    public String getName() {
        return this.substitutionBaseMethod.getName();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.substitutionBaseMethod.getDeclaringClass();
    }

    public Signature getSignature() {
        return this.originalMethod.getSignature();
    }

    public boolean allowRuntimeCompilation() {
        return false;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public int getMaxLocals() {
        return 2 * this.getSignature().getParameterCount(true);
    }

    public int getMaxStackSize() {
        return 2;
    }

    public boolean isSynthetic() {
        return true;
    }

    public boolean isVarArgs() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isDeclared() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isClassInitializer() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean canBeStaticallyBound() {
        return true;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        if (this.stackTraceElement == null) {
            this.stackTraceElement = new StackTraceElement(this.getDeclaringClass().toJavaName(true), this.getName(), "generated", 0);
        }
        return this.stackTraceElement;
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.intentionallyUnimplemented();
    }

    public void reprofile() {
        throw VMError.intentionallyUnimplemented();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean canBeInlined() {
        return true;
    }

    public boolean hasNeverInlineDirective() {
        return false;
    }

    public boolean shouldBeInlined() {
        return true;
    }

    public LineNumberTable getLineNumberTable() {
        return lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.intentionallyUnimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.intentionallyUnimplemented();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.substitutionBaseMethod;
    }

    public int getModifiers() {
        return this.substitutionBaseMethod.getModifiers();
    }
}

