/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.c.NativeLibraries;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
class JNIRegistrationAttach
extends JNIRegistrationUtil
implements InternalFeature {
    JNIRegistrationAttach() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        a.registerReachabilityHandler(JNIRegistrationAttach::registerAndLinkAttach, new Object[]{JNIRegistrationAttach.method((Feature.FeatureAccess)a, "sun.tools.attach.AttachProviderImpl", "attachVirtualMachine", String.class)});
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_tools_attach_VirtualMachineImpl");
    }

    private static void registerAndLinkAttach(Feature.DuringAnalysisAccess a) {
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("attach");
        NativeLibraries.singleton().addStaticJniLibrary("attach", new String[0]);
    }
}

