/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.imagelayer.LayerArchiveSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarOutputStream;

public class WriteLayerArchiveSupport
extends LayerArchiveSupport {
    public WriteLayerArchiveSupport(String layerName, NativeImageClassLoaderSupport classLoaderSupport, Path tempDir, ArchiveSupport archiveSupport) {
        super(layerName, classLoaderSupport.getLayerFile(), tempDir.resolve("layerRoot_write"), archiveSupport);
        this.builderArguments.addAll(classLoaderSupport.getHostedOptionParser().getArguments());
    }

    @Override
    protected void validateLayerFile() {
        super.validateLayerFile();
        Path layerFilePath = this.layerFile.toAbsolutePath();
        Path layerParentPath = layerFilePath.getParent();
        if (layerParentPath == null) {
            throw UserError.abort("The given layer file " + String.valueOf(this.layerFile) + " doesn't have a parent directory.", new Object[0]);
        }
        if (!Files.isWritable(layerParentPath)) {
            throw UserError.abort("The layer file parent directory " + String.valueOf(layerParentPath) + " is not writeable.", new Object[0]);
        }
        if (Files.exists(layerFilePath, new LinkOption[0]) && !Files.isWritable(layerFilePath)) {
            throw UserError.abort("The given layer file " + String.valueOf(this.layerFile) + " is not writeable.", new Object[0]);
        }
    }

    private void writeBuilderArgumentsFile() {
        try {
            Files.write(this.getBuilderArgumentsFilePath(), (Iterable<? extends CharSequence>)this.builderArguments, new OpenOption[0]);
        }
        catch (IOException e) {
            throw UserError.abort("Unable to write builder arguments to file " + String.valueOf(this.getBuilderArgumentsFilePath()), new Object[0]);
        }
    }

    public void write() {
        try (JarOutputStream jarOutStream = new JarOutputStream(Files.newOutputStream(this.layerFile, new OpenOption[0]), this.archiveSupport.createManifest());){
            jarOutStream.setLevel(0);
            this.writeBuilderArgumentsFile();
            this.archiveSupport.addFileToJar(this.layerDir, this.getBuilderArgumentsFilePath(), this.layerFile, jarOutStream);
            this.archiveSupport.addFileToJar(this.layerDir, this.getSnapshotPath(), this.layerFile, jarOutStream);
            this.archiveSupport.addFileToJar(this.layerDir, this.getSnapshotGraphsPath(), this.layerFile, jarOutStream);
            Path sharedLibFile = BuildArtifacts.singleton().get(BuildArtifacts.ArtifactType.IMAGE_LAYER).getFirst();
            this.archiveSupport.addFileToJar(NativeImageGenerator.getOutputDirectory(), sharedLibFile, this.layerFile, jarOutStream);
            this.layerProperties.write();
            this.archiveSupport.addFileToJar(this.layerDir, this.getLayerPropertiesFile(), this.layerFile, jarOutStream);
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.IMAGE_LAYER_BUNDLE, this.layerFile);
        }
        catch (IOException e) {
            throw UserError.abort("Failed to create Native Image Layer file " + String.valueOf(this.layerFile.getFileName()), e);
        }
        WriteLayerArchiveSupport.info("Layer written to %s", this.layerFile);
    }
}

