/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.aarch64.SubstrateAArch64MacroAssembler;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedDirectCallTrampolineSupport;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.function.Consumer;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={HostedDirectCallTrampolineSupport.class})
@Platforms(value={Platform.AARCH64.class})
public class AArch64HostedTrampolineSupport
implements HostedDirectCallTrampolineSupport {
    private static final int INSTRUCTION_SIZE = 4;

    @Override
    public boolean mayNeedTrampolines() {
        return true;
    }

    @Override
    public int getMaxCallDistance() {
        if (SubstrateOptions.UseDirectCallTrampolinesALot.getValue().booleanValue()) {
            return NumUtil.getNbitNumberInt((int)10);
        }
        return NumUtil.getNbitNumberInt((int)27);
    }

    @Override
    public int getTrampolineSize() {
        int numInstructions = 3;
        return numInstructions * 4;
    }

    @Override
    public int getTrampolineAlignment() {
        return 4;
    }

    @Override
    public byte[] createTrampoline(TargetDescription td, HostedMethod target, int trampolineStart) {
        SubstrateAArch64MacroAssembler masm = new SubstrateAArch64MacroAssembler(td);
        CompilationResult compilationResult = new CompilationResult("trampoline");
        Consumer<Assembler.CodeAnnotation> consumer = PatchConsumerFactory.HostedPatchConsumerFactory.factory().newConsumer(compilationResult);
        masm.setCodePatchingAnnotationConsumer(consumer);
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register reg = sc.getRegister();
            masm.adrpAdd(reg);
            masm.jmp(reg);
        }
        byte[] code = masm.close(true);
        VMError.guarantee(compilationResult.getCodeAnnotations().size() == 1);
        HostedPatcher patcher = (HostedPatcher)compilationResult.getCodeAnnotations().get(0);
        int relativeAddress = target.getCodeAddressOffset() - trampolineStart;
        patcher.patch(trampolineStart, relativeAddress, code);
        return code;
    }
}

