/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public final class CFunctionPointerCallStubMethod
extends CCallStubMethod {
    static CFunctionPointerCallStubMethod create(AnalysisMethod aMethod) {
        assert (!aMethod.isSynthetic()) : "Creating a stub for a stub? " + String.valueOf(aMethod);
        ResolvedJavaMethod method = aMethod.getWrapped();
        int newThreadStatus = VMThreads.StatusSupport.getNewThreadStatus(((InvokeCFunctionPointer)aMethod.getAnnotation(InvokeCFunctionPointer.class)).transition());
        return new CFunctionPointerCallStubMethod(method, newThreadStatus);
    }

    private CFunctionPointerCallStubMethod(ResolvedJavaMethod original, int newThreadStatus) {
        super(original, newThreadStatus);
    }

    @Override
    public Signature getSignature() {
        return new Signature(){
            private final Signature wrapped;
            {
                this.wrapped = CFunctionPointerCallStubMethod.super.getSignature();
            }

            public int getParameterCount(boolean receiver) {
                return this.wrapped.getParameterCount(receiver) + 1;
            }

            public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
                if (index == 0) {
                    return CFunctionPointerCallStubMethod.this.getOriginal().getDeclaringClass();
                }
                return this.wrapped.getParameterType(index - 1, accessingClass);
            }

            public JavaType getReturnType(ResolvedJavaType accessingClass) {
                return this.wrapped.getReturnType(accessingClass);
            }

            public String toString() {
                return "CFunctionPointerCallStubMethod.Signature<" + String.valueOf(this.wrapped) + ">";
            }
        };
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFF9FF | 8;
    }

    @Override
    public boolean canBeStaticallyBound() {
        return true;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return InvokeCFunctionPointer.class.getSimpleName();
    }

    @Override
    public boolean allowRuntimeCompilation() {
        boolean needsTransition = VMThreads.StatusSupport.isValidStatus(this.newThreadStatus);
        return !needsTransition;
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        assert (purpose != GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION || this.allowRuntimeCompilation());
        return super.buildGraph(debug, method, providers, purpose);
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, List<ValueNode> arguments) {
        return arguments.get(0);
    }

    @Override
    protected ResolvedSignature<AnalysisType> adaptSignatureAndConvertArguments(NativeLibraries nativeLibraries, HostedGraphKit kit, AnalysisMethod method, AnalysisType returnType, AnalysisType[] paramTypes, List<ValueNode> arguments) {
        arguments.remove(0);
        AnalysisType[] paramTypesNoReceiver = Arrays.copyOfRange(paramTypes, 1, paramTypes.length);
        return super.adaptSignatureAndConvertArguments(nativeLibraries, kit, method, returnType, paramTypesNoReceiver, arguments);
    }
}

