/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.GCOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.StringUtil;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
public class ValidateGCOptionFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ValidateGCOptionFeature.validateGCOption();
    }

    private static void validateGCOption() {
        Set values = SubstrateOptions.SupportedGCs.getValue().valuesAsSet();
        if (!Platform.includedIn(InternalPlatform.NATIVE_ONLY.class) && values.isEmpty()) {
            return;
        }
        Set<String> possibleValues = GCOptionValue.possibleValues();
        if (values.isEmpty()) {
            throw UserError.abort("Invalid option '--gc'. No GC specified. %s", ValidateGCOptionFeature.getGCErrorReason(possibleValues));
        }
        for (String val : values) {
            if (possibleValues.contains(val)) continue;
            throw UserError.abort("Invalid option '--gc'. '%s' is not an accepted value. %s", val, ValidateGCOptionFeature.getGCErrorReason(possibleValues));
        }
        if (values.size() != 1) {
            throw UserError.abort("%s is an invalid combination of GCs for option '--gc'.", StringUtil.joinSingleQuoted(values));
        }
    }

    private static String getGCErrorReason(Set<String> values) {
        return "Accepted values are " + StringUtil.joinSingleQuoted(values) + ".";
    }
}

