/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class ImageHeapObjects {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isInImageHeap(Object obj) {
        return obj == null || Heap.getHeap().isInImageHeap(obj);
    }

    public static <T> ImageHeapRef<T> ref(T t) {
        if (t == null) {
            return (ImageHeapRef)Word.nullPointer();
        }
        VMError.guarantee(ImageHeapObjects.isInImageHeap(t));
        Word result = Word.objectToUntrackedPointer(t);
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            result = result.subtract((UnsignedWord)KnownIntrinsics.heapBase());
        }
        return (ImageHeapRef)result;
    }

    public static <T> T deref(ImageHeapRef<T> ref) {
        if (ref.equal((UnsignedWord)Word.nullPointer())) {
            return null;
        }
        Pointer objectAddress = (Pointer)ref;
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            objectAddress = objectAddress.add((UnsignedWord)KnownIntrinsics.heapBase());
        }
        Object obj = objectAddress.toObject();
        VMError.guarantee(Heap.getHeap().isInImageHeap(obj));
        Object result = obj;
        return (T)result;
    }

    private ImageHeapObjects() {
    }
}

