/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.LayeredImageHeapMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class LayeredHostedImageHeapMapCollector
implements LayeredImageSingleton {
    private final List<String> currentLayerReachableMapsKeys = new ArrayList<String>();
    private final List<String> previousLayerReachableMapKeys;
    private final List<ImageHeapMap.HostedImageHeapMap<?, ?>> previousLayerReachableMaps = ImageLayerBuildingSupport.buildingExtensionLayer() ? new ArrayList() : null;

    public LayeredHostedImageHeapMapCollector() {
        this(null);
    }

    private LayeredHostedImageHeapMapCollector(List<String> previousLayerReachableMapKeys) {
        this.previousLayerReachableMapKeys = previousLayerReachableMapKeys;
    }

    public static LayeredHostedImageHeapMapCollector singleton() {
        return (LayeredHostedImageHeapMapCollector)ImageSingletons.lookup(LayeredHostedImageHeapMapCollector.class);
    }

    public void registerReachableHostedImageHeapMap(LayeredImageHeapMap<Object, Object> layeredImageHeapMap) {
        this.currentLayerReachableMapsKeys.add(layeredImageHeapMap.getMapKey());
    }

    public boolean isMapKeyReachableInPreviousLayer(String mapKey) {
        return this.previousLayerReachableMapKeys.contains(mapKey);
    }

    public void registerPreviousLayerHostedImageHeapMap(ImageHeapMap.HostedImageHeapMap<?, ?> hostedImageHeapMap) {
        this.previousLayerReachableMaps.add(hostedImageHeapMap);
    }

    public List<ImageHeapMap.HostedImageHeapMap<?, ?>> getPreviousLayerReachableMaps() {
        return this.previousLayerReachableMaps;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        HashSet<String> reachableMapKeys = new HashSet<String>(this.currentLayerReachableMapsKeys);
        if (this.previousLayerReachableMapKeys != null) {
            reachableMapKeys.addAll(this.previousLayerReachableMapKeys);
        }
        writer.writeStringList("reachableMapKeys", reachableMapKeys.stream().toList());
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        List<String> previousLayerReachableMapKeys = loader.readStringList("reachableMapKeys");
        return new LayeredHostedImageHeapMapCollector(previousLayerReachableMapKeys);
    }
}

