/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.CommandLineOptionOrigin;
import com.oracle.svm.core.option.DirectoryOptionOrigin;
import com.oracle.svm.core.option.DriverOptionOrigin;
import com.oracle.svm.core.option.JarOptionOrigin;
import com.oracle.svm.core.option.MacroOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class OptionOrigin {
    public static final OptionOrigin commandLineAPIOptionOriginSingleton = new CommandLineOptionOrigin(true);
    public static final OptionOrigin commandLineNonAPIOptionOriginSingleton = new CommandLineOptionOrigin(false);
    public static final OptionOrigin driverStableOriginSingleton = new DriverOptionOrigin();
    public static final String argFilePrefix = "argfile:";
    public static final String originUser = "user";
    public static final String originDriver = "driver";
    public static final String isAPISuffix = "+api";
    protected final boolean isStable;

    public OptionOrigin(boolean isStable) {
        this.isStable = isStable;
    }

    public URI container() {
        return null;
    }

    public Path location() {
        return null;
    }

    public boolean commandLineLike() {
        return false;
    }

    public boolean isStable() {
        return this.isStable;
    }

    public boolean isInternal() {
        return false;
    }

    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    public static OptionOrigin from(String origin) {
        return OptionOrigin.from(origin, true);
    }

    public static OptionOrigin from(String originArg, boolean strict) {
        String origin = originArg;
        boolean isStable = false;
        if (origin != null && OptionOrigin.isAPI(origin)) {
            isStable = true;
            origin = origin.substring(0, origin.length() - isAPISuffix.length());
        }
        if (origin == null || originUser.equals(origin) || origin.startsWith(argFilePrefix)) {
            return isStable ? commandLineAPIOptionOriginSingleton : commandLineNonAPIOptionOriginSingleton;
        }
        if (originDriver.equals(origin)) {
            return driverStableOriginSingleton;
        }
        URI originURI = OptionOrigin.originURI(origin);
        if (originURI == null) {
            MacroOptionOrigin macroOption = MacroOptionOrigin.from(isStable, origin);
            if (macroOption != null) {
                return macroOption;
            }
            if (strict) {
                throw VMError.shouldNotReachHere("Unsupported OptionOrigin: " + origin);
            }
            return null;
        }
        switch (originURI.getScheme()) {
            case "jar": {
                return new JarOptionOrigin(isStable, originURI);
            }
            case "file": {
                Path originPath = Path.of(originURI);
                if (!Files.isReadable(originPath) && strict) {
                    VMError.shouldNotReachHere("Directory origin with path that cannot be read: " + String.valueOf(originPath));
                }
                return new DirectoryOptionOrigin(isStable, originPath);
            }
        }
        if (strict) {
            throw VMError.shouldNotReachHere("OptionOrigin of unsupported scheme: " + String.valueOf(originURI));
        }
        return null;
    }

    public static boolean isAPI(String originArg) {
        return originArg.endsWith(isAPISuffix);
    }

    protected static URI originURI(String origin) {
        try {
            return new URI(origin);
        }
        catch (URISyntaxException x) {
            return null;
        }
    }

    static List<String> getRedirectionValuesFromPath(Path normalizedRedirPath) throws IOException {
        if (Files.isReadable(normalizedRedirPath)) {
            try (BufferedReader reader = Files.newBufferedReader(normalizedRedirPath);){
                String line;
                ArrayList<String> values = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    values.add(line);
                }
                ArrayList<String> arrayList = values;
                return arrayList;
            }
        }
        throw new FileNotFoundException("Unable to read file from " + String.valueOf(normalizedRedirPath.toUri()));
    }
}

