/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.metadata;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.metadata.MetadataTracer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

record TraceOptions(Path path, boolean merge, Path debugLog) {
    private static final int ARGUMENT_PARTS = 2;
    private static final ArgumentParser<Path> PATH_PARSER = (argumentKey, argumentValue) -> Paths.get(argumentValue, new String[0]).toAbsolutePath();
    private static final ArgumentParser<Boolean> BOOLEAN_PARSER = (argumentKey, argumentValue) -> switch (argumentValue) {
        case "true" -> true;
        case "false" -> false;
        default -> throw TraceOptions.badArgumentValueError(argumentKey, argumentValue, "Value must be a literal 'true' or 'false'");
    };

    static TraceOptions parse(String traceMetadataValue) {
        if (traceMetadataValue.isEmpty()) {
            throw TraceOptions.printHelp("Option " + MetadataTracer.Options.TraceMetadata.getName() + " cannot be empty.");
        }
        if (traceMetadataValue.equals("help")) {
            throw TraceOptions.printHelp("Option " + MetadataTracer.Options.TraceMetadata.getName() + " value is 'help'. Printing a description and aborting.");
        }
        HashMap<String, String> parsedArguments = new HashMap<String, String>();
        LinkedHashSet<String> allArguments = new LinkedHashSet<String>(List.of("path", "merge", "debug-log"));
        for (String argument : traceMetadataValue.split(",")) {
            String[] parts = SubstrateUtil.split(argument, "=", 2);
            if (parts.length != 2) {
                throw TraceOptions.badArgumentError(argument, "Argument should be a key-value pair separated by '='");
            }
            if (!allArguments.contains(parts[0])) {
                throw TraceOptions.badArgumentError(argument, "Argument key should be one of " + String.valueOf(allArguments));
            }
            if (parsedArguments.containsKey(parts[0])) {
                throw TraceOptions.badArgumentError(argument, "Argument '" + parts[0] + "' was already specified with value '" + (String)parsedArguments.get(parts[0]) + "'");
            }
            if (parts[1].isEmpty()) {
                throw TraceOptions.badArgumentError(argument, "Value cannot be empty");
            }
            parsedArguments.put(parts[0], parts[1]);
        }
        Path path = TraceOptions.requiredArgument(parsedArguments, "path", PATH_PARSER);
        boolean merge = TraceOptions.optionalArgument(parsedArguments, "merge", true, BOOLEAN_PARSER);
        Path debugLog = TraceOptions.optionalArgument(parsedArguments, "debug-log", null, PATH_PARSER);
        return new TraceOptions(path, merge, debugLog);
    }

    private static IllegalArgumentException printHelp(String errorMessage) {
        throw new IllegalArgumentException("%s\n\n%s description:\n\n%s\n".formatted(errorMessage, MetadataTracer.Options.TraceMetadata.getName(), "Enables metadata tracing at run time. This option is only supported if -H:+MetadataTracingSupport is set when building the image.\nThe value of this option is a comma-separated list of arguments specified as key-value pairs. The following arguments are supported:\n\n- path=<trace-output-directory> (required): Specifies the directory to write traced metadata to.\n- merge=<boolean> (optional): Specifies whether to merge or overwrite metadata with existing files at the output path (default: true).\n- debug-log=<path> (optional): Specifies a path to write debug output to. This option is meant for debugging; the option name and its\n  output format may change at any time.\n\nExample usage:\n    -H:TraceMetadata=path=trace_output_directory\n    -H:TraceMetadata=path=trace_output_directory,merge=false\n"));
    }

    private static IllegalArgumentException parseError(String message) {
        return new IllegalArgumentException(message + ". For more information (including usage examples), pass 'help' as an argument to " + MetadataTracer.Options.TraceMetadata.getName() + ".");
    }

    private static IllegalArgumentException badArgumentError(String argument, String message) {
        throw TraceOptions.parseError("Bad argument provided for " + MetadataTracer.Options.TraceMetadata.getName() + ": '" + argument + "'. " + message);
    }

    private static IllegalArgumentException badArgumentValueError(String argumentKey, String argumentValue, String message) {
        throw TraceOptions.badArgumentError(argumentKey + "=" + argumentValue, message);
    }

    private static <T> T requiredArgument(Map<String, String> arguments, String key, ArgumentParser<T> parser) {
        if (arguments.containsKey(key)) {
            return parser.parse(key, arguments.get(key));
        }
        throw TraceOptions.parseError(MetadataTracer.Options.TraceMetadata.getName() + " missing required argument '" + key + "'");
    }

    private static <T> T optionalArgument(Map<String, String> options, String key, T defaultValue, ArgumentParser<T> parser) {
        if (options.containsKey(key)) {
            return parser.parse(key, options.get(key));
        }
        return defaultValue;
    }

    private static interface ArgumentParser<T> {
        public T parse(String var1, String var2);
    }
}

