/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_jfc_JFCParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import jdk.jfr.Configuration;
import jdk.jfr.internal.jfc.JFC;

@TargetClass(value=JFC.class, onlyWith={HasJfrSupport.class})
public final class Target_jdk_jfr_internal_jfc_JFC {
    @Delete
    private static Path JFC_DIRECTORY;

    @Substitute
    public static List<Configuration> getConfigurations() {
        return new ArrayList<Configuration>(SubstrateJVM.getKnownConfigurations());
    }

    @Substitute
    public static Configuration createKnown(String name) throws IOException, ParseException {
        Path localPath = Paths.get(name, new String[0]);
        String jfcName = JFC.nameFromPath(localPath);
        for (Configuration config : SubstrateJVM.getKnownConfigurations()) {
            if (!config.getName().equals(jfcName)) continue;
            return config;
        }
        try (BufferedReader r = Files.newBufferedReader(localPath);){
            Configuration configuration = Target_jdk_jfr_internal_jfc_JFCParser.createConfiguration(jfcName, r);
            return configuration;
        }
    }

    @Substitute
    public static Configuration getPredefined(String name) throws IOException, ParseException {
        for (Configuration config : SubstrateJVM.getKnownConfigurations()) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        throw new NoSuchFileException("Could not locate configuration with name " + name);
    }
}

