/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import jdk.internal.reflect.Reflection;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=Reflection.class)
final class Target_jdk_internal_reflect_Reflection {
    Target_jdk_internal_reflect_Reflection() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Class<?> getCallerClass() {
        return StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), true);
    }

    @Substitute
    private static int getClassAccessFlags(DynamicHub cls) {
        return cls.getClassAccessFlags();
    }

    @Substitute
    private static boolean areNestMates(Class<?> currentClass, Class<?> memberClass) {
        return DynamicHub.fromClass(currentClass).isNestmateOf(memberClass);
    }

    @Alias
    public static native void ensureNativeAccess(Class<?> var0, Class<?> var1, String var2, boolean var3);
}

