/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.Util_java_lang_reflect_Array;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.lang.reflect.Array;
import java.util.Objects;

@TargetClass(value=Array.class)
final class Target_java_lang_reflect_Array {
    Target_java_lang_reflect_Array() {
    }

    @Substitute
    private static boolean getBoolean(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setBoolean(Object a, int index, boolean value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof boolean[]) {
            ((boolean[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static byte getByte(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setByte(Object a, int index, byte value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            ((byte[])array)[index] = value;
            return;
        }
        if (array instanceof short[]) {
            ((short[])array)[index] = value;
            return;
        }
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
            return;
        }
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
            return;
        }
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static char getChar(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setChar(Object a, int index, char value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof char[]) {
            ((char[])array)[index] = value;
            return;
        }
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
            return;
        }
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
            return;
        }
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static short getShort(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setShort(Object a, int index, short value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof short[]) {
            ((short[])array)[index] = value;
            return;
        }
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
            return;
        }
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
            return;
        }
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static int getInt(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setInt(Object a, int index, int value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
            return;
        }
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
            return;
        }
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static long getLong(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setLong(Object a, int index, long value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
            return;
        }
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static float getFloat(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        if (array instanceof float[]) {
            return ((float[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setFloat(Object a, int index, float value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
            return;
        }
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static double getDouble(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        if (array instanceof float[]) {
            return ((float[])array)[index];
        }
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void setDouble(Object a, int index, double value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof double[]) {
            ((double[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static Object get(Object a, int index) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof char[]) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof char[]) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        if (array instanceof float[]) {
            return Float.valueOf(((float[])array)[index]);
        }
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        if (array instanceof Object[]) {
            return ((Object[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static void set(Object a, int index, Object value) {
        Object array = Objects.requireNonNull(a);
        if (array instanceof boolean[]) {
            if (value instanceof Boolean) {
                ((boolean[])array)[index] = (Boolean)value;
                return;
            }
        } else if (array instanceof byte[]) {
            if (value instanceof Byte) {
                ((byte[])array)[index] = ((Number)value).byteValue();
                return;
            }
        } else if (array instanceof char[]) {
            if (value instanceof Character) {
                ((char[])array)[index] = ((Character)value).charValue();
                return;
            }
        } else if (array instanceof short[]) {
            if (value instanceof Byte || value instanceof Short) {
                ((short[])array)[index] = ((Number)value).shortValue();
                return;
            }
        } else if (array instanceof int[]) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                ((int[])array)[index] = ((Number)value).intValue();
                return;
            }
            if (value instanceof Character) {
                ((int[])array)[index] = ((Character)value).charValue();
                return;
            }
        } else if (array instanceof long[]) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                ((long[])array)[index] = ((Number)value).longValue();
                return;
            }
            if (value instanceof Character) {
                ((long[])array)[index] = ((Character)value).charValue();
                return;
            }
        } else if (array instanceof float[]) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float) {
                ((float[])array)[index] = ((Number)value).floatValue();
                return;
            }
            if (value instanceof Character) {
                ((float[])array)[index] = ((Character)value).charValue();
                return;
            }
        } else if (array instanceof double[]) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                ((double[])array)[index] = ((Number)value).doubleValue();
                return;
            }
            if (value instanceof Character) {
                ((double[])array)[index] = ((Character)value).charValue();
                return;
            }
        } else if (array instanceof Object[] && (value == null || array.getClass().getComponentType().isAssignableFrom(value.getClass()))) {
            ((Object[])array)[index] = value;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Substitute
    private static Object newArray(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceReflectionArrayType(componentType);
        }
        return KnownIntrinsics.unvalidatedNewArray(componentType, length);
    }

    @Substitute
    private static Object multiNewArray(Class<?> componentType, int[] dimensions) {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (dimensions.length == 0 || componentType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        int requestedDimension = dimensions.length;
        if (componentType.isArray()) {
            requestedDimension += SubstrateUtil.arrayTypeDimension(componentType);
        }
        if (requestedDimension > 255) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] >= 0) continue;
            throw new NegativeArraySizeException(String.valueOf(dimensions[i]));
        }
        DynamicHub arrayHub = DynamicHub.fromClass(componentType);
        for (int i = 0; i < dimensions.length; ++i) {
            if ((arrayHub = arrayHub.getArrayHub()) != null) continue;
            throw MissingReflectionRegistrationUtils.reportArrayInstantiation(componentType, dimensions.length);
        }
        return Util_java_lang_reflect_Array.createMultiArrayAtIndex(0, arrayHub, dimensions);
    }
}

