/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.RuntimeCPUFeatureCheckImpl;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

final class AMD64CalleeSavedRegisters
extends CalleeSavedRegisters {
    private final List<Register> calleeSavedXMMRegisters;
    private final List<Register> calleeSavedMaskRegisters;
    private final boolean isRuntimeCompilationEnabled;

    @Fold
    public static AMD64CalleeSavedRegisters singleton() {
        return (AMD64CalleeSavedRegisters)CalleeSavedRegisters.singleton();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void createAndRegister() {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        SubstrateAMD64RegisterConfig registerConfig = new SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NORMAL, null, target, SubstrateOptions.PreserveFramePointer.getValue());
        Register frameRegister = registerConfig.getFrameRegister();
        ArrayList<Register> calleeSavedRegisters = new ArrayList<Register>(registerConfig.getAllocatableRegisters());
        ArrayList<Register> calleeSavedXMMRegisters = new ArrayList<Register>();
        ArrayList<Register> calleeSavedMaskRegisters = new ArrayList<Register>();
        boolean isRuntimeCompilationEnabled = RuntimeCompilation.isEnabled();
        if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
            calleeSavedRegisters.remove(SubstrateControlFlowIntegrity.singleton().getCFITargetRegister());
        }
        boolean rbpCalleeSaved = calleeSavedRegisters.remove(AMD64.rbp);
        Collections.reverse(calleeSavedRegisters);
        int offset = 0;
        HashMap<Register, Integer> calleeSavedRegisterOffsets = new HashMap<Register, Integer>();
        for (Register register : calleeSavedRegisters) {
            boolean isMask;
            int reservedSize = 0;
            Register.RegisterCategory category = register.getRegisterCategory();
            boolean isXMM = category.equals((Object)AMD64.XMM);
            if (isXMM) {
                calleeSavedXMMRegisters.add(register);
            }
            if (isMask = category.equals((Object)AMD64.MASK)) {
                calleeSavedMaskRegisters.add(register);
            }
            if (isXMM && isRuntimeCompilationEnabled && AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
                reservedSize = AMD64Kind.V512_QWORD.getSizeInBytes();
            } else if (isMask && isRuntimeCompilationEnabled && AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
                reservedSize = AMD64Kind.MASK64.getSizeInBytes();
            } else if (target.arch.getLargestStorableKind(category) != null) {
                reservedSize = target.arch.getLargestStorableKind(category).getSizeInBytes();
            } else {
                VMError.guarantee(isMask && !target.arch.getFeatures().contains(AMD64.CPUFeature.AVX512F) && (!isRuntimeCompilationEnabled || !AMD64CPUFeatureAccess.canUpdateCPUFeatures()), "unexpected register without largest storable kind: %s", register);
            }
            if (reservedSize > 0) {
                offset = NumUtil.roundUp((int)offset, (int)reservedSize);
            }
            calleeSavedRegisterOffsets.put(register, offset);
            offset += reservedSize;
        }
        int calleeSavedRegistersSizeInBytes = offset;
        int saveAreaOffsetInFrame = -(FrameAccess.returnAddressSize() + FrameAccess.wordSize() + calleeSavedRegistersSizeInBytes);
        if (rbpCalleeSaved) {
            calleeSavedRegisterOffsets.put(AMD64.rbp, calleeSavedRegistersSizeInBytes);
        }
        ImageSingletons.add(CalleeSavedRegisters.class, (Object)new AMD64CalleeSavedRegisters(frameRegister, calleeSavedRegisters, calleeSavedXMMRegisters, calleeSavedMaskRegisters, calleeSavedRegisterOffsets, calleeSavedRegistersSizeInBytes, saveAreaOffsetInFrame, isRuntimeCompilationEnabled));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private AMD64CalleeSavedRegisters(Register frameRegister, List<Register> calleeSavedRegisters, List<Register> calleeSavedXMMRegisters, List<Register> calleeSavedMaskRegisters, Map<Register, Integer> offsetsInSaveArea, int saveAreaSize, int saveAreaOffsetInFrame, boolean isRuntimeCompilationEnabled) {
        super(frameRegister, calleeSavedRegisters, offsetsInSaveArea, saveAreaSize, saveAreaOffsetInFrame);
        this.calleeSavedXMMRegisters = calleeSavedXMMRegisters;
        this.calleeSavedMaskRegisters = calleeSavedMaskRegisters;
        this.isRuntimeCompilationEnabled = isRuntimeCompilationEnabled;
    }

    public void emitSave(AMD64MacroAssembler asm, int frameSize, CompilationResultBuilder crb) {
        if (!SubstrateUtil.HOSTED) {
            GraalError.shouldNotReachHere((String)"hosted mode expected");
            return;
        }
        for (Register register : this.calleeSavedRegisters) {
            AMD64Address address = this.calleeSaveAddress(asm, frameSize, register);
            Register.RegisterCategory category = register.getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                asm.movq(address, register);
                continue;
            }
            if (category.equals((Object)AMD64.XMM) || category.equals((Object)AMD64.MASK)) continue;
            throw VMError.shouldNotReachHereUnexpectedInput(category);
        }
        this.emitXMM(asm, crb, frameSize, Mode.SAVE);
    }

    public void emitRestore(AMD64MacroAssembler asm, int frameSize, Register excludedRegister, CompilationResultBuilder crb) {
        if (!SubstrateUtil.HOSTED) {
            GraalError.shouldNotReachHere((String)"hosted mode expected");
            return;
        }
        for (Register register : this.calleeSavedRegisters) {
            if (register.equals((Object)excludedRegister)) continue;
            AMD64Address address = this.calleeSaveAddress(asm, frameSize, register);
            Register.RegisterCategory category = register.getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                asm.movq(register, address);
                continue;
            }
            if (category.equals((Object)AMD64.XMM) || category.equals((Object)AMD64.MASK)) continue;
            throw VMError.shouldNotReachHereUnexpectedInput(category);
        }
        this.emitXMM(asm, crb, frameSize, Mode.RESTORE);
    }

    private void emitXMM(AMD64MacroAssembler asm, CompilationResultBuilder crb, int frameSize, Mode mode) {
        new XMMSaverRestorer(asm, crb, frameSize, mode).emit();
    }

    private AMD64Address calleeSaveAddress(AMD64MacroAssembler asm, int frameSize, Register register) {
        return asm.makeAddress(this.frameRegister, frameSize + this.getOffsetInFrame(register));
    }

    @Override
    public void dumpRegisters(Log log, Pointer callerSP, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        log.string("Callee saved registers (sp=").zhex((WordBase)callerSP).string(")").indent(true);
        AMD64CalleeSavedRegisters.dumpReg(log, "RAX ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rax), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RBX ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rbx), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RCX ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rcx), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RDX ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rdx), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RBP ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rbp), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RSI ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rsi), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RDI ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rdi), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "RSP ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.rsp), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R8  ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r8), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R9  ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r9), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R10 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r10), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R11 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r11), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R12 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r12), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R13 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r13), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R14 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r14), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        AMD64CalleeSavedRegisters.dumpReg(log, "R15 ", callerSP, AMD64CalleeSavedRegisters.offsetInFrameOrNull(AMD64.r15), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        log.indent(false);
    }

    private static void dumpReg(Log log, String label, Pointer callerSP, int offsetInFrameOrNull, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (offsetInFrameOrNull != 0) {
            long value = callerSP.readLong(offsetInFrameOrNull);
            RegisterDumper.dumpReg(log, label, value, printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        }
    }

    @Fold
    static int offsetInFrameOrNull(Register register) {
        AMD64CalleeSavedRegisters that = AMD64CalleeSavedRegisters.singleton();
        if (that.calleeSaveable(register)) {
            return that.getOffsetInFrame(register);
        }
        return 0;
    }

    private static enum Mode {
        SAVE,
        RESTORE;

    }

    private final class XMMSaverRestorer {
        private final AMD64MacroAssembler asm;
        private final CompilationResultBuilder crb;
        private final int frameSize;
        private final Mode mode;
        private final EnumSet<?> hostedCPUFeatures;

        XMMSaverRestorer(AMD64MacroAssembler asm, CompilationResultBuilder crb, int frameSize, Mode mode) {
            this.asm = asm;
            this.crb = crb;
            this.frameSize = frameSize;
            this.mode = mode;
            this.hostedCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit() {
            assert (AMD64CalleeSavedRegisters.this.isRuntimeCompilationEnabled == RuntimeCompilation.isEnabled()) : "JIT compilation enabled after registering singleton?";
            if (AMD64CalleeSavedRegisters.this.isRuntimeCompilationEnabled && AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
                Label end = new Label();
                try {
                    Label noAVX512BW = new Label();
                    Label noAVX512 = new Label();
                    Label avx512SaveZMM = new Label();
                    this.testFeature(AMD64.CPUFeature.AVX512F, noAVX512);
                    this.enterAvxRegion(AMD64.CPUFeature.AVX512F);
                    this.testFeature(AMD64.CPUFeature.AVX512BW, noAVX512BW);
                    this.enterAvxRegion(AMD64.CPUFeature.AVX512BW);
                    this.kmovq();
                    this.leaveAvxRegion(AMD64.CPUFeature.AVX512BW);
                    this.asm.jmp(avx512SaveZMM);
                    this.asm.bind(noAVX512BW);
                    this.kmovw();
                    this.asm.bind(avx512SaveZMM);
                    this.evmovdqu64();
                    this.leaveAvxRegion(AMD64.CPUFeature.AVX512F);
                    this.jumpToEndOrReturn(AMD64.CPUFeature.AVX512F, end);
                    this.asm.bind(noAVX512);
                    Label noAVX = new Label();
                    this.testFeature(AMD64.CPUFeature.AVX, noAVX);
                    this.enterAvxRegion(AMD64.CPUFeature.AVX);
                    this.vmovdqu();
                    this.leaveAvxRegion(AMD64.CPUFeature.AVX);
                    this.jumpToEndOrReturn(AMD64.CPUFeature.AVX, end);
                    this.asm.bind(noAVX);
                    this.movdqu();
                }
                catch (StaticFeatureException staticFeatureException) {
                }
                finally {
                    this.asm.bind(end);
                }
            } else if (this.hostedCPUFeatures.contains(AMD64.CPUFeature.AVX512F)) {
                if (this.hostedCPUFeatures.contains(AMD64.CPUFeature.AVX512BW)) {
                    this.kmovq();
                } else {
                    this.kmovw();
                }
                this.evmovdqu64();
            } else if (this.hostedCPUFeatures.contains(AMD64.CPUFeature.AVX)) {
                this.vmovdqu();
            } else {
                this.movdqu();
            }
        }

        private void testFeature(AMD64.CPUFeature feature, Label falseLabel) {
            if (!this.hostedCPUFeatures.contains(feature)) {
                this.emitRuntimeFeatureTest(feature, falseLabel);
            }
        }

        private void jumpToEndOrReturn(AMD64.CPUFeature feature, Label end) throws StaticFeatureException {
            if (this.hostedCPUFeatures.contains(feature)) {
                throw new StaticFeatureException();
            }
            this.asm.jmp(end);
        }

        private void enterAvxRegion(AMD64.CPUFeature avxFeature) {
            this.asm.addFeatures(EnumSet.of(AMD64.CPUFeature.AVX, avxFeature));
            boolean isAvxSseTransition = this.asm.isCurrentRegionFeature((Enum)AMD64.CPUFeature.AVX);
            if (isAvxSseTransition && this.mode == Mode.RESTORE) {
                this.asm.vzeroupper();
            }
        }

        private void leaveAvxRegion(AMD64.CPUFeature avxFeature) {
            GraalError.guarantee((boolean)this.asm.supports(avxFeature), (String)"trying to leave region for unset feature %s", (Object)avxFeature);
            boolean isAvxSseTransition = this.asm.isCurrentRegionFeature((Enum)AMD64.CPUFeature.AVX);
            if (isAvxSseTransition && this.mode == Mode.SAVE) {
                this.asm.vzeroupper();
            }
            this.asm.removeFeatures();
        }

        private void emitSaveRestore(List<Register> registers, Register.RegisterCategory requiredCategory, BiConsumer<AMD64Address, Register> saveInstruction, BiConsumer<Register, AMD64Address> restoreInstruction) {
            for (Register register : registers) {
                AMD64Address address = AMD64CalleeSavedRegisters.this.calleeSaveAddress(this.asm, this.frameSize, register);
                Register.RegisterCategory category = register.getRegisterCategory();
                assert (category.equals((Object)requiredCategory));
                if (this.mode == Mode.SAVE) {
                    saveInstruction.accept(address, register);
                    continue;
                }
                restoreInstruction.accept(register, address);
            }
        }

        private void kmovq() {
            this.emitSaveRestore(AMD64CalleeSavedRegisters.this.calleeSavedMaskRegisters, AMD64.MASK, (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).kmovq(arg_0, arg_1), (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).kmovq(arg_0, arg_1));
        }

        private void kmovw() {
            this.emitSaveRestore(AMD64CalleeSavedRegisters.this.calleeSavedMaskRegisters, AMD64.MASK, (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).kmovw(arg_0, arg_1), (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).kmovw(arg_0, arg_1));
        }

        private void evmovdqu64() {
            this.emitSaveRestore(AMD64CalleeSavedRegisters.this.calleeSavedXMMRegisters, AMD64.XMM, (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).evmovdqu64(arg_0, arg_1), (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).evmovdqu64(arg_0, arg_1));
        }

        private void vmovdqu() {
            this.emitSaveRestore(AMD64CalleeSavedRegisters.this.calleeSavedXMMRegisters, AMD64.XMM, (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).vmovdqu(arg_0, arg_1), (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).vmovdqu(arg_0, arg_1));
        }

        private void movdqu() {
            this.emitSaveRestore(AMD64CalleeSavedRegisters.this.calleeSavedXMMRegisters, AMD64.XMM, (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).movdqu(arg_0, arg_1), (arg_0, arg_1) -> ((AMD64MacroAssembler)this.asm).movdqu(arg_0, arg_1));
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private Label emitRuntimeFeatureTest(AMD64.CPUFeature feature, Label falseLabel) {
            AMD64Address address = this.getFeatureMapAddress();
            int mask = RuntimeCPUFeatureCheckImpl.instance().computeFeatureMask(EnumSet.of(feature));
            GraalError.guarantee((mask != 0 ? 1 : 0) != 0, (String)"Mask must not be 0 for features %s", (Object)feature);
            Class<?> fieldType = RuntimeCPUFeatureCheckImpl.getMaskField().getType();
            GraalError.guarantee((boolean)Integer.TYPE.equals(fieldType), (String)"Expected int field, got %s", fieldType);
            AMD64Assembler.AMD64MIOp.TEST.emit((AMD64Assembler)this.asm, AMD64BaseAssembler.OperandSize.DWORD, address, mask, false);
            this.asm.jcc(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
            return falseLabel;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private AMD64Address getFeatureMapAddress() {
            JavaConstant object = this.crb.getSnippetReflection().forObject((Object)RuntimeCPUFeatureCheckImpl.instance());
            int fieldOffset = this.fieldOffset(RuntimeCPUFeatureCheckImpl.getMaskField(this.crb.getMetaAccess()));
            GraalError.guarantee((boolean)ConfigurationValues.getTarget().inlineObjects, (String)"Dynamic feature check for callee saved registers requires inlined objects");
            Register heapBase = ReservedRegisters.singleton().getHeapBaseRegister();
            GraalError.guarantee((heapBase != null ? 1 : 0) != 0, (String)"Heap base register must not be null");
            return new AMD64Address(heapBase, Register.None, Stride.S1, this.displacement(object, this.crb.getConstantReflection()) + fieldOffset, this.displacementAnnotation(object));
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private int fieldOffset(ResolvedJavaField f) {
            SharedField field = (SharedField)f;
            GraalError.guarantee((boolean)field.isAccessed(), (String)"Field not accessed %s", (Object)f);
            return field.getLocation();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private Object displacementAnnotation(JavaConstant constant) {
            if (SubstrateUtil.HOSTED) {
                return constant;
            }
            return null;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private int displacement(JavaConstant constant, ConstantReflectionProvider constantReflection) {
            if (SubstrateUtil.HOSTED) {
                return 0;
            }
            return ((SharedConstantReflectionProvider)constantReflection).getImageHeapOffset(constant);
        }
    }

    private static final class StaticFeatureException
    extends Exception {
        static final long serialVersionUID = -1L;

        private StaticFeatureException() {
        }
    }
}

