/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class AArch64CGlobalDataLoadAddressOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64CGlobalDataLoadAddressOp> TYPE = LIRInstructionClass.create(AArch64CGlobalDataLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue result;
    private final CGlobalDataInfo dataInfo;

    AArch64CGlobalDataLoadAddressOp(CGlobalDataInfo dataInfo, AllocatableValue result) {
        super(TYPE);
        this.dataInfo = dataInfo;
        this.result = result;
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int addressBitSize = this.result.getPlatformKind().getSizeInBytes() * 8;
        assert (addressBitSize == 64);
        crb.compilationResult.recordDataPatch(masm.position(), (Reference)new CGlobalDataReference(this.dataInfo));
        Register resultRegister = ValueUtil.asRegister((Value)this.result);
        if (this.dataInfo.isSymbolReference()) {
            masm.adrpLdr(addressBitSize, resultRegister, resultRegister);
        } else {
            masm.adrpAdd(resultRegister);
        }
    }
}

