/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.CompactingOldGeneration;
import com.oracle.svm.core.genscavenge.CopyingOldGeneration;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapAccounting;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapChunkVisitor;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.RuntimeCodeInfoGCSupportImpl;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.TlabSupport;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapImpl
extends Heap {
    private static final VMMutex REF_MUTEX = new VMMutex("referencePendingList");
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration;
    private final HeapChunkProvider chunkProvider = new HeapChunkProvider();
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final RuntimeCodeInfoGCSupportImpl runtimeCodeInfoGcSupport;
    private final HeapAccounting accounting = new HeapAccounting();
    private final ImageHeapChunkLogger imageHeapChunkLogger = new ImageHeapChunkLogger();
    private AlignedHeapChunk.AlignedHeader lastDynamicHubChunk;
    private Reference<?> refPendingList;
    private volatile long refListOfferCounter;
    private volatile long refListWaiterWakeUpCounter;
    private List<Class<?>> classList;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl() {
        this.gcImpl = new GCImpl();
        this.runtimeCodeInfoGcSupport = new RuntimeCodeInfoGCSupportImpl();
        this.oldGeneration = SerialGCOptions.useCompactingOldGen() ? new CompactingOldGeneration("OldGeneration") : new CopyingOldGeneration("OldGeneration");
        HeapParameters.initialize();
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().add(new DumpHeapSettingsAndStatistics());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().add(new DumpHeapUsage());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().add(new DumpGCPolicy());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().add(new DumpImageHeapInfo());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().add(new DumpChunkInfo());
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ImageHeapInfo[] getImageHeapInfos() {
        return (ImageHeapInfo[])MultiLayeredImageSingleton.getAllLayers(ImageHeapInfo.class);
    }

    @Fold
    static HeapChunkProvider getChunkProvider() {
        return HeapImpl.getHeapImpl().chunkProvider;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objPointer) {
        return this.isInPrimaryImageHeap(objPointer) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(objPointer);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Object obj) {
        return this.isInPrimaryImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Pointer objPointer) {
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            if (!info.isInImageHeap(objPointer)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void suspendAllocation() {
        TlabSupport.suspendAllocationInCurrentThread();
    }

    @Override
    public void resumeAllocation() {
    }

    @Override
    public void walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        this.walkImageHeapObjects(visitor);
        this.walkCollectedHeapObjects(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapImpl.getChunkProvider().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    @Fold
    static ObjectHeaderImpl getObjectHeaderImpl() {
        return HeapImpl.getHeapImpl().objectHeaderImpl;
    }

    @Override
    @Fold
    public GC getGC() {
        return HeapImpl.getHeapImpl().gcImpl;
    }

    @Fold
    static GCImpl getGCImpl() {
        return HeapImpl.getHeapImpl().gcImpl;
    }

    @Override
    @Fold
    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        return this.runtimeCodeInfoGcSupport;
    }

    @Fold
    public static HeapAccounting getAccounting() {
        return HeapImpl.getHeapImpl().accounting;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || VMThreads.SafepointBehavior.ignoresSafepoints();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            throw NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    void logUsage(Log log) {
        this.youngGeneration.logUsage(log);
        this.oldGeneration.logUsage(log);
    }

    void logChunks(Log log, boolean allowUnsafe) {
        this.imageHeapChunkLogger.initialize(log);
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            ImageHeapWalker.walkImageHeapChunks(info, this.imageHeapChunkLogger);
        }
        if (AuxiliaryImageHeap.isPresent()) {
            AuxiliaryImageHeap.singleton().walkHeapChunks(this.imageHeapChunkLogger);
        }
        this.getYoungGeneration().logChunks(log, allowUnsafe);
        this.getOldGeneration().logChunks(log);
        HeapImpl.getChunkProvider().logFreeChunks(log);
    }

    static void logZapValues(Log log) {
        if (HeapParameters.getZapProducedHeapChunks() || HeapParameters.getZapConsumedHeapChunks()) {
            if (HeapParameters.getZapProducedHeapChunks()) {
                log.string("producedHeapChunkZapInt: ").string(" hex: ").spaces(8).hex(HeapParameters.getProducedHeapChunkZapInt()).string(" signed: ").spaces(9).signed(HeapParameters.getProducedHeapChunkZapInt()).string(" unsigned: ").spaces(10).unsigned(HeapParameters.getProducedHeapChunkZapInt()).newline();
                log.string("producedHeapChunkZapWord:").string(" hex: ").hex((WordBase)HeapParameters.getProducedHeapChunkZapWord()).string(" signed: ").signed((WordBase)HeapParameters.getProducedHeapChunkZapWord()).string(" unsigned: ").unsigned((WordBase)HeapParameters.getProducedHeapChunkZapWord()).newline();
            }
            if (HeapParameters.getZapConsumedHeapChunks()) {
                log.string("consumedHeapChunkZapInt: ").string(" hex: ").spaces(8).hex(HeapParameters.getConsumedHeapChunkZapInt()).string(" signed: ").spaces(10).signed(HeapParameters.getConsumedHeapChunkZapInt()).string(" unsigned: ").spaces(10).unsigned(HeapParameters.getConsumedHeapChunkZapInt()).newline();
                log.string("consumedHeapChunkZapWord:").string(" hex: ").hex((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).string(" signed: ").signed((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).string(" unsigned: ").unsigned((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).newline();
            }
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getClassCount() {
        int count = 0;
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            count += info.dynamicHubCount;
        }
        return count;
    }

    @Override
    protected List<Class<?>> getAllClasses() {
        if (this.classList == null) {
            ArrayList<Class<?>> list = this.findAllDynamicHubs();
            MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_STORE);
            this.classList = list;
        }
        return this.classList;
    }

    private ArrayList<Class<?>> findAllDynamicHubs() {
        int dynamicHubCount = this.getClassCount();
        ArrayList list = new ArrayList(dynamicHubCount);
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            HeapImpl.collectDynamicHubs(info, list);
        }
        VMError.guarantee(dynamicHubCount == list.size(), "Found fewer DynamicHubs in the image heap than expected.");
        return list;
    }

    private static void collectDynamicHubs(ImageHeapInfo info, ArrayList<Class<?>> list) {
        try {
            ClassListBuilderVisitor visitor = new ClassListBuilderVisitor(list.size() + info.dynamicHubCount, list);
            ImageHeapWalker.walkRegions(info, visitor);
        }
        catch (FoundAllHubsException foundAllHubsException) {
            // empty catch block
        }
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
        TlabSupport.startupInitialization();
        TlabSupport.initialize(isolateThread);
    }

    @Override
    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    public void detachThread(IsolateThread isolateThread) {
        TlabSupport.disableAndFlushForThread(isolateThread);
    }

    @Fold
    public static boolean usesImageHeapCardMarking() {
        Boolean enabled = SerialGCOptions.ImageHeapCardMarking.getValue();
        if (enabled == Boolean.FALSE || enabled == null && !SerialGCOptions.useRememberedSet()) {
            return false;
        }
        if (enabled == null) {
            return HeapImpl.isImageHeapAligned();
        }
        UserError.guarantee(HeapImpl.isImageHeapAligned(), "Enabling option %s requires a custom image heap alignment at runtime, which cannot be ensured with the current configuration (option %s might be disabled)", SerialGCOptions.ImageHeapCardMarking, SubstrateOptions.SpawnIsolates);
        return true;
    }

    @Override
    @Fold
    public int getPreferredAddressSpaceAlignment() {
        return UnsignedUtils.safeToInt(HeapParameters.getAlignedHeapChunkAlignment());
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        int imageHeapOffset = 0;
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && SubstrateOptions.UseNullRegion.getValue().booleanValue()) {
            imageHeapOffset = NumUtil.safeToInt((long)SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue());
        }
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            int runtimePageSize = 4096;
            imageHeapOffset = NumUtil.roundUp((int)(imageHeapOffset + NumUtil.safeToInt((long)this.startOffset)), (int)runtimePageSize);
        }
        return imageHeapOffset;
    }

    @Fold
    public static boolean isImageHeapAligned() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    public UnsignedWord getImageHeapReservedBytes() {
        return ImageHeapProvider.get().getImageHeapAddressSpaceSize();
    }

    @Override
    public UnsignedWord getImageHeapCommittedBytes() {
        int imageHeapOffset = HeapImpl.getHeapImpl().getImageHeapOffsetInAddressSpace();
        return ImageHeapProvider.get().getImageHeapAddressSpaceSize().subtract(imageHeapOffset);
    }

    @Override
    public void walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor == null) {
            return;
        }
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            ImageHeapWalker.walkImageHeapObjects(info, visitor);
        }
        if (AuxiliaryImageHeap.isPresent()) {
            AuxiliaryImageHeap.singleton().walkObjects(visitor);
        }
    }

    @Override
    public void walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        this.makeParseable();
        this.getYoungGeneration().walkObjects(visitor);
        this.getOldGeneration().walkObjects(visitor);
    }

    @Override
    public void doReferenceHandling() {
        if (ReferenceHandler.isExecutedManually()) {
            GCImpl.doReferenceHandling();
        }
    }

    void makeParseable() {
        this.youngGeneration.makeParseable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Only the GC increments the volatile field 'refListOfferCounter'.")
    void addToReferencePendingList(Reference<?> list) {
        assert (VMOperation.isGCInProgress());
        if (list == null) {
            return;
        }
        REF_MUTEX.lock();
        try {
            if (this.refPendingList != null) {
                Reference<?> current = this.refPendingList;
                Reference<?> next = ReferenceInternals.getNextDiscovered(current);
                while (next != null) {
                    current = next;
                    next = ReferenceInternals.getNextDiscovered(current);
                }
                ReferenceInternals.setNextDiscovered(current, list);
            } else {
                this.refPendingList = list;
                ++this.refListOfferCounter;
                REF_CONDITION.broadcast();
            }
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public boolean hasReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            boolean bl = this.hasReferencePendingListUnsafe();
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean hasReferencePendingListUnsafe() {
        return this.refPendingList != null;
    }

    @Override
    public void waitForReferencePendingList() throws InterruptedException {
        assert (ReferenceHandlerThread.isReferenceHandlerThread());
        long initialOffers = this.refListOfferCounter;
        long initialWakeUps = this.refListWaiterWakeUpCounter;
        if (this.hasReferencePendingList()) {
            return;
        }
        if (Thread.interrupted() || !HeapImpl.waitForPendingReferenceList(initialOffers, initialWakeUps) && Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForPendingReferenceList(long initialOffers, long initialWakeUps) {
        Thread currentThread = Thread.currentThread();
        int oldThreadStatus = PlatformThreads.getThreadStatus(currentThread);
        PlatformThreads.setThreadStatus(currentThread, 657);
        try {
            boolean bl = HeapImpl.transitionToNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
            return bl;
        }
        finally {
            PlatformThreads.setThreadStatus(currentThread, oldThreadStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static boolean transitionToNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        boolean offered = HeapImpl.awaitPendingRefsInNative(initialOffers, initialWakeUps);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="In native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static boolean awaitPendingRefsInNative(long initialOffers, long initialWakeUps) {
        REF_MUTEX.lockNoTransition();
        try {
            while (HeapImpl.getHeapImpl().refListOfferCounter == initialOffers && HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps) {
                REF_CONDITION.blockNoTransition();
            }
            boolean bl = HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We use a lock when incrementing the volatile field 'refListWaiterWakeUpCounter'.")
    public void wakeUpReferencePendingListWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            ++this.refListWaiterWakeUpCounter;
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public Reference<?> getAndClearReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            Reference<?> list = this.refPendingList;
            if (list != null) {
                this.refPendingList = null;
            }
            Reference<?> reference = list;
            return reference;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    public boolean printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        Pointer heapBase = KnownIntrinsics.heapBase();
        if (value.equal((UnsignedWord)heapBase)) {
            log.string("is the heap base");
            return true;
        }
        if (value.aboveThan((UnsignedWord)heapBase) && value.belowThan((UnsignedWord)this.getImageHeapStart())) {
            log.string("points into the protected memory between the heap base and the image heap");
            return true;
        }
        if (this.objectHeaderImpl.isEncodedObjectHeader((Word)value)) {
            log.string("is the encoded object header for an object of type ");
            DynamicHub hub = this.objectHeaderImpl.dynamicHubFromObjectHeader((Word)value);
            log.string(hub.getName());
            return true;
        }
        Pointer ptr = (Pointer)value;
        if (this.printLocationInfo(log, ptr, allowJavaHeapAccess, allowUnsafeOperations)) {
            if (allowJavaHeapAccess && this.objectHeaderImpl.pointsToObjectHeader(ptr)) {
                log.indent(true);
                SubstrateDiagnostics.printObjectInfo(log, ptr.toObject());
                log.redent(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void optionValueChanged(RuntimeOptionKey<?> key) {
        if (!SubstrateUtil.HOSTED) {
            GCImpl.getPolicy().updateSizeParameters();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadAllocatedMemory(IsolateThread thread) {
        Pointer usedTlabSize;
        UnsignedWord allocatedBytes = ThreadLocalAllocation.getAllocatedBytes(thread);
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
        Word start = tlab.getAlignedAllocationStart(SubstrateAllocationSnippets.TLAB_START_IDENTITY);
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        if (top.aboveThan((UnsignedWord)start) && (usedTlabSize = top.subtract((UnsignedWord)start)).belowOrEqual(HeapParameters.getAlignedHeapChunkSize())) {
            return allocatedBytes.add((UnsignedWord)usedTlabSize).rawValue();
        }
        return allocatedBytes.rawValue();
    }

    @Override
    @Uninterruptible(reason="Ensure that no GC can occur between modification of the object and this call.", callerMustBe=true)
    public void dirtyAllReferencesOf(Object obj) {
        if (obj == null) {
            return;
        }
        RememberedSet.get().dirtyAllReferencesIfNecessary(obj);
    }

    @Override
    public long getMillisSinceLastWholeHeapExamined() {
        return HeapImpl.getGCImpl().getMillisSinceLastWholeHeapExamined();
    }

    @Override
    @Uninterruptible(reason="Ensure that no GC can move the object to another chunk.", callerMustBe=true)
    public long getIdentityHashSalt(Object obj) {
        if (!GraalDirectives.inIntrinsic()) assert (!this.isInImageHeap(obj)) : "Image heap objects have identity hash code fields";
        HeapChunk.Header<?> chunk = HeapChunk.getEnclosingHeapChunk(obj);
        return HeapChunk.getIdentityHashSalt(chunk).rawValue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getUsedMemoryAfterLastGC() {
        return this.accounting.getUsedBytes();
    }

    private boolean printLocationInfo(Log log, Pointer ptr, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            if (info.isInReadOnlyRegularPartition(ptr)) {
                log.string("points into the image heap (read-only)");
                return true;
            }
            if (info.isInReadOnlyRelocatablePartition(ptr)) {
                log.string("points into the image heap (read-only relocatables)");
                return true;
            }
            if (info.isInWritablePatchedPartition(ptr)) {
                log.string("points into the image heap (writable patched)");
                return true;
            }
            if (info.isInWritableRegularPartition(ptr)) {
                log.string("points into the image heap (writable)");
                return true;
            }
            if (info.isInWritableHugePartition(ptr)) {
                log.string("points into the image heap (writable huge)");
                return true;
            }
            if (!info.isInReadOnlyHugePartition(ptr)) continue;
            log.string("points into the image heap (read-only huge)");
            return true;
        }
        if (AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(ptr)) {
            log.string("points into the auxiliary image heap");
            return true;
        }
        if (TlabSupport.printTlabInfo(log, ptr, CurrentIsolate.getCurrentThread())) {
            return true;
        }
        if (allowJavaHeapAccess) {
            if (this.youngGeneration.printLocationInfo(log, ptr)) {
                return true;
            }
            if (this.oldGeneration.printLocationInfo(log, ptr)) {
                return true;
            }
        }
        if ((allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) && TlabSupport.printTlabInfo(log, ptr)) {
            return true;
        }
        return allowJavaHeapAccess && YoungGeneration.getHeapAllocation().printLocationInfo(log, ptr);
    }

    boolean isInHeap(Pointer ptr) {
        return this.isInImageHeap(ptr) || this.youngGeneration.isInSpace(ptr) || this.oldGeneration.isInSpace(ptr);
    }

    @Override
    @Uninterruptible(reason="Called during early startup.")
    public boolean verifyImageHeapMapping() {
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            HeapImpl.writeToEachChunk(info.getFirstWritableAlignedChunk(), (HeapChunk.Header)Word.nullPointer());
            HeapImpl.writeToEachChunk(info.getFirstWritableUnalignedChunk(), info.getLastWritableUnalignedChunk());
        }
        return true;
    }

    @Uninterruptible(reason="Called during early startup.")
    private static void writeToEachChunk(HeapChunk.Header<?> firstChunk, HeapChunk.Header<?> lastChunk) {
        HeapChunk.Header<?> curChunk = firstChunk;
        while (curChunk.isNonNull()) {
            Pointer begin = (Pointer)curChunk;
            Pointer end = HeapChunk.getTopPointer(curChunk).subtract(1);
            byte val = begin.readByte(0);
            begin.writeByte(0, val);
            val = end.readByte(0);
            end.writeByte(0, val);
            if (curChunk.equal((ComparableWord)lastChunk)) break;
            curChunk = HeapChunk.getNext(curChunk);
        }
    }

    public static DynamicHub allocateDynamicHub(int vTableSlots) {
        AllocateDynamicHubOp vmOp = new AllocateDynamicHubOp(vTableSlots);
        vmOp.enqueue();
        return vmOp.result;
    }

    private static final class ImageHeapChunkLogger
    implements HeapChunkVisitor {
        private Log log;

        private ImageHeapChunkLogger() {
        }

        void initialize(Log log) {
            this.log = log;
        }

        @Override
        public void visitAlignedChunk(AlignedHeapChunk.AlignedHeader chunk) {
            Pointer bottom = AlignedHeapChunk.getObjectsStart(chunk);
            Pointer top = HeapChunk.getTopPointer(chunk);
            Pointer end = AlignedHeapChunk.getObjectsEnd(chunk);
            HeapChunkLogging.logChunk(this.log, chunk, bottom, top, end, true, "I", false);
        }

        @Override
        public void visitUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
            Pointer bottom = UnalignedHeapChunk.getObjectStart(chunk);
            Pointer top = HeapChunk.getTopPointer(chunk);
            Pointer end = UnalignedHeapChunk.getObjectEnd(chunk);
            HeapChunkLogging.logChunk(this.log, chunk, bottom, top, end, false, "I", false);
        }
    }

    private static final class DumpHeapSettingsAndStatistics
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpHeapSettingsAndStatistics() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Heap settings and statistics:").indent(true);
            log.string("Reserved hub pointer bits: 0b").number(Heap.getHeap().getObjectHeader().getReservedHubBitsMask(), 2, false).newline();
            log.string("Aligned chunk size: ").unsigned((WordBase)HeapParameters.getAlignedHeapChunkSize()).newline();
            log.string("Large array threshold: ").unsigned((WordBase)HeapParameters.getLargeArrayThreshold()).newline();
            GCAccounting accounting = GCImpl.getAccounting();
            log.string("Incremental collections: ").unsigned(accounting.getIncrementalCollectionCount()).newline();
            log.string("Complete collections: ").unsigned(accounting.getCompleteCollectionCount()).newline();
            HeapImpl.logZapValues(log);
            log.indent(false);
        }
    }

    private static final class DumpHeapUsage
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpHeapUsage() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Heap usage:").indent(true);
            HeapImpl.getHeapImpl().logUsage(log);
            log.indent(false);
        }
    }

    private static final class DumpGCPolicy
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpGCPolicy() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            CollectionPolicy policy = GCImpl.getPolicy();
            log.string("GC policy:").indent(true);
            log.string("Name: ").string(policy.getName()).newline();
            log.string("Max eden size: ").unsigned((WordBase)policy.getMaximumEdenSize()).newline();
            log.string("Max survivor size: ").unsigned((WordBase)policy.getMaximumSurvivorSize()).newline();
            log.string("Max young size: ").unsigned((WordBase)policy.getMaximumYoungGenerationSize()).newline();
            log.string("Max old size: ").unsigned((WordBase)policy.getMaximumOldSize()).newline();
            log.string("Max heap size: ").unsigned((WordBase)policy.getMaximumHeapSize()).newline();
            log.indent(false);
        }
    }

    private static final class DumpImageHeapInfo
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpImageHeapInfo() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            ImageHeapInfo auxHeapInfo;
            log.string("Image heap boundaries:").indent(true);
            for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
                info.print(log);
            }
            log.indent(false);
            if (AuxiliaryImageHeap.isPresent() && (auxHeapInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                log.string("Auxiliary image heap boundaries:").indent(true);
                auxHeapInfo.print(log);
                log.indent(false);
            }
        }
    }

    private static final class DumpChunkInfo
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpChunkInfo() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Heap chunks: E=eden, S=survivor, O=old, F=free; A=aligned chunk, U=unaligned chunk; T=to space").indent(true);
            boolean allowUnsafe = invocationCount == 1 && SubstrateDiagnostics.DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel);
            HeapImpl.getHeapImpl().logChunks(log, allowUnsafe);
            log.indent(false);
        }
    }

    private static class ClassListBuilderVisitor
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private static final FoundAllHubsException FOUND_ALL_HUBS_EXCEPTION = new FoundAllHubsException();
        private final int dynamicHubCount;
        private final List<Class<?>> list;

        ClassListBuilderVisitor(int dynamicHubCount, List<Class<?>> list) {
            this.dynamicHubCount = dynamicHubCount;
            this.list = list;
        }

        @Override
        public <T> void visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && !access.consistsOfHugeObjects(region)) {
                access.visitObjects(region, this);
            }
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocation is fine: this method traverses only the image heap.")
        public void visitObject(Object o) {
            if (o instanceof Class) {
                this.list.add((Class)o);
                if (this.list.size() == this.dynamicHubCount) {
                    throw FOUND_ALL_HUBS_EXCEPTION;
                }
            }
        }
    }

    private static final class FoundAllHubsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private FoundAllHubsException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class AllocateDynamicHubOp
    extends JavaVMOperation {
        int vTableSlots;
        DynamicHub result;

        AllocateDynamicHubOp(int vTableSlots) {
            super(VMOperationInfos.get(AllocateDynamicHubOp.class, "Allocate DynamicHub", VMOperation.SystemEffect.SAFEPOINT));
            this.vTableSlots = vTableSlots;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isGC() {
            return true;
        }

        @Override
        protected void operate() {
            DynamicHub hubOfDynamicHub = DynamicHub.fromClass(Class.class);
            UnsignedWord size = LayoutEncoding.getArrayAllocationSize(hubOfDynamicHub.getLayoutEncoding(), this.vTableSlots);
            Pointer memory = (Pointer)Word.nullPointer();
            if (HeapImpl.getHeapImpl().lastDynamicHubChunk.isNonNull()) {
                memory = AlignedHeapChunk.allocateMemory(HeapImpl.getHeapImpl().lastDynamicHubChunk, size);
            }
            if (memory.isNull()) {
                AllocateDynamicHubOp.allocateNewDynamicHubChunk();
                memory = AlignedHeapChunk.allocateMemory(HeapImpl.getHeapImpl().lastDynamicHubChunk, size);
            }
            VMError.guarantee(memory.isNonNull(), "failed to allocate DynamicHub");
            boolean unaligned = false;
            this.result = (DynamicHub)FormatArrayNode.formatArray(memory, DynamicHub.class, this.vTableSlots, true, unaligned, AllocationSnippets.FillContent.WITH_ZEROES, true);
        }

        private static void allocateNewDynamicHubChunk() {
            OldGeneration oldGeneration = HeapImpl.getHeapImpl().getOldGeneration();
            HeapImpl.getHeapImpl().lastDynamicHubChunk = oldGeneration.requestAlignedChunk();
            oldGeneration.appendChunk(HeapImpl.getHeapImpl().lastDynamicHubChunk);
        }
    }
}

