/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.TreeMap;
import jdk.graal.compiler.debug.Assertions;

public class ChunkedImageHeapPartition
implements ImageHeapPartition {
    private final String name;
    private final boolean writable;
    private final boolean hugeObjects;
    private final int minimumObjectSize;
    private final List<ImageHeapObject> objects = new ArrayList<ImageHeapObject>();
    Object firstObject;
    Object lastObject;
    long startOffset = -1L;
    long endOffset = -1L;

    ChunkedImageHeapPartition(String name, boolean writable, boolean hugeObjects) {
        this.name = name;
        this.writable = writable;
        this.hugeObjects = hugeObjects;
        this.minimumObjectSize = ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize();
    }

    void assign(ImageHeapObject obj) {
        assert (obj.getPartition() == this) : obj;
        this.objects.add(obj);
    }

    void layout(ChunkedImageHeapAllocator allocator, ImageHeapLayouter.ImageHeapLayouterControl control) {
        if (this.hugeObjects) {
            this.layoutInUnalignedChunks(allocator, control);
        } else {
            this.layoutInAlignedChunks(allocator, control);
        }
    }

    private void layoutInUnalignedChunks(ChunkedImageHeapAllocator allocator, ImageHeapLayouter.ImageHeapLayouterControl control) {
        if (this.objects.isEmpty()) {
            this.endOffset = this.startOffset = allocator.getPosition();
            return;
        }
        allocator.finishAlignedChunk();
        this.startOffset = allocator.getPosition();
        for (ImageHeapObject info : this.objects) {
            this.appendAllocatedObject(info, allocator.allocateUnalignedChunkForObject(info, this.isWritable()));
            control.poll();
        }
        this.endOffset = allocator.getPosition();
    }

    private void layoutInAlignedChunks(ChunkedImageHeapAllocator allocator, ImageHeapLayouter.ImageHeapLayouterControl control) {
        allocator.maybeStartAlignedChunk();
        this.startOffset = allocator.getPosition();
        this.allocateObjectsInAlignedChunks(allocator, control);
        this.endOffset = allocator.getPosition();
    }

    private void allocateObjectsInAlignedChunks(ChunkedImageHeapAllocator allocator, ImageHeapLayouter.ImageHeapLayouterControl control) {
        NavigableMap<Long, Queue<ImageHeapObject>> sortedObjects = this.createSortedObjectsMap();
        while (!sortedObjects.isEmpty()) {
            ImageHeapObject info = this.dequeueBestFit(sortedObjects, allocator.getRemainingBytesInAlignedChunk());
            if (info == null) {
                allocator.startNewAlignedChunk();
                control.poll();
                continue;
            }
            this.appendAllocatedObject(info, allocator.allocateObjectInAlignedChunk(info, this.isWritable()));
        }
    }

    private ImageHeapObject dequeueBestFit(NavigableMap<Long, Queue<ImageHeapObject>> sortedObjects, long nbytes) {
        if (nbytes < (long)this.minimumObjectSize) {
            return null;
        }
        Long floorKey = sortedObjects.floorKey(nbytes);
        if (floorKey == null) {
            return null;
        }
        Queue queue = (Queue)sortedObjects.get(floorKey);
        ImageHeapObject obj = (ImageHeapObject)queue.remove();
        if (queue.isEmpty()) {
            sortedObjects.remove(floorKey);
        }
        return obj;
    }

    private NavigableMap<Long, Queue<ImageHeapObject>> createSortedObjectsMap() {
        TreeMap<Long, Queue<ImageHeapObject>> map = new TreeMap<Long, Queue<ImageHeapObject>>();
        for (ImageHeapObject obj : this.objects) {
            long objSize = obj.getSize();
            assert (objSize >= (long)ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize()) : Assertions.errorMessage((Object[])new Object[]{obj, objSize});
            Queue q = map.computeIfAbsent(objSize, k -> new ArrayDeque());
            q.add(obj);
        }
        return map;
    }

    private void appendAllocatedObject(ImageHeapObject info, long allocationOffset) {
        if (this.firstObject == null) {
            this.firstObject = info.getWrapped();
        }
        assert (info.getPartition() == this);
        long offsetInPartition = allocationOffset - this.startOffset;
        assert (ConfigurationValues.getObjectLayout().isAligned(offsetInPartition)) : "start: " + offsetInPartition + " must be aligned.";
        info.setOffsetInPartition(offsetInPartition);
        this.lastObject = info.getWrapped();
    }

    @Override
    public String getName() {
        return this.name;
    }

    boolean isWritable() {
        return this.writable;
    }

    boolean usesUnalignedObjects() {
        return this.hugeObjects;
    }

    @Override
    public long getStartOffset() {
        assert (this.startOffset >= 0L) : "Start offset not yet set";
        return this.startOffset;
    }

    long getEndOffset() {
        assert (this.endOffset >= 0L) : "End offset not yet set";
        return this.endOffset;
    }

    @Override
    public long getSize() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public String toString() {
        return this.name;
    }
}

