/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class VMNativeMemoryDCmd
extends AbstractDCmd {
    private static final DCmdOption<Boolean> SUMMARY = new DCmdOption<Boolean>(Boolean.class, "summary", "Request runtime to report current memory summary, which includes total reserved and committed memory, along with memory usage summary by each subsystem.", false, false);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/nmt/nmtDCmd.hpp#L49-L52"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/nmt/nmtDCmd.cpp#L34-L64")})
    public VMNativeMemoryDCmd() {
        super("VM.native_memory", "Print native memory usage", DCmd.Impact.Low, new DCmdOption[0], new DCmdOption[]{SUMMARY}, new String[]{"$ jcmd <pid> VM.native_memory summary"});
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/nmt/nmtDCmd.cpp#L72-L149")
    public String execute(DCmdArguments args) throws Throwable {
        boolean summary = args.get(SUMMARY);
        if (args.hasBeenSet(SUMMARY) && !summary) {
            return "No command to execute.";
        }
        return NativeMemoryTracking.singleton().generateReportString();
    }
}

