/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.Counter;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class RuntimeCodeCache {
    private final Counter.Group counters = new Counter.Group(CodeInfoTable.Options.CodeCacheCounters, "RuntimeCodeInfo");
    private final Counter lookupMethodCount = new Counter(this.counters, "lookupMethod", "");
    private final Counter addMethodCount = new Counter(this.counters, "addMethod", "");
    private final Counter invalidateMethodCount = new Counter(this.counters, "invalidateMethod", "");
    private final CodeNotOnStackVerifier codeNotOnStackVerifier = new CodeNotOnStackVerifier();
    private static final int INITIAL_TABLE_SIZE = 100;
    private NonmovableArray<UntetheredCodeInfo> codeInfos;
    private int numCodeInfos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeCodeCache() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        this.codeInfos = NonmovableArrays.nullArray();
        this.numCodeInfos = 0;
        RuntimeCodeInfoMemory.singleton().tearDown();
    }

    @Uninterruptible(reason="codeInfos is accessed without holding a lock, so must not be interrupted by a safepoint that can add/remove code", callerMustBe=true)
    protected UntetheredCodeInfo lookupCodeInfo(CodePointer ip) {
        this.lookupMethodCount.inc();
        assert (this.verifyTable());
        if (this.numCodeInfos == 0) {
            return (UntetheredCodeInfo)Word.nullPointer();
        }
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, ip);
        if (idx >= 0) {
            return NonmovableArrays.getWord(this.codeInfos, idx);
        }
        int insertionPoint = -idx - 1;
        if (insertionPoint == 0) {
            assert (((UnsignedWord)ip).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, 0))));
            return (UntetheredCodeInfo)Word.nullPointer();
        }
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, insertionPoint - 1);
        assert (((UnsignedWord)ip).aboveThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)));
        if (((UnsignedWord)ip).subtract((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)).aboveOrEqual(UntetheredCodeInfoAccess.getCodeSize(info))) {
            return (UntetheredCodeInfo)Word.nullPointer();
        }
        return info;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int binarySearch(NonmovableArray<UntetheredCodeInfo> a, int fromIndex, int toIndex, CodePointer key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CodePointer midVal = UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(a, mid));
            if (((UnsignedWord)midVal).belowThan((UnsignedWord)key)) {
                low = mid + 1;
                continue;
            }
            if (((UnsignedWord)midVal).aboveThan((UnsignedWord)key)) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static RawFileOperationSupport getFileSupport() {
        return RawFileOperationSupport.bigEndian();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpMethod(CodeInfo info) {
        String tmpDirPath = RuntimeCodeCache.getFileSupport().getTempDirectory();
        String prefix = System.nanoTime() + "_";
        String methodName = SubstrateUtil.sanitizeForFileName(CodeInfoAccess.getName(info));
        String suffix = "_" + CodeInfoAccess.getTier(info) + ".bin";
        int maxMethodNameSize = 255 - prefix.length() - suffix.length();
        if (methodName.length() > maxMethodNameSize) {
            methodName = methodName.substring(maxMethodNameSize);
        }
        String filePath = tmpDirPath + "/" + prefix + methodName + suffix;
        RawFileOperationSupport.RawFileDescriptor fd = RuntimeCodeCache.getFileSupport().create(filePath, RawFileOperationSupport.FileCreationMode.CREATE_OR_REPLACE, RawFileOperationSupport.FileAccessMode.WRITE);
        if (!RuntimeCodeCache.getFileSupport().isValid(fd)) {
            Log.log().string("Failed to dump runtime compiled code: '").string(filePath).string("' could not be created.").newline();
            return;
        }
        try {
            CCharPointer codeStart = (CCharPointer)CodeInfoAccess.getCodeStart(info);
            UnsignedWord codeSize = CodeInfoAccess.getCodeSize(info);
            if (!RawFileOperationSupport.bigEndian().write(fd, (Pointer)codeStart, codeSize)) {
                Log.log().string("Dumping method to ").string(filePath).string(" failed").newline();
            }
        }
        finally {
            RuntimeCodeCache.getFileSupport().close(fd);
        }
    }

    public void addMethod(CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint()) : "invalid state";
        InstalledCodeObserverSupport.activateObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        this.addMethod0(info);
        RuntimeCodeInfoHistory.singleton().logAdd(info);
        if (SubstrateOptions.hasDumpRuntimeCompiledMethodsSupport()) {
            RuntimeCodeCache.dumpMethod(info);
        }
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void addMethod0(CodeInfo info) {
        this.addMethodCount.inc();
        assert (this.verifyTable());
        if (this.codeInfos.isNull() || this.numCodeInfos >= NonmovableArrays.lengthOf(this.codeInfos)) {
            this.enlargeTable();
            assert (this.verifyTable());
        }
        assert (this.numCodeInfos < NonmovableArrays.lengthOf(this.codeInfos));
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx < 0) : "must not find code already in table";
        int insertionPoint = -idx - 1;
        NonmovableArrays.arraycopy(this.codeInfos, insertionPoint, this.codeInfos, insertionPoint + 1, this.numCodeInfos - insertionPoint);
        ++this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, insertionPoint, info);
        assert (this.verifyTable());
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void enlargeTable() {
        int newTableSize = this.numCodeInfos * 2;
        if (newTableSize < 100) {
            newTableSize = 100;
        }
        NonmovableArray newCodeInfos = NonmovableArrays.createWordArray(newTableSize, NmtCategory.Code);
        if (this.codeInfos.isNonNull()) {
            NonmovableArrays.arraycopy(this.codeInfos, 0, newCodeInfos, 0, NonmovableArrays.lengthOf(this.codeInfos));
            NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        }
        this.codeInfos = newCodeInfos;
    }

    protected void invalidateMethod(CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint()) : "illegal state";
        this.prepareInvalidation(info);
        Deoptimizer.deoptimizeInRange(CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), false, CurrentIsolate.getCurrentThread());
        boolean removeNow = Deoptimizer.Options.LazyDeoptimization.getValue() == false;
        this.continueInvalidation(info, removeNow);
    }

    protected void invalidateNonStackMethod(CodeInfo info) {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
        this.prepareInvalidation(info);
        assert (this.codeNotOnStackVerifier.verify(info));
        this.continueInvalidation(info, true);
    }

    private void prepareInvalidation(CodeInfo info) {
        this.invalidateMethodCount.inc();
        assert (this.verifyTable());
        SubstrateInstalledCode installedCode = RuntimeCodeInfoAccess.getInstalledCode(info);
        if (installedCode != null) {
            assert (!installedCode.isAlive() || CodeInfoAccess.getCodeStart(info).rawValue() == installedCode.getAddress()) : installedCode;
            installedCode.clearAddress();
        }
    }

    private void continueInvalidation(CodeInfo info, boolean removeNow) {
        InstalledCodeObserverSupport.removeObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        if (removeNow) {
            this.removeFromCodeCache(info);
            RuntimeCodeInfoHistory.singleton().logInvalidate(info);
        } else if (CodeInfoAccess.getState(info) < 2) {
            CodeInfoAccess.setState(info, 2);
            RuntimeCodeInfoHistory.singleton().logInvalidate(info);
        }
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void removeFromCodeCache(CodeInfo info) {
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx >= 0) : "info must be in table";
        NonmovableArrays.arraycopy(this.codeInfos, idx + 1, this.codeInfos, idx, this.numCodeInfos - (idx + 1));
        --this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, this.numCodeInfos, (UntetheredCodeInfo)Word.nullPointer());
        RuntimeCodeInfoAccess.markAsRemovedFromCodeCache(info);
        assert (this.verifyTable());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean verifyTable() {
        int i;
        if (this.codeInfos.isNull()) {
            assert (this.numCodeInfos == 0) : "a1";
            return true;
        }
        assert (this.numCodeInfos <= NonmovableArrays.lengthOf(this.codeInfos)) : "a11";
        for (i = 0; i < this.numCodeInfos; ++i) {
            UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, i);
            assert (info.isNonNull()) : "a20";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i)))) : "a22";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeEnd(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowOrEqual((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info))) : "a23";
        }
        for (i = this.numCodeInfos; i < NonmovableArrays.lengthOf(this.codeInfos); ++i) {
            assert (NonmovableArrays.getWord(this.codeInfos, i).isNull()) : "a31";
        }
        return true;
    }

    private static final class CodeNotOnStackVerifier
    extends StackFrameVisitor {
        private CodeInfo codeInfoToCheck;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeNotOnStackVerifier() {
        }

        @NeverInline(value="Starting a stack walk.")
        public boolean verify(CodeInfo info) {
            this.codeInfoToCheck = info;
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            JavaStackWalker.walkCurrentThread(sp, this);
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    JavaStackWalker.walkThread(vmThread, this);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            return true;
        }

        @Override
        public boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo currentCodeInfo) {
            assert (currentCodeInfo != this.codeInfoToCheck) : currentCodeInfo.rawValue();
            return true;
        }

        @Override
        protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
            return true;
        }
    }

    public static interface CodeInfoVisitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting code.")
        public void visitCode(CodeInfo var1);
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> TraceCodeCache = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> WriteableCodeCache = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue() && !SubstrateUtil.HOSTED && Platform.includedIn(Platform.AARCH64.class)) {
                    throw new IllegalArgumentException("Enabling " + this.getName() + " is not supported on this platform.");
                }
            }
        };
    }
}

