/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.JavaValue;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class ReservedRegisters {
    protected final Register frameRegister;
    protected final Register threadRegister;
    protected final Register heapBaseRegister;
    protected final Register codeBaseRegister;

    @Fold
    public static ReservedRegisters singleton() {
        return (ReservedRegisters)ImageSingletons.lookup(ReservedRegisters.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ReservedRegisters(Register frameRegister, Register threadRegister, Register heapBaseRegister, Register codeBaseRegisterCandidate) {
        this.frameRegister = frameRegister;
        this.threadRegister = threadRegister;
        this.heapBaseRegister = heapBaseRegister;
        this.codeBaseRegister = SubstrateOptions.useRelativeCodePointers() ? codeBaseRegisterCandidate : null;
    }

    public Register getFrameRegister() {
        return this.frameRegister;
    }

    public Register getThreadRegister() {
        return this.threadRegister;
    }

    public Register getHeapBaseRegister() {
        return this.heapBaseRegister;
    }

    public Register getCodeBaseRegister() {
        return this.codeBaseRegister;
    }

    public boolean isAllowedInFrameState(JavaValue value) {
        if (value instanceof RegisterValue) {
            RegisterValue rv = (RegisterValue)value;
            Register r = rv.getRegister();
            return r.equals((Object)this.threadRegister) || r.equals((Object)this.heapBaseRegister) || r.equals((Object)this.codeBaseRegister);
        }
        return false;
    }

    public boolean isReservedRegister(Register r) {
        return r.equals((Object)this.frameRegister) || r.equals((Object)this.heapBaseRegister) || r.equals((Object)this.threadRegister) || r.equals((Object)this.codeBaseRegister);
    }
}

