/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class FutureDefaultsOptions {
    private static final String OPTION_NAME = "future-defaults";
    private static final String ALL_NAME = "all";
    private static final String RUN_TIME_INITIALIZE_JDK = "run-time-initialize-jdk";
    private static final String NONE_NAME = "none";
    private static final List<String> ALL_COMMANDS = List.of("all", "none", "run-time-initialize-jdk");
    private static final String RUN_TIME_INITIALIZE_SECURITY_PROVIDERS = "run-time-initialize-security-providers";
    private static final String RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS = "run-time-initialize-file-system-providers";
    private static final String COMPLETE_REFLECTION_TYPES = "complete-reflection-types";
    private static final List<String> ALL_FUTURE_DEFAULTS = List.of("run-time-initialize-file-system-providers", "run-time-initialize-security-providers", "complete-reflection-types");
    public static final String RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS_REASON = "Initialize JDK classes at run time (--future-defaults includes run-time-initialize-security-providers)";
    public static final String RUN_TIME_INITIALIZE_SECURITY_PROVIDERS_REASON = "Initialize JDK classes at run time (--future-defaults includes run-time-initialize-file-system-providers)";
    private static final String DEFAULT_NAME = "<default-value>";
    public static final String SYSTEM_PROPERTY_PREFIX = "org.graalvm.nativeimage.future-defaults.";
    @APIOption(name={"future-defaults"}, defaultValue={"<default-value>"})
    static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> FutureDefaults = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    private static Set<String> futureDefaults;

    private static String futureDefaultsAllValues() {
        return StringUtil.joinSingleQuoted(FutureDefaultsOptions.getAllValues());
    }

    private static LinkedHashSet<String> getAllValues() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(ALL_FUTURE_DEFAULTS.size() + ALL_COMMANDS.size());
        result.addAll(ALL_COMMANDS);
        result.addAll(ALL_FUTURE_DEFAULTS);
        return result;
    }

    private static String getOptionHelpText() {
        Objects.requireNonNull(FutureDefaults.getDescriptor(), "This must be called after the options are processed.");
        return FutureDefaults.getDescriptor().getHelp().stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private static void verifyOptionDescription() {
        String optionHelpText = FutureDefaultsOptions.getOptionHelpText();
        VMError.guarantee(FutureDefaultsOptions.getAllValues().stream().allMatch(FutureDefaultsOptions.futureDefaultsAllValues()::contains), "A value is missing in the user-facing help text");
        for (String optionValue : FutureDefaultsOptions.getAllValues()) {
            if (optionHelpText.contains(optionValue + "' -")) continue;
            throw VMError.shouldNotReachHere("Must mention all options in the list of options. Missing option: " + optionValue);
        }
        if (!optionHelpText.contains(FutureDefaultsOptions.futureDefaultsAllValues())) {
            throw VMError.shouldNotReachHere("Must mention all options in a comma-separated sequence: " + FutureDefaultsOptions.futureDefaultsAllValues());
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void parseAndVerifyOptions() {
        FutureDefaultsOptions.verifyOptionDescription();
        futureDefaults = new LinkedHashSet<String>(FutureDefaultsOptions.getAllValues().size());
        Stream<LocatableMultiOptionValue.ValueWithOrigin<LocatableMultiOptionValue.ValueWithOrigin>> valuesWithOrigin = FutureDefaults.getValue().getValuesWithOrigins();
        valuesWithOrigin.forEach(valueWithOrigin -> {
            String value = (String)valueWithOrigin.value();
            if (DEFAULT_NAME.equals(value)) {
                throw UserError.abort("The '%s' from %s is forbidden. It can only contain: %s.%n%nUsage:%n%n%s", SubstrateOptionsParser.commandArgument(FutureDefaults, DEFAULT_NAME), valueWithOrigin.origin(), FutureDefaultsOptions.futureDefaultsAllValues(), FutureDefaultsOptions.getOptionHelpText());
            }
            if (!FutureDefaultsOptions.getAllValues().contains(value)) {
                throw UserError.abort("The '%s' option from %s contains invalid value '%s'. It can only contain: %s.%n%nUsage:%n%n%s", SubstrateOptionsParser.commandArgument(FutureDefaults, value), valueWithOrigin.origin(), value, FutureDefaultsOptions.futureDefaultsAllValues(), FutureDefaultsOptions.getOptionHelpText());
            }
            if (value.equals(NONE_NAME)) {
                if (!valueWithOrigin.origin().commandLineLike()) {
                    throw UserError.abort("The '%s' option can only be used from the command line. Detected usage from %s.", SubstrateOptionsParser.commandArgument(FutureDefaults, NONE_NAME), valueWithOrigin.origin());
                }
                futureDefaults.clear();
            }
            if (value.equals(ALL_NAME)) {
                futureDefaults.addAll(ALL_FUTURE_DEFAULTS);
            } else if (value.equals(RUN_TIME_INITIALIZE_JDK)) {
                futureDefaults.addAll(List.of(RUN_TIME_INITIALIZE_SECURITY_PROVIDERS, RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS));
            } else {
                futureDefaults.add(value);
            }
        });
        for (String futureDefault : FutureDefaultsOptions.getFutureDefaults()) {
            System.setProperty(SYSTEM_PROPERTY_PREFIX + futureDefault, Boolean.TRUE.toString());
        }
    }

    public static Set<String> getFutureDefaults() {
        return Collections.unmodifiableSet(Objects.requireNonNull(futureDefaults, "must be initialized before usage"));
    }

    public static boolean allFutureDefaults() {
        return FutureDefaultsOptions.getFutureDefaults().containsAll(ALL_FUTURE_DEFAULTS);
    }

    public static boolean completeReflectionTypes() {
        return FutureDefaultsOptions.getFutureDefaults().contains(COMPLETE_REFLECTION_TYPES);
    }

    public static boolean securityProvidersInitializedAtRunTime() {
        return FutureDefaultsOptions.getFutureDefaults().contains(RUN_TIME_INITIALIZE_SECURITY_PROVIDERS);
    }

    public static boolean fileSystemProvidersInitializedAtRunTime() {
        return FutureDefaultsOptions.getFutureDefaults().contains(RUN_TIME_INITIALIZE_FILE_SYSTEM_PROVIDERS);
    }
}

