/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.interpreter.DebuggerSupport;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ClassUtils {
    private ClassUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static String getNameAsString(ResolvedJavaType type) {
        return type.toClassName();
    }

    public static String getTypeAsString(ResolvedJavaType type) {
        return type.getName();
    }

    public static String getGenericTypeAsString(ResolvedJavaType type) {
        return "";
    }

    public static int getStatus(ResolvedJavaType type) {
        Class<?> clazz = DebuggerSupport.singleton().getUniverse().lookupClass(type);
        int status = 3;
        DynamicHub hub = DynamicHub.fromClass(clazz);
        if (hub.isLoaded()) {
            status |= 0;
        }
        if (hub.isInitialized()) {
            status |= 4;
        }
        if (hub.getClassInitializationInfo().isInErrorState()) {
            status |= 8;
        }
        return status;
    }
}

