/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContextImpl;
import com.oracle.svm.interpreter.metadata.serialization.ValueWriter;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class WriterImpl
extends SerializationContextImpl
implements SerializationContext.Writer {
    private final Set<Object> cycleDetector = Collections.newSetFromMap(new IdentityHashMap());
    private final ValueWriter.Resolver writerResolver;

    WriterImpl(List<Class<?>> knownClasses, ValueWriter.Resolver writerResolver) {
        super(knownClasses);
        this.writerResolver = writerResolver;
    }

    @Override
    public <T> ValueWriter<T> writerFor(Class<T> targetClass) {
        if (targetClass.isPrimitive()) {
            throw new IllegalArgumentException("Use in/out directly to read/write primitives");
        }
        ValueWriter<T> writer = this.writerResolver.resolve(targetClass);
        if (writer != null) {
            return writer;
        }
        throw new NoSuchElementException("Cannot resolve ValueWriter for " + String.valueOf(targetClass));
    }

    @Override
    public <T> int referenceToIndex(T value) {
        if (value == null) {
            return 0;
        }
        return this.referenceToIndex.getOrDefault(value, Integer.MIN_VALUE);
    }

    @Override
    public <T> void writeValue(DataOutput out, T value) throws IOException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.cycleDetector.contains(value)) {
            throw new IllegalStateException("Detected reference cycle during serialization for " + String.valueOf(value));
        }
        this.cycleDetector.add(value);
        SerializationContext.Writer.super.writeValue(out, value);
        this.cycleDetector.remove(value);
    }
}

