/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.interpreter.metadata.serialization.ForkedDataOutput;
import com.oracle.svm.interpreter.metadata.serialization.LEB128;
import com.oracle.svm.interpreter.metadata.serialization.ReaderImpl;
import com.oracle.svm.interpreter.metadata.serialization.ValueReader;
import com.oracle.svm.interpreter.metadata.serialization.ValueSerializer;
import com.oracle.svm.interpreter.metadata.serialization.ValueWriter;
import com.oracle.svm.interpreter.metadata.serialization.WriterImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public interface SerializationContext {
    public static final int UNKNOWN_REFERENCE_INDEX = Integer.MIN_VALUE;
    public static final int NULL_REFERENCE_INDEX = 0;
    public static final int CLASS_REFERENCE_INDEX = 1;

    public <T> int recordReference(T var1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Class<?>> knownClasses = List.of();
        private final EconomicMap<Class<?>, ValueReader<?>> valueReaders = EconomicMap.create();
        @Platforms(value={Platform.HOSTED_ONLY.class})
        private final EconomicMap<Class<?>, ValueWriter<?>> valueWriters = EconomicMap.create();

        public List<Class<?>> getKnownClasses() {
            return this.knownClasses;
        }

        public Builder setKnownClasses(List<Class<?>> knownClasses) {
            this.knownClasses = knownClasses;
            return this;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public <T> Builder registerSerializer(boolean overrideExisting, Class<T> targetClass, ValueSerializer<? extends T> valueSerializer) {
            this.registerReader(overrideExisting, targetClass, valueSerializer.getReader());
            this.registerWriter(overrideExisting, targetClass, valueSerializer.getWriter());
            return this;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public <T> Builder registerSerializer(Class<T> targetClass, ValueSerializer<? extends T> valueSerializer) {
            return this.registerSerializer(false, targetClass, valueSerializer);
        }

        public <T> Builder registerReader(boolean overrideExisting, Class<T> targetClass, ValueReader<? extends T> valueReader) {
            if (!overrideExisting && this.valueReaders.containsKey(targetClass)) {
                throw new IllegalArgumentException("ValueReader already exists for " + String.valueOf(targetClass));
            }
            this.valueReaders.put(targetClass, valueReader);
            return this;
        }

        public <T> Builder registerReader(Class<T> targetClass, ValueReader<? extends T> valueReader) {
            return this.registerReader(false, targetClass, valueReader);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public <T> Builder registerWriter(boolean overrideExisting, Class<T> targetClass, ValueWriter<? extends T> valueWriter) {
            if (!overrideExisting && this.valueWriters.containsKey(targetClass)) {
                throw new IllegalArgumentException("ValueWriter already exists for " + String.valueOf(targetClass));
            }
            this.valueWriters.put(targetClass, valueWriter);
            return this;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public <T> Builder registerWriter(Class<T> targetClass, ValueWriter<? extends T> valueWriter) {
            return this.registerWriter(false, targetClass, valueWriter);
        }

        public Reader buildReader() {
            return new ReaderImpl(this.knownClasses, new ValueReader.Resolver(){

                @Override
                public <T> ValueReader<T> resolve(Class<T> targetClass) {
                    return (ValueReader)valueReaders.get(targetClass);
                }
            });
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public Writer buildWriter() {
            return new WriterImpl(this.knownClasses, new ValueWriter.Resolver(){

                @Override
                public <T> ValueWriter<T> resolve(Class<T> targetClass) {
                    return (ValueWriter)valueWriters.get(targetClass);
                }
            });
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface Writer
    extends SerializationContext {
        public <T> ValueWriter<T> writerFor(Class<T> var1);

        public <T> int referenceToIndex(T var1);

        default public <T> void writeReference(DataOutput out, T value) throws IOException {
            int refIndex = this.referenceToIndex(value);
            if (refIndex == Integer.MIN_VALUE) {
                this.writeValue(out, value);
                refIndex = this.referenceToIndex(value);
                if (refIndex == Integer.MIN_VALUE) {
                    throw new IllegalStateException("Written object was not registered properly");
                }
            }
            LEB128.writeUnsignedInt(out, refIndex);
        }

        default public <T> void writeValue(DataOutput out, T value) throws IOException {
            Class<?> targetClass = value.getClass();
            ValueWriter<?> valueWriter = this.writerFor(targetClass);
            try (ForkedDataOutput fork = new ForkedDataOutput(out);){
                this.writeReference(fork, targetClass);
                valueWriter.write(this, fork, value);
            }
            this.recordReference(value);
        }
    }

    public static interface Reader
    extends SerializationContext {
        public <T> T indexToReference(int var1);

        public <T> ValueReader<T> readerFor(Class<T> var1);

        default public <T> T readReference(DataInput in) throws IOException {
            int refIndex = LEB128.readUnsignedInt(in);
            return this.indexToReference(refIndex);
        }

        default public <T> T readValue(DataInput in) throws IOException {
            Class targetClass = (Class)this.readReference(in);
            T value = this.readerFor(targetClass).read(this, in);
            this.recordReference(value);
            return value;
        }
    }
}

