/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContextImpl;
import com.oracle.svm.interpreter.metadata.serialization.ValueReader;
import java.util.List;
import java.util.NoSuchElementException;

final class ReaderImpl
extends SerializationContextImpl
implements SerializationContext.Reader {
    private final ValueReader.Resolver readerResolver;

    ReaderImpl(List<Class<?>> knownClasses, ValueReader.Resolver readerResolver) {
        super(knownClasses);
        this.readerResolver = readerResolver;
    }

    @Override
    public <T> T indexToReference(int refIndex) {
        if (refIndex == 0) {
            return null;
        }
        Object ref = this.indexToReference.get(refIndex);
        if (ref == null) {
            throw new IllegalStateException("Uninitialized reference at index " + refIndex);
        }
        return (T)ref;
    }

    @Override
    public <T> ValueReader<T> readerFor(Class<T> targetClass) {
        if (targetClass.isPrimitive()) {
            throw new IllegalArgumentException("Use in/out directly to read/write primitives");
        }
        ValueReader<T> reader = this.readerResolver.resolve(targetClass);
        if (reader != null) {
            return reader;
        }
        throw new NoSuchElementException("Cannot resolve ValueReader for " + String.valueOf(targetClass));
    }
}

