/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.interpreter.metadata.MetadataUtil;

public final class Lazy<T> {
    private volatile T ref;
    private final LazySupplier<T> supplier;

    private Lazy(LazySupplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T localRef = this.ref;
        if (localRef == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                localRef = this.ref;
                if (localRef == null) {
                    this.ref = localRef = MetadataUtil.requireNonNull(this.supplier.get());
                }
            }
        }
        return localRef;
    }

    public static <T> Lazy<T> value(T nonNullValue) {
        Lazy<T> result = new Lazy<T>(null);
        result.ref = MetadataUtil.requireNonNull(nonNullValue);
        return result;
    }

    public static <V> Lazy<V> of(LazySupplier<V> supplier) {
        return new Lazy<V>(MetadataUtil.requireNonNull(supplier));
    }

    @FunctionalInterface
    public static interface LazySupplier<T> {
        public T get();
    }
}

