/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.DebuggerFeature;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class BuildTimeConstantPool {
    private static final ExceptionHandler[] EMPTY_EXCEPTION_HANDLERS = new ExceptionHandler[0];
    private final InterpreterResolvedObjectType holder;
    private final Map<Object, Integer> constantCPI;
    private final Map<JavaConstant, Integer> appendixCPI;
    private final Map<JavaField, Integer> fieldCPI;
    private final Map<JavaType, Integer> typeCPI;
    private final Map<JavaMethod, Integer> methodCPI;
    final ArrayList<Object> entries;

    public InterpreterConstantPool snapshot() {
        return InterpreterConstantPool.create(this.holder, this.entries.toArray());
    }

    BuildTimeConstantPool(InterpreterResolvedObjectType holder) {
        this.holder = holder;
        this.entries = new ArrayList(32);
        this.entries.add(null);
        this.constantCPI = new HashMap<Object, Integer>();
        this.fieldCPI = new HashMap<JavaField, Integer>();
        this.typeCPI = new HashMap<JavaType, Integer>();
        this.methodCPI = new HashMap<JavaMethod, Integer>();
        this.appendixCPI = new HashMap<JavaConstant, Integer>();
    }

    public int length() {
        return this.entries.size();
    }

    public int longConstant(long value) {
        return this.constantCPI.computeIfAbsent(value, key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().primitiveConstant(value);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    public int intConstant(int value) {
        return this.constantCPI.computeIfAbsent(value, key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().primitiveConstant(value);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    public int floatConstant(float value) {
        return this.constantCPI.computeIfAbsent(Float.valueOf(value), key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().primitiveConstant(value);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    public int doubleConstant(double value) {
        return this.constantCPI.computeIfAbsent(value, key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().primitiveConstant(value);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    public int stringConstant(String value) {
        return this.constantCPI.computeIfAbsent(value, key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().stringConstant(value);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    public int typeConstant(JavaType type) {
        if (!(type instanceof InterpreterResolvedJavaType) && !(type instanceof UnresolvedJavaType)) {
            throw new IllegalArgumentException("Type must be either InterpreterResolvedJavaType or UnresolvedJavaType");
        }
        return this.typeCPI.computeIfAbsent(type, key -> {
            this.entries.add(type);
            return this.entries.size() - 1;
        });
    }

    public int method(JavaMethod method) {
        if (!(method instanceof InterpreterResolvedJavaMethod) && !(method instanceof UnresolvedJavaMethod)) {
            throw new IllegalArgumentException("Type must be either InterpreterResolvedJavaMethod or UnresolvedJavaMethod");
        }
        return this.methodCPI.computeIfAbsent(method, key -> {
            this.entries.add(method);
            return this.entries.size() - 1;
        });
    }

    public int field(JavaField field) {
        if (!(field instanceof InterpreterResolvedJavaField) && !(field instanceof UnresolvedJavaField)) {
            throw new IllegalArgumentException("Type must be either InterpreterResolvedJavaField or UnresolvedJavaField");
        }
        return this.fieldCPI.computeIfAbsent(field, key -> {
            this.entries.add(field);
            return this.entries.size() - 1;
        });
    }

    private int appendixConstant(JavaConstant appendix) {
        assert (appendix instanceof ReferenceConstant || appendix.isNull());
        return this.appendixCPI.computeIfAbsent(appendix, key -> {
            this.entries.add(appendix);
            return this.entries.size() - 1;
        });
    }

    public int weakObjectConstant(ImageHeapConstant imageHeapConstant) {
        return this.constantCPI.computeIfAbsent(imageHeapConstant, key -> {
            JavaConstant javaConstant = BuildTimeInterpreterUniverse.singleton().weakObjectConstant(imageHeapConstant);
            this.entries.add(javaConstant);
            return this.entries.size() - 1;
        });
    }

    private int ldcConstant(Object javaConstantOrType) {
        if (javaConstantOrType instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)javaConstantOrType;
            switch (javaConstant.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Short: 
                case Char: 
                case Int: {
                    return this.intConstant(javaConstant.asInt());
                }
                case Float: {
                    return this.floatConstant(javaConstant.asFloat());
                }
                case Long: {
                    return this.longConstant(javaConstant.asLong());
                }
                case Double: {
                    return this.doubleConstant(javaConstant.asDouble());
                }
                case Object: {
                    if (!(javaConstant instanceof ImageHeapConstant)) break;
                    ImageHeapConstant imageHeapConstant = (ImageHeapConstant)javaConstant;
                    return this.weakObjectConstant(imageHeapConstant);
                }
            }
        } else if (javaConstantOrType instanceof JavaType) {
            JavaType javaType = (JavaType)javaConstantOrType;
            JavaType interpreterType = BuildTimeInterpreterUniverse.singleton().typeOrUnresolved(javaType);
            return this.typeConstant(interpreterType);
        }
        throw VMError.shouldNotReachHereUnexpectedInput(javaConstantOrType);
    }

    public static BuildTimeConstantPool create(InterpreterResolvedObjectType type) {
        BuildTimeConstantPool btcp = new BuildTimeConstantPool(type);
        btcp.hydrate(type);
        return btcp;
    }

    private ExceptionHandler[] processExceptionHandlers(ExceptionHandler[] hostExceptionHandlers) {
        if (hostExceptionHandlers.length == 0) {
            return EMPTY_EXCEPTION_HANDLERS;
        }
        ExceptionHandler[] handlers = new ExceptionHandler[hostExceptionHandlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            ExceptionHandler host = hostExceptionHandlers[i];
            JavaType resolvedCatchType = null;
            JavaType interpreterCatchType = null;
            int catchTypeCPI = 0;
            if (!host.isCatchAll()) {
                resolvedCatchType = host.getCatchType();
                interpreterCatchType = BuildTimeInterpreterUniverse.singleton().typeOrUnresolved(resolvedCatchType);
                catchTypeCPI = this.typeConstant(interpreterCatchType);
            }
            handlers[i] = BuildTimeInterpreterUniverse.singleton().exceptionHandler(new ExceptionHandler(host.getStartBCI(), host.getEndBCI(), host.getHandlerBCI(), catchTypeCPI, interpreterCatchType));
        }
        return handlers;
    }

    public static boolean weedOut(InterpreterResolvedObjectType type, HostedUniverse hUniverse) {
        boolean chasingFixpoint = false;
        block5: for (InterpreterResolvedJavaMethod method : BuildTimeInterpreterUniverse.singleton().allDeclaredMethods(type)) {
            byte[] code;
            if (!method.needsMethodBody() || !method.isInterpreterExecutable()) {
                method.setCode(null);
            }
            if ((code = method.getInterpretedCode()) == null || code.length == 0) continue;
            ResolvedJavaMethod originalMethod = method.getOriginalMethod();
            ConstantPool originalConstantPool = originalMethod.getConstantPool();
            int bci = 0;
            while (bci < BytecodeStream.endBCI(code)) {
                int bytecode = BytecodeStream.currentBC(code, bci);
                switch (bytecode) {
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        int originalCPI = bytecode == 186 ? BytecodeStream.readCPI4(code, bci) : (int)BytecodeStream.readCPI(code, bci);
                        JavaMethod calleeOriginalJavaMethod = null;
                        try {
                            calleeOriginalJavaMethod = originalConstantPool.lookupMethod(originalCPI, bytecode);
                        }
                        catch (UnsupportedFeatureException | UserError.UserException throwable) {
                            // empty catch block
                        }
                        if (calleeOriginalJavaMethod != null) {
                            InterpreterResolvedJavaMethod calleeInterpreterResolvedJavaMethod;
                            JavaMethod calleeInterpreterMethod = BuildTimeInterpreterUniverse.singleton().methodOrUnresolved(calleeOriginalJavaMethod);
                            if (!(calleeInterpreterMethod instanceof InterpreterResolvedJavaMethod) || (calleeInterpreterResolvedJavaMethod = (InterpreterResolvedJavaMethod)calleeInterpreterMethod).isInterpreterExecutable()) break;
                            HostedMethod calleeHostedMethod = hUniverse.optionalLookup(calleeOriginalJavaMethod);
                            if (calleeHostedMethod.isCompiled()) {
                                InterpreterUtil.log("[weedout] good. Call from %s @ bci=%s (interp) to %s (compiled) possible", method, bci, calleeInterpreterResolvedJavaMethod);
                                break;
                            }
                            if (calleeHostedMethod.hasVTableIndex()) {
                                InterpreterUtil.log("[weedout] good. Virtual call from %s @ bci=%s (interp) to %s (compiled) possible", method, bci, calleeInterpreterResolvedJavaMethod);
                                break;
                            }
                            if (calleeHostedMethod.getImplementations().length == 1) {
                                HostedMethod impl = calleeHostedMethod.getImplementations()[0];
                                if (!impl.isCompiled() && !BuildTimeConstantPool.isInterpreterExecutable(impl)) {
                                    BuildTimeConstantPool.weedOut(method, BuildTimeInterpreterUniverse.singleton().methodOrUnresolved((JavaMethod)impl), impl, true);
                                    chasingFixpoint = true;
                                    continue block5;
                                }
                                assert (impl.isCompiled() || BuildTimeConstantPool.isInterpreterExecutable(impl)) : String.valueOf(calleeHostedMethod) + ", implementation: " + String.valueOf(impl) + ", ";
                                InterpreterUtil.log("[weedout] good. Virtual call from %s @ bci=%s (interp) has exactly one implementation available %s", method, bci, calleeHostedMethod.getImplementations()[0]);
                                break;
                            }
                            if (!DebuggerFeature.isReachable(calleeHostedMethod.getWrapped())) break;
                            BuildTimeConstantPool.weedOut(method, (JavaMethod)calleeInterpreterResolvedJavaMethod, calleeHostedMethod, false);
                            chasingFixpoint = true;
                            continue block5;
                        }
                        InterpreterUtil.log("[weedout] ??? call from %s at bci=%s does not go anywhere", method, bci);
                    }
                }
                bci = BytecodeStream.nextBCI(code, bci);
            }
        }
        return chasingFixpoint;
    }

    private static boolean isInterpreterExecutable(HostedMethod impl) {
        JavaMethod method = BuildTimeInterpreterUniverse.singleton().methodOrUnresolved((JavaMethod)impl);
        if (method instanceof InterpreterResolvedJavaMethod) {
            InterpreterResolvedJavaMethod interpreterResolvedJavaMethod = (InterpreterResolvedJavaMethod)method;
            return interpreterResolvedJavaMethod.isInterpreterExecutable();
        }
        return false;
    }

    private static void weedOut(InterpreterResolvedJavaMethod method, JavaMethod calleeInterpreterResolvedJavaMethod, HostedMethod calleeHostedMethod, boolean singleCalleeImpl) {
        InterpreterUtil.log("[weedout] bad. %s downgraded to non-interpreter-executable.", method);
        if (singleCalleeImpl) {
            InterpreterUtil.log("          there is no way to call the single callee implementation %s, but it is considered reachable", calleeInterpreterResolvedJavaMethod);
        } else {
            InterpreterUtil.log("          there is no way to call a compiled version of %s or to execute it in the interpreter, but it is considered reachable", calleeInterpreterResolvedJavaMethod);
        }
        assert (DebuggerFeature.isReachable(calleeHostedMethod.getWrapped())) : calleeHostedMethod;
        method.setCode(null);
    }

    public void hydrate(InterpreterResolvedObjectType type) {
        List<InterpreterResolvedJavaMethod> allDeclaredMethods = BuildTimeInterpreterUniverse.singleton().allDeclaredMethods(type);
        this.processLDC(allDeclaredMethods);
        for (InterpreterResolvedJavaMethod method : allDeclaredMethods) {
            byte[] code;
            ResolvedJavaMethod originalMethod = method.getOriginalMethod();
            method.setExceptionHandlers(this.processExceptionHandlers(originalMethod.getExceptionHandlers()));
            LocalVariableTable hostLocalVariableTable = method.getOriginalMethod().getLocalVariableTable();
            if (hostLocalVariableTable != null) {
                method.setLocalVariableTable(BuildTimeInterpreterUniverse.processLocalVariableTable(hostLocalVariableTable));
            }
            if (!method.needsMethodBody()) {
                VMError.guarantee(method.getInterpretedCode() == null);
            }
            if ((code = method.getInterpretedCode()) == null || code.length == 0) continue;
            InterpreterUtil.log("[hydrate] processing method=%s", method);
            ConstantPool originalConstantPool = originalMethod.getConstantPool();
            int bci = 0;
            while (bci < BytecodeStream.endBCI(code)) {
                int bytecode = BytecodeStream.currentBC(code, bci);
                switch (bytecode) {
                    case 18: 
                    case 19: 
                    case 20: {
                        int originalCPI = BytecodeStream.readCPI(code, bci);
                        int newCPI = 0;
                        try {
                            Object originalConstant = originalConstantPool.lookupConstant(originalCPI);
                            newCPI = this.ldcConstant(originalConstant);
                        }
                        catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError originalConstant) {
                            // empty catch block
                        }
                        BytecodeStream.patchCPI(code, bci, newCPI);
                        break;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        int originalCPI = BytecodeStream.readCPI(code, bci);
                        int newCPI = 0;
                        JavaField originalJavaField = null;
                        try {
                            originalJavaField = originalConstantPool.lookupField(originalCPI, originalMethod, bytecode);
                        }
                        catch (UnsupportedFeatureException unsupportedFeatureException) {
                            // empty catch block
                        }
                        if (originalJavaField != null) {
                            JavaField interpreterField = BuildTimeInterpreterUniverse.singleton().fieldOrUnresolved(originalJavaField);
                            newCPI = this.field(interpreterField);
                        }
                        BytecodeStream.patchCPI(code, bci, newCPI);
                        break;
                    }
                    case 187: 
                    case 189: 
                    case 192: 
                    case 193: 
                    case 197: {
                        int originalCPI = BytecodeStream.readCPI(code, bci);
                        int newCPI = 0;
                        JavaType originalJavaType = null;
                        try {
                            originalJavaType = originalConstantPool.lookupType(originalCPI, bytecode);
                        }
                        catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError interpreterField) {
                            // empty catch block
                        }
                        if (originalJavaType != null) {
                            JavaType interpreterType = BuildTimeInterpreterUniverse.singleton().typeOrUnresolved(originalJavaType);
                            newCPI = this.typeConstant(interpreterType);
                        }
                        BytecodeStream.patchCPI(code, bci, newCPI);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        int originalCPI = bytecode == 186 ? BytecodeStream.readCPI4(code, bci) : (int)BytecodeStream.readCPI(code, bci);
                        JavaMethod originalJavaMethod = null;
                        int newCPI = 0;
                        try {
                            originalJavaMethod = originalConstantPool.lookupMethod(originalCPI, bytecode);
                        }
                        catch (UnsupportedFeatureException | UserError.UserException interpreterType) {
                            // empty catch block
                        }
                        if (originalJavaMethod != null) {
                            JavaMethod interpreterMethod = BuildTimeInterpreterUniverse.singleton().methodOrUnresolved(originalJavaMethod);
                            if (interpreterMethod instanceof InterpreterResolvedJavaMethod) {
                                ((InterpreterResolvedJavaMethod)interpreterMethod).setNativeEntryPoint(new MethodPointer((ResolvedJavaMethod)originalJavaMethod));
                                InterpreterUtil.log("[hydrate] setting method pointer for %s", interpreterMethod);
                            }
                            newCPI = this.method(interpreterMethod);
                        }
                        if (bytecode == 186) {
                            int newAppendixCPI = 0;
                            JavaConstant appendix = originalConstantPool.lookupAppendix(originalCPI, bytecode);
                            if (appendix != null) {
                                JavaConstant interpreterAppendix = BuildTimeInterpreterUniverse.singleton().appendix(appendix);
                                newAppendixCPI = this.appendixConstant(interpreterAppendix);
                            } else {
                                newAppendixCPI = this.appendixConstant(JavaConstant.NULL_POINTER);
                            }
                            BytecodeStream.patchAppendixCPI(code, bci, newAppendixCPI);
                        }
                        BytecodeStream.patchCPI(code, bci, newCPI);
                        break;
                    }
                }
                bci = BytecodeStream.nextBCI(code, bci);
            }
        }
    }

    private void processLDC(List<InterpreterResolvedJavaMethod> allDeclaredMethods) {
        for (InterpreterResolvedJavaMethod method : allDeclaredMethods) {
            byte[] code = method.getInterpretedCode();
            if (code == null || code.length == 0) continue;
            ConstantPool originalConstantPool = method.getOriginalMethod().getConstantPool();
            int bci = 0;
            while (bci < BytecodeStream.endBCI(code)) {
                if (BytecodeStream.opcode(code, bci) == 18) {
                    try {
                        Object constant = originalConstantPool.lookupConstant((int)BytecodeStream.readCPI(code, bci));
                        this.ldcConstant(constant);
                    }
                    catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError throwable) {
                        // empty catch block
                    }
                }
                bci = BytecodeStream.nextBCI(code, bci);
            }
        }
    }
}

