/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.results.StrengthenGraphs;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.ExcludeFromReferenceMap;
import com.oracle.svm.core.heap.FillerArray;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.heap.InstanceReferenceMapEncoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.heap.SmallestPossibleObject;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.MethodOffset;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.heap.PodSupport;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredStaticFieldSupport;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.TypeCheckBuilder;
import com.oracle.svm.hosted.meta.VTableBuilder;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.internal.vm.annotation.Contended;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.word.WordBase;

public class UniverseBuilder {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final WordBase[] EMPTY_VTABLE = new WordBase[0];
    private final AnalysisUniverse aUniverse;
    private final AnalysisMetaAccess aMetaAccess;
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private StrengthenGraphs strengthenGraphs;
    private final UnsupportedFeatures unsupportedFeatures;
    private static final Set<Class<?>> IMMUTABLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, DynamicHub.class, CEntryPointLiteral.class, BoxedRelocatedPointer.class, FunctionPointerHolder.class, StoredContinuation.class, SubstrateMethodAccessor.class, SubstrateConstructorAccessor.class, SmallestPossibleObject.class, FillerObject.class, FillerArray.class));
    private static final Comparator<HostedField> FIELD_LOCATION_COMPARATOR = (a, b) -> {
        if (!a.hasLocation() || !b.hasLocation()) {
            return Boolean.compare(a.hasLocation(), b.hasLocation());
        }
        return Integer.compare(a.getLocation(), b.getLocation());
    };

    public UniverseBuilder(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, StrengthenGraphs strengthenGraphs, UnsupportedFeatures unsupportedFeatures) {
        this.aUniverse = aUniverse;
        this.aMetaAccess = aMetaAccess;
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.strengthenGraphs = strengthenGraphs;
        this.unsupportedFeatures = unsupportedFeatures;
    }

    public void build(DebugContext debug) {
        this.aUniverse.seal();
        try (Indent indent = debug.logAndIndent("build universe");){
            for (AnalysisType aType : this.aUniverse.getTypes()) {
                this.makeType(aType);
            }
            for (AnalysisType aType : this.aUniverse.getTypes()) {
                this.checkHierarchyForTypeReachedConstraints(aType);
            }
            for (AnalysisField aField : this.aUniverse.getFields()) {
                this.makeField(aField);
            }
            for (AnalysisMethod aMethod : this.aUniverse.getMethods()) {
                assert (aMethod.isOriginalMethod());
                Collection allMethods = aMethod.getAllMultiMethods();
                HostedMethod origHMethod = null;
                if (allMethods.size() == 1) {
                    origHMethod = this.makeMethod(aMethod);
                } else {
                    ConcurrentHashMap<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap = new ConcurrentHashMap<MultiMethod.MultiMethodKey, MultiMethod>();
                    for (MultiMethod method : aMethod.getAllMultiMethods()) {
                        HostedMethod hMethod = this.makeMethod((AnalysisMethod)method);
                        hMethod.setMultiMethodMap(multiMethodMap);
                        MultiMethod previous = multiMethodMap.put(hMethod.getMultiMethodKey(), hMethod);
                        assert (previous == null) : "Overwriting multimethod key";
                        if (!method.equals((Object)aMethod)) continue;
                        origHMethod = hMethod;
                    }
                }
                assert (origHMethod != null);
                HostedMethod previous = this.hUniverse.methods.put(aMethod, origHMethod);
                assert (previous == null) : "Overwriting analysis key";
            }
            HostedConfiguration.initializeDynamicHubLayout(this.hMetaAccess);
            Collection<HostedType> allTypes = this.hUniverse.types.values();
            HostedType objectType = this.hUniverse.objectType();
            HostedType cloneableType = this.hUniverse.types.get(this.aMetaAccess.lookupJavaType(Cloneable.class));
            HostedType serializableType = this.hUniverse.types.get(this.aMetaAccess.lookupJavaType(Serializable.class));
            int numTypeCheckSlots = TypeCheckBuilder.buildTypeMetadata(this.hUniverse, allTypes, objectType, cloneableType, serializableType);
            this.collectDeclaredMethods();
            this.collectMonitorFieldInfo(this.aUniverse.getBigbang());
            ForkJoinTask<?> profilingInformationBuildTask = ForkJoinTask.adapt(this::buildProfilingInformation).fork();
            this.layoutInstanceFields(numTypeCheckSlots);
            this.layoutStaticFields();
            this.collectMethodImplementations();
            VTableBuilder.buildTables(this.hUniverse, this.hMetaAccess);
            this.buildHubs();
            this.hUniverse.orderedMethods = new ArrayList<HostedMethod>(this.hUniverse.methods.values());
            Collections.sort(this.hUniverse.orderedMethods, HostedUniverse.METHOD_COMPARATOR);
            this.hUniverse.orderedFields = new ArrayList<HostedField>(this.hUniverse.fields.values());
            Collections.sort(this.hUniverse.orderedFields, HostedUniverse.FIELD_COMPARATOR_RELAXED);
            profilingInformationBuildTask.join();
        }
    }

    private HostedType lookupType(AnalysisType aType) {
        return Objects.requireNonNull(this.hUniverse.types.get(aType));
    }

    private HostedType makeType(AnalysisType aType) {
        if (aType == null) {
            return null;
        }
        HostedType hType = this.hUniverse.types.get(aType);
        if (hType != null) {
            return hType;
        }
        String typeName = aType.getName();
        assert (ImageInfo.inImageBuildtimeCode() || !typeName.contains("/hotspot/") || typeName.contains("/jtt/hotspot/") || typeName.contains("/hotspot/shared/")) : "HotSpot object in image " + typeName;
        assert (!typeName.contains("/analysis/meta/")) : "Analysis meta object in image " + typeName;
        assert (!typeName.contains("/hosted/meta/")) : "Hosted meta object in image " + typeName;
        AnalysisType[] aInterfaces = aType.getInterfaces();
        HostedInterface[] sInterfaces = aInterfaces.length == 0 ? HostedInterface.EMPTY_ARRAY : new HostedInterface[aInterfaces.length];
        for (int i = 0; i < aInterfaces.length; ++i) {
            sInterfaces[i] = (HostedInterface)this.makeType(aInterfaces[i]);
        }
        JavaKind kind = aType.getJavaKind();
        JavaKind storageKind = aType.getStorageKind();
        if (aType.getJavaKind() != JavaKind.Object) {
            assert (!(aType.isInterface() || aType.isInstanceClass() || aType.isArray()));
            hType = new HostedPrimitiveType(this.hUniverse, aType, kind, storageKind);
            this.hUniverse.kindToType.put(hType.getJavaKind(), hType);
        } else if (aType.isInterface()) {
            assert (!aType.isInstanceClass() && !aType.isArray());
            hType = new HostedInterface(this.hUniverse, aType, kind, storageKind, sInterfaces);
        } else if (aType.isInstanceClass()) {
            assert (!aType.isInterface() && !aType.isArray());
            HostedInstanceClass superClass = (HostedInstanceClass)this.makeType(aType.getSuperclass());
            hType = new HostedInstanceClass(this.hUniverse, aType, kind, storageKind, superClass, sInterfaces);
            if (superClass == null) {
                this.hUniverse.kindToType.put(JavaKind.Object, hType);
            }
        } else if (aType.isArray()) {
            assert (!aType.isInterface() && !aType.isInstanceClass());
            HostedClass superType = (HostedClass)this.makeType(aType.getSuperclass());
            HostedType componentType = this.makeType(aType.getComponentType());
            hType = new HostedArrayClass(this.hUniverse, aType, kind, storageKind, superType, sInterfaces, componentType);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(aType);
        }
        HostedType existing = this.hUniverse.types.put(aType, hType);
        if (existing != null) {
            throw VMError.shouldNotReachHere("Overwriting existing type: " + String.valueOf(hType) + " != " + String.valueOf(existing));
        }
        DynamicHub hub = hType.getHub();
        Class<?> hostedJavaClass = hub.getHostedJavaClass();
        AnalysisType aTypeChecked = this.aMetaAccess.lookupJavaType(hostedJavaClass);
        ResolvedJavaType hTypeChecked = this.hMetaAccess.lookupJavaType((Class)hostedJavaClass);
        if (!(UniverseBuilder.sameObject(aType, aTypeChecked) && UniverseBuilder.sameObject(hTypeChecked, hType) || aType.getWrapped() instanceof BaseLayerType)) {
            throw VMError.shouldNotReachHere("Type mismatch when performing round-trip HostedType/AnalysisType -> DynamicHub -> java.lang.Class -> HostedType/AnalysisType: " + System.lineSeparator() + String.valueOf(hType) + " @ " + Integer.toHexString(System.identityHashCode(hType)) + " / " + String.valueOf(aType) + " @ " + Integer.toHexString(System.identityHashCode(aType)) + System.lineSeparator() + " -> " + String.valueOf(hub) + " -> " + String.valueOf(hostedJavaClass) + System.lineSeparator() + " -> " + String.valueOf(hTypeChecked) + " @ " + Integer.toHexString(System.identityHashCode(hTypeChecked)) + " / " + String.valueOf(aTypeChecked) + " @ " + Integer.toHexString(System.identityHashCode(aTypeChecked)));
        }
        if (hType.wrapped.isReachable() && ClassInitializationSupport.singleton().maybeInitializeAtBuildTime(hostedJavaClass) && hub.getClassInitializationInfo().getTypeReached() == ClassInitializationInfo.TypeReached.NOT_REACHED) {
            hType.wrapped.forAllSuperTypes(t -> {
                DynamicHub superHub = this.hUniverse.hostVM().dynamicHub((ResolvedJavaType)t);
                if (superHub.getClassInitializationInfo().getTypeReached() == ClassInitializationInfo.TypeReached.NOT_REACHED) {
                    superHub.getClassInitializationInfo().setTypeReached();
                }
            });
        }
        return hType;
    }

    private void checkHierarchyForTypeReachedConstraints(AnalysisType type) {
        if (type.isReachable()) {
            DynamicHub hub = this.hUniverse.hostVM().dynamicHub((ResolvedJavaType)type);
            if (type.getSuperclass() != null) {
                UniverseBuilder.checkSuperHub(hub, hub.getSuperHub());
            }
            for (AnalysisType superInterface : type.getInterfaces()) {
                UniverseBuilder.checkSuperHub(hub, this.hUniverse.hostVM().dynamicHub((ResolvedJavaType)superInterface));
            }
        }
    }

    private static void checkSuperHub(DynamicHub hub, DynamicHub superTypeHub) {
        ClassInitializationInfo.TypeReached typeReached = hub.getClassInitializationInfo().getTypeReached();
        ClassInitializationInfo.TypeReached superTypeReached = superTypeHub.getClassInitializationInfo().getTypeReached();
        VMError.guarantee(superTypeReached.ordinal() >= typeReached.ordinal(), "Super type of a type must have type reached >= than the type: %s is %s but %s is %s", hub.getName(), (Object)typeReached, superTypeHub.getName(), (Object)superTypeReached);
    }

    private static boolean sameObject(Object x, Object y) {
        return x == y;
    }

    private HostedMethod makeMethod(AnalysisMethod aMethod) {
        boolean hasCFunctionOptions;
        AnalysisType aDeclaringClass = aMethod.getDeclaringClass();
        HostedType hDeclaringClass = this.lookupType(aDeclaringClass);
        ResolvedSignature<HostedType> signature = this.makeSignature((ResolvedSignature<AnalysisType>)aMethod.getSignature());
        ConstantPool constantPool = null;
        if (!(aMethod.getWrapped() instanceof BaseLayerMethod)) {
            constantPool = this.makeConstantPool(aMethod.getConstantPool(), aDeclaringClass);
        }
        ExceptionHandler[] aHandlers = aMethod.getExceptionHandlers();
        ExceptionHandler[] sHandlers = new ExceptionHandler[aHandlers.length];
        for (int i = 0; i < aHandlers.length; ++i) {
            ExceptionHandler h = aHandlers[i];
            Object catchType = h.getCatchType();
            if (h.getCatchType() instanceof AnalysisType) {
                catchType = this.lookupType((AnalysisType)catchType);
            } else assert (catchType == null || catchType instanceof UnresolvedJavaType);
            sHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        HostedMethod hMethod = HostedMethod.create(this.hUniverse, aMethod, hDeclaringClass, signature, constantPool, sHandlers);
        if (HostedImageLayerBuildingSupport.buildingExtensionLayer()) {
            HostedDynamicLayerInfo.singleton().registerHostedMethod(hMethod);
        }
        boolean isCFunction = aMethod.getAnnotation(CFunction.class) != null;
        boolean bl = hasCFunctionOptions = aMethod.getAnnotation(CFunctionOptions.class) != null;
        if (hasCFunctionOptions && !isCFunction) {
            this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, "Method annotated with @" + CFunctionOptions.class.getSimpleName() + " must also be annotated with @" + String.valueOf(CFunction.class));
        }
        if (isCFunction) {
            if (!aMethod.isNative()) {
                this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, "Method annotated with @" + CFunction.class.getSimpleName() + " must be declared native");
            }
        } else if (aMethod.isNative() && !aMethod.isIntrinsicMethod() && !(aMethod.getWrapped() instanceof CustomSubstitutionMethod) && aMethod.isImplementationInvoked() && !NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)aMethod, DeletedMethod.NATIVE_MESSAGE, true));
        }
        return hMethod;
    }

    private ResolvedSignature<HostedType> makeSignature(ResolvedSignature<AnalysisType> aSignature) {
        ResolvedSignature hSignature = this.hUniverse.signatures.get(aSignature);
        if (hSignature == null) {
            ResolvedJavaType[] paramTypes = new HostedType[aSignature.getParameterCount(false)];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = this.lookupType((AnalysisType)aSignature.getParameterType(i));
            }
            HostedType returnType = this.lookupType((AnalysisType)aSignature.getReturnType());
            hSignature = ResolvedSignature.fromArray((ResolvedJavaType[])paramTypes, (ResolvedJavaType)returnType);
            this.hUniverse.signatures.put(aSignature, (ResolvedSignature<HostedType>)hSignature);
        }
        return hSignature;
    }

    private ConstantPool makeConstantPool(ConstantPool aConstantPool, AnalysisType aDefaultAccessingClass) {
        WrappedConstantPool hConstantPool = this.hUniverse.constantPools.get(aConstantPool);
        if (hConstantPool == null) {
            hConstantPool = new WrappedConstantPool((Universe)this.hUniverse, aConstantPool, (ResolvedJavaType)aDefaultAccessingClass);
            this.hUniverse.constantPools.put(aConstantPool, hConstantPool);
        }
        return hConstantPool;
    }

    private void makeField(AnalysisField aField) {
        HostedType holder = this.lookupType(aField.getDeclaringClass());
        HostedType type = this.lookupType(aField.getType());
        HostedField hField = new HostedField(aField, holder, type);
        assert (!this.hUniverse.fields.containsKey(aField));
        this.hUniverse.fields.put(aField, hField);
    }

    private void buildProfilingInformation() {
        this.hUniverse.methods.values().parallelStream().forEach(method -> {
            assert (method.isOriginalMethod());
            for (MultiMethod multiMethod : method.getAllMultiMethods()) {
                HostedMethod hMethod = (HostedMethod)multiMethod;
                this.strengthenGraphs.applyResults(hMethod.getWrapped());
            }
        });
        this.strengthenGraphs = null;
    }

    private void collectMonitorFieldInfo(BigBang bb) {
        HostedConfiguration.instance().collectMonitorFieldInfo(bb, this.hUniverse, this.getImmutableTypes());
    }

    private Set<AnalysisType> getImmutableTypes() {
        HashSet<AnalysisType> immutableTypes = new HashSet<AnalysisType>();
        for (Class<?> immutableType : IMMUTABLE_TYPES) {
            Optional aType = this.aMetaAccess.optionalLookupJavaType(immutableType);
            aType.ifPresent(immutableTypes::add);
        }
        return immutableTypes;
    }

    public static boolean isKnownImmutableType(Class<?> clazz) {
        return IMMUTABLE_TYPES.contains(clazz);
    }

    private void layoutInstanceFields(int numTypeCheckSlots) {
        BitSet usedBytes = new BitSet();
        usedBytes.set(0, ConfigurationValues.getObjectLayout().getFirstFieldOffset());
        this.layoutInstanceFields(this.hUniverse.getObjectClass(), HostedField.EMPTY_ARRAY, usedBytes, numTypeCheckSlots);
    }

    private static boolean mustReserveArrayFields(HostedInstanceClass clazz) {
        if (PodSupport.isPresent() && PodSupport.singleton().mustReserveArrayFields(clazz.getJavaClass())) {
            return true;
        }
        if (HybridLayout.isHybrid(clazz)) {
            return !PodSupport.isPresent() || !PodSupport.singleton().isPodClass(clazz.getJavaClass());
        }
        return false;
    }

    private static void reserve(BitSet usedBytes, int offset, int size) {
        int offsetAfter = offset + size;
        assert (usedBytes.previousSetBit(offsetAfter - 1) < offset);
        usedBytes.set(offset, offsetAfter);
    }

    private static void reserveAtEnd(BitSet usedBytes, int size) {
        int endOffset = usedBytes.length();
        usedBytes.set(endOffset, endOffset + size);
    }

    private void layoutInstanceFields(HostedInstanceClass clazz, HostedField[] superFields, BitSet usedBytes, int numTypeCheckSlots) {
        int firstInstanceFieldOffset;
        ArrayList<HostedField> rawFields = new ArrayList<HostedField>();
        ArrayList<HostedField> allFields = new ArrayList<HostedField>();
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        HostedConfiguration.instance().findAllFieldsForLayout(this.hUniverse, this.hMetaAccess, this.hUniverse.fields, rawFields, allFields, clazz);
        int minimumFirstFieldOffset = layout.getFirstFieldOffset();
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        if (dynamicHubLayout.isDynamicHub(clazz)) {
            intSize = layout.sizeInBytes(JavaKind.Int);
            int afterVTableLengthOffset = dynamicHubLayout.getVTableLengthOffset() + intSize;
            int fieldBytes = afterVTableLengthOffset - minimumFirstFieldOffset;
            assert (fieldBytes >= intSize);
            UniverseBuilder.reserve(usedBytes, minimumFirstFieldOffset, fieldBytes);
            if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
                assert (numTypeCheckSlots != -1) : "numTypeCheckSlots is uninitialized";
                int slotsSize = numTypeCheckSlots * 2;
                int typeIDSlotsBaseOffset = dynamicHubLayout.getClosedTypeWorldTypeCheckSlotsOffset();
                UniverseBuilder.reserve(usedBytes, typeIDSlotsBaseOffset, slotsSize);
                firstInstanceFieldOffset = typeIDSlotsBaseOffset + slotsSize;
            } else {
                firstInstanceFieldOffset = afterVTableLengthOffset;
            }
        } else if (UniverseBuilder.mustReserveArrayFields(clazz)) {
            int afterArrayLengthOffset;
            intSize = layout.sizeInBytes(JavaKind.Int);
            firstInstanceFieldOffset = afterArrayLengthOffset = layout.getArrayLengthOffset() + intSize;
            int arrayFieldBytes = afterArrayLengthOffset - minimumFirstFieldOffset;
            assert (arrayFieldBytes >= intSize);
            UniverseBuilder.reserve(usedBytes, minimumFirstFieldOffset, arrayFieldBytes);
        } else {
            firstInstanceFieldOffset = minimumFirstFieldOffset;
        }
        Object uncontendedSentinel = new Object();
        Object unannotatedGroup = clazz.isAnnotationPresent(Contended.class) ? new Object() : uncontendedSentinel;
        Function<HostedField, Object> getAnnotationGroup = field -> Optional.ofNullable(field.getAnnotation(Contended.class)).map(a -> "".equals(a.value()) ? new Object() : a.value()).orElse(unannotatedGroup);
        Map<Object, ArrayList> contentionGroups = rawFields.stream().sorted(HostedUniverse.FIELD_COMPARATOR_RELAXED).collect(Collectors.groupingBy(getAnnotationGroup, Collectors.toCollection(ArrayList::new)));
        ArrayList uncontendedFields = contentionGroups.remove(uncontendedSentinel);
        if (uncontendedFields != null) {
            assert (!uncontendedFields.isEmpty());
            UniverseBuilder.placeFields(uncontendedFields, usedBytes, 0, layout);
        }
        for (ArrayList groupFields : contentionGroups.values()) {
            UniverseBuilder.reserveAtEnd(usedBytes, UniverseBuilder.getContendedPadding());
            int firstOffset = usedBytes.length();
            UniverseBuilder.placeFields(groupFields, usedBytes, firstOffset, layout);
            usedBytes.set(firstOffset, usedBytes.length());
        }
        if (!contentionGroups.isEmpty()) {
            UniverseBuilder.reserveAtEnd(usedBytes, UniverseBuilder.getContendedPadding());
        }
        BitSet usedBytesInSubclasses = null;
        if (clazz.subTypes.length != 0) {
            usedBytesInSubclasses = (BitSet)usedBytes.clone();
        }
        if (clazz.needMonitorField()) {
            int endOffset;
            int size = layout.getReferenceSize();
            int offset = UniverseBuilder.findGapForField(usedBytes, 0, size, endOffset = usedBytes.length());
            if (offset == -1) {
                offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, size);
            }
            UniverseBuilder.reserve(usedBytes, offset, size);
            clazz.setMonitorFieldOffset(offset);
        }
        allFields.sort(FIELD_LOCATION_COMPARATOR);
        int afterFieldsOffset = usedBytes.length();
        if (!clazz.isAbstract()) {
            if (layout.isIdentityHashFieldInObjectHeader()) {
                clazz.setIdentityHashOffset(layout.getObjectHeaderIdentityHashOffset());
            } else if (HostedConfiguration.isArrayLikeLayout(clazz)) {
                if (layout.isIdentityHashFieldAtTypeSpecificOffset()) {
                    clazz.setIdentityHashOffset(layout.getObjectHeaderIdentityHashOffset());
                }
            } else if (layout.isIdentityHashFieldAtTypeSpecificOffset() || layout.isIdentityHashFieldOptional()) {
                int hashSize = 4;
                int endOffset = usedBytes.length();
                int offset = UniverseBuilder.findGapForField(usedBytes, 0, hashSize, endOffset);
                if (offset == -1) {
                    offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, hashSize);
                    if (layout.isIdentityHashFieldAtTypeSpecificOffset()) {
                        afterFieldsOffset = offset + hashSize;
                    }
                }
                UniverseBuilder.reserve(usedBytes, offset, hashSize);
                clazz.setIdentityHashOffset(offset);
            }
        }
        clazz.instanceFieldsWithoutSuper = allFields.toArray(HostedField.EMPTY_ARRAY);
        clazz.firstInstanceFieldOffset = firstInstanceFieldOffset;
        clazz.afterFieldsOffset = afterFieldsOffset;
        clazz.instanceSize = layout.alignUp(afterFieldsOffset);
        if (clazz.instanceFieldsWithoutSuper.length == 0) {
            clazz.instanceFieldsWithSuper = superFields;
        } else if (superFields.length == 0) {
            clazz.instanceFieldsWithSuper = clazz.instanceFieldsWithoutSuper;
        } else {
            HostedField[] instanceFieldsWithSuper = Arrays.copyOf(superFields, superFields.length + clazz.instanceFieldsWithoutSuper.length);
            System.arraycopy(clazz.instanceFieldsWithoutSuper, 0, instanceFieldsWithSuper, superFields.length, clazz.instanceFieldsWithoutSuper.length);
            Arrays.sort(instanceFieldsWithSuper, FIELD_LOCATION_COMPARATOR);
            clazz.instanceFieldsWithSuper = instanceFieldsWithSuper;
        }
        for (HostedType subClass : clazz.subTypes) {
            if (!subClass.isInstanceClass()) continue;
            this.layoutInstanceFields((HostedInstanceClass)subClass, clazz.instanceFieldsWithSuper, (BitSet)usedBytesInSubclasses.clone(), numTypeCheckSlots);
        }
    }

    private static int getContendedPadding() {
        Integer value = SubstrateOptions.ContendedPaddingWidth.getValue();
        return value > 0 ? value : 0;
    }

    private static void placeFields(ArrayList<HostedField> fields, BitSet usedBytes, int minOffset, ObjectLayout layout) {
        int lastSearchSize = -1;
        boolean lastSearchSuccess = false;
        for (HostedField field : fields) {
            int fieldSize = layout.sizeInBytes(field.getStorageKind());
            int offset = -1;
            int endOffset = usedBytes.length();
            if (lastSearchSuccess || lastSearchSize != fieldSize) {
                offset = UniverseBuilder.findGapForField(usedBytes, minOffset, fieldSize, endOffset);
                lastSearchSuccess = offset != -1;
                lastSearchSize = fieldSize;
            }
            if (offset == -1) {
                offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, fieldSize);
            }
            UniverseBuilder.reserve(usedBytes, offset, fieldSize);
            field.setLocation(offset, -2);
        }
    }

    private static int findGapForField(BitSet usedBytes, int minOffset, int fieldSize, int endOffset) {
        int candidateOffset = -1;
        int candidateSize = -1;
        int offset = usedBytes.nextClearBit(minOffset);
        while (offset < endOffset) {
            int adjustment;
            int size = usedBytes.nextSetBit(offset + 1) - offset;
            if (size >= (adjustment = UniverseBuilder.getAlignmentAdjustment(offset, fieldSize)) + fieldSize && (candidateOffset == -1 || size < candidateSize)) {
                candidateOffset = offset + adjustment;
                candidateSize = size;
            }
            offset = usedBytes.nextClearBit(offset + size);
        }
        return candidateOffset;
    }

    private static int getAlignmentAdjustment(int offset, int alignment) {
        int bits = alignment - 1;
        assert ((alignment & bits) == 0) : "expecting power of 2";
        int alignedOffset = offset + bits & ~bits;
        return alignedOffset - offset;
    }

    private static boolean skipStaticField(HostedField field, LayeredStaticFieldSupport layeredStaticFieldSupport) {
        if (layeredStaticFieldSupport != null) {
            return layeredStaticFieldSupport.skipStaticField(field, UniverseBuilder::skipStaticField0);
        }
        return UniverseBuilder.skipStaticField0(field);
    }

    private static boolean skipStaticField0(HostedField field) {
        AnalysisField aField = field.getWrapped();
        if (aField.isWritten() || MaterializedConstantFields.singleton().contains(aField)) {
            return false;
        }
        if (!aField.isAccessed()) {
            return true;
        }
        Object interceptor = aField.getFieldValueInterceptor();
        if (interceptor == null) {
            return true;
        }
        boolean available = field.isValueAvailable();
        if (!available) {
            MaterializedConstantFields.singleton().register(field.wrapped);
        }
        return available;
    }

    private void layoutStaticFields() {
        ArrayList<HostedField> staticFields = new ArrayList<HostedField>();
        for (HostedField field : this.hUniverse.fields.values()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            staticFields.add(field);
        }
        Collections.sort(staticFields, HostedUniverse.FIELD_COMPARATOR_RELAXED);
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        StaticFieldOffsets currentLayerOffsets = new StaticFieldOffsets();
        LayeredStaticFieldSupport layeredStaticFieldSupport = null;
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            layeredStaticFieldSupport = LayeredStaticFieldSupport.singleton();
            if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
                layeredStaticFieldSupport.reinitializeKnownFields(staticFields);
            }
            if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
                currentLayerOffsets = layeredStaticFieldSupport.getAppLayerStaticFieldOffsets();
            }
        }
        List[] fieldsOfTypes = new ArrayList[DynamicHubSupport.currentLayer().getMaxTypeId()];
        int currentLayer = DynamicImageLayerInfo.getCurrentLayerNumber();
        boolean checkLayerNum = ImageLayerBuildingSupport.buildingImageLayer();
        for (HostedField field : staticFields) {
            int typeId;
            if (UniverseBuilder.skipStaticField(field, layeredStaticFieldSupport)) {
                if (field.isReachable()) {
                    field.setUnmaterializedStaticConstant(currentLayer);
                }
            } else {
                int layerNum = StaticFieldsSupport.getInstalledLayerNum((ResolvedJavaField)field.getWrapped());
                if (field.getLocation() != -1) {
                    assert (layeredStaticFieldSupport.wasReinitialized(field));
                } else {
                    StaticFieldOffsets offsets = currentLayerOffsets;
                    if (checkLayerNum && currentLayer != layerNum) {
                        assert (currentLayer < layerNum) : Assertions.errorMessage((Object[])new Object[]{currentLayer, layerNum});
                        offsets = layeredStaticFieldSupport.getFutureLayerOffsets(field, layerNum);
                    }
                    if (field.getStorageKind() == JavaKind.Object) {
                        field.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Object, offsets.nextObjectField)), layerNum);
                        ++offsets.nextObjectField;
                    } else {
                        int fieldSize = layout.sizeInBytes(field.getStorageKind());
                        while (layout.getArrayElementOffset(JavaKind.Byte, offsets.nextPrimitiveField) % (long)fieldSize != 0L) {
                            ++offsets.nextPrimitiveField;
                        }
                        field.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Byte, offsets.nextPrimitiveField)), layerNum);
                        offsets.nextPrimitiveField += fieldSize;
                    }
                }
            }
            if (fieldsOfTypes[typeId = field.getDeclaringClass().getTypeID()] == null) {
                fieldsOfTypes[typeId] = new ArrayList();
            }
            fieldsOfTypes[typeId].add(field);
        }
        for (HostedType type : this.hUniverse.getTypes()) {
            List fieldsOfType = fieldsOfTypes[type.getTypeID()];
            if (fieldsOfType != null) {
                type.staticFields = fieldsOfType.toArray(new HostedField[fieldsOfType.size()]);
                continue;
            }
            type.staticFields = HostedField.EMPTY_ARRAY;
        }
        Object[] staticObjectFields = new Object[currentLayerOffsets.nextObjectField];
        byte[] staticPrimitiveFields = new byte[currentLayerOffsets.nextPrimitiveField];
        StaticFieldsSupport.setData(staticObjectFields, staticPrimitiveFields);
        this.aUniverse.getHeapScanner().rescanObject(StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        this.aUniverse.getHeapScanner().rescanObject(StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields());
    }

    private void collectDeclaredMethods() {
        ArrayList[] methodsOfType = new ArrayList[DynamicHubSupport.currentLayer().getMaxTypeId()];
        for (HostedMethod method : this.hUniverse.methods.values()) {
            int typeId = method.getDeclaringClass().getTypeID();
            ArrayList<HostedMethod> list = methodsOfType[typeId];
            if (list == null) {
                methodsOfType[typeId] = list = new ArrayList<HostedMethod>();
            }
            list.add(method);
        }
        for (HostedType type : this.hUniverse.getTypes()) {
            ArrayList list = methodsOfType[type.getTypeID()];
            if (list != null) {
                Collections.sort(list, HostedUniverse.METHOD_COMPARATOR);
                type.allDeclaredMethods = list.toArray(HostedMethod.EMPTY_ARRAY);
                continue;
            }
            type.allDeclaredMethods = HostedMethod.EMPTY_ARRAY;
        }
    }

    private void collectMethodImplementations() {
        for (HostedMethod method : this.hUniverse.methods.values()) {
            method.implementations = this.hUniverse.lookup((JavaMethod[])method.wrapped.collectMethodImplementations(false).toArray(AnalysisMethod.EMPTY_ARRAY));
            Arrays.sort(method.implementations, HostedUniverse.METHOD_COMPARATOR);
        }
    }

    private void buildHubs() {
        InstanceReferenceMapEncoder referenceMapEncoder = new InstanceReferenceMapEncoder();
        HashMap<HostedType, ReferenceMapEncoder.Input> referenceMaps = new HashMap<HostedType, ReferenceMapEncoder.Input>();
        for (HostedType type : this.hUniverse.getTypes()) {
            ReferenceMapEncoder.Input referenceMap = UniverseBuilder.createReferenceMap(type);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            referenceMaps.put(type, referenceMap);
            referenceMapEncoder.add(referenceMap);
        }
        DynamicHubSupport.currentLayer().setReferenceMapEncoding(referenceMapEncoder.encodeAll());
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        for (HostedType type : this.hUniverse.getTypes()) {
            int layoutHelper;
            this.hUniverse.hostVM().recordActivity();
            int monitorOffset = 0;
            int identityHashOffset = 0;
            if (type.isInstanceClass()) {
                HostedInstanceClass instanceClass = (HostedInstanceClass)type;
                if (instanceClass.isAbstract()) {
                    layoutHelper = LayoutEncoding.forAbstract();
                } else if (dynamicHubLayout.isDynamicHub(type)) {
                    layoutHelper = LayoutEncoding.forDynamicHub(type, dynamicHubLayout.vTableOffset(), ol.getArrayIndexShift(dynamicHubLayout.getVTableSlotStorageKind()));
                } else if (HybridLayout.isHybrid(type)) {
                    HybridLayout hybridLayout = new HybridLayout(instanceClass, ol, (MetaAccessProvider)this.hMetaAccess);
                    JavaKind storageKind = hybridLayout.getArrayElementStorageKind();
                    boolean isObject = storageKind == JavaKind.Object;
                    layoutHelper = LayoutEncoding.forHybrid(type, isObject, hybridLayout.getArrayBaseOffset(), ol.getArrayIndexShift(storageKind));
                } else {
                    layoutHelper = LayoutEncoding.forPureInstance(type, ConfigurationValues.getObjectLayout().alignUp(instanceClass.getInstanceSize()));
                }
                monitorOffset = instanceClass.getMonitorFieldOffset();
                identityHashOffset = instanceClass.getIdentityHashOffset();
            } else if (type.isArray()) {
                JavaKind storageKind = type.getComponentType().getStorageKind();
                boolean isObject = storageKind == JavaKind.Object;
                layoutHelper = LayoutEncoding.forArray(type, isObject, ol.getArrayBaseOffset(storageKind), ol.getArrayIndexShift(storageKind));
                if (ol.isIdentityHashFieldInObjectHeader() || ol.isIdentityHashFieldAtTypeSpecificOffset()) {
                    identityHashOffset = NumUtil.safeToInt((long)ol.getObjectHeaderIdentityHashOffset());
                }
            } else if (type.isInterface()) {
                layoutHelper = LayoutEncoding.forInterface();
            } else if (type.isPrimitive()) {
                layoutHelper = LayoutEncoding.forPrimitive();
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(type);
            }
            ReferenceMapEncoder.Input referenceMap = (ReferenceMapEncoder.Input)referenceMaps.get(type);
            assert (referenceMap != null);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            ReferenceMapEncoder.OffsetIterator iter = referenceMap.getOffsets();
            assert (!iter.hasNext() || iter.nextInt() >= ConfigurationValues.getObjectLayout().getFirstFieldOffset());
            long referenceMapIndex = referenceMapEncoder.lookupEncoding(referenceMap);
            DynamicHub hub = type.getHub();
            hub.setSharedData(layoutHelper, monitorOffset, identityHashOffset, referenceMapIndex, type.isInstantiated());
            if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
                WordBase[] vtable = UniverseBuilder.createVTable(type.closedTypeWorldVTable);
                hub.setClosedTypeWorldData(vtable, type.getTypeID(), type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), type.getClosedTypeWorldTypeCheckSlots());
                continue;
            }
            int numClassTypes = type.getNumClassTypes();
            int[] openTypeWorldTypeCheckSlots = new int[numClassTypes + type.getNumInterfaceTypes() * 2];
            System.arraycopy(type.openTypeWorldTypeCheckSlots, 0, openTypeWorldTypeCheckSlots, 0, numClassTypes);
            int typeSlotIdx = numClassTypes;
            for (int interfaceIdx = 0; interfaceIdx < type.numInterfaceTypes; ++interfaceIdx) {
                int itableDynamicHubOffset;
                int typeID = type.getOpenTypeWorldTypeCheckSlots()[numClassTypes + interfaceIdx];
                int itableStartingOffset = type.itableStartingOffsets.length > 0 ? type.itableStartingOffsets[interfaceIdx] : -1159918307;
                openTypeWorldTypeCheckSlots[typeSlotIdx] = typeID;
                openTypeWorldTypeCheckSlots[typeSlotIdx + 1] = itableDynamicHubOffset = dynamicHubLayout.vTableOffset() + itableStartingOffset * dynamicHubLayout.vTableSlotSize;
                typeSlotIdx += 2;
            }
            WordBase[] vtable = UniverseBuilder.createVTable(type.openTypeWorldDispatchTables);
            hub.setOpenTypeWorldData(vtable, type.getTypeID(), type.getTypeIDDepth(), type.getNumClassTypes(), type.getNumInterfaceTypes(), openTypeWorldTypeCheckSlots);
        }
    }

    private static WordBase[] createVTable(HostedMethod[] methods) {
        if (methods.length == 0) {
            return EMPTY_VTABLE;
        }
        WordBase[] vtable = new WordBase[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            HostedMethod method = methods[i];
            vtable[i] = SubstrateOptions.useRelativeCodePointers() ? new MethodOffset(method) : new MethodPointer(method);
        }
        return vtable;
    }

    private static ReferenceMapEncoder.Input createReferenceMap(HostedType type) {
        HostedInstanceClass instanceClass;
        int monitorOffset;
        HostedField[] fields = type.getInstanceFields(true);
        SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
        for (HostedField field : fields) {
            if (field.getType().getStorageKind() != JavaKind.Object || !field.hasLocation() || UniverseBuilder.excludeFromReferenceMap(field)) continue;
            referenceMap.markReferenceAtOffset(field.getLocation(), true);
        }
        if (type.isInstanceClass() && (monitorOffset = (instanceClass = (HostedInstanceClass)type).getMonitorFieldOffset()) >= 0) {
            referenceMap.markReferenceAtOffset(monitorOffset, true);
        }
        return referenceMap;
    }

    private static boolean excludeFromReferenceMap(HostedField field) {
        ExcludeFromReferenceMap annotation = field.getAnnotation(ExcludeFromReferenceMap.class);
        if (annotation != null) {
            return ((BooleanSupplier)ReflectionUtil.newInstance(annotation.onlyIf())).getAsBoolean();
        }
        return false;
    }

    public static class StaticFieldOffsets {
        public int nextPrimitiveField = 0;
        public int nextObjectField = 0;
    }
}

