/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredImageHooks;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.VTableBuilder;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import com.oracle.svm.shaded.org.capnproto.StructList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class LayeredDispatchTableFeature
implements FeatureSingleton,
InternalFeature {
    final Map<HostedType, PriorDispatchTable> priorDispatchTableCache = ImageLayerBuildingSupport.buildingExtensionLayer() ? new ConcurrentHashMap() : null;
    final Map<Integer, PriorDispatchMethod> priorDispatchMethodCache = ImageLayerBuildingSupport.buildingExtensionLayer() ? new ConcurrentHashMap() : null;
    final Set<HostedMethod> virtualCallTargets = ImageLayerBuildingSupport.buildingSharedLayer() ? ConcurrentHashMap.newKeySet() : null;
    final boolean generateUnresolvedSymbolNames = ImageLayerBuildingSupport.buildingSharedLayer();
    Map<HostedMethod, Integer> persistedHostedMethodIndexMap = ImageLayerBuildingSupport.buildingSharedLayer() ? new ConcurrentHashMap() : null;
    final Map<MethodPointer, HostedDispatchSlot> methodPointerToDispatchSlot = new IdentityHashMap<MethodPointer, HostedDispatchSlot>();
    final Map<HostedType, HostedDispatchTable> typeToDispatchTable = new HashMap<HostedType, HostedDispatchTable>();
    private Set<Module> builderModules;
    static final int INVALID_HOSTED_METHOD_INDEX = -1;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
            LayeredDispatchTableFeature.getPriorVirtualCallTargets().forEach(aMethod -> config.registerAsRoot((AnalysisMethod)aMethod, false, "in prior layer dispatch table", new MultiMethod.MultiMethodKey[0]));
        }
        LayeredImageHooks.registerDynamicHubWrittenCallback(this::onDynamicHubWritten);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        this.installBuilderModules(access.getImageClassLoader().getBuilderModules());
    }

    private PriorDispatchMethod createPriorDispatchMethodInfo(int index) {
        return this.priorDispatchMethodCache.computeIfAbsent(index, i -> {
            SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader reader = loader.getHostedMethodData((int)i);
            return new PriorDispatchMethod(reader.getMethodId(), reader.getSymbolName().toString(), reader.getVTableIndex(), reader.getIsVirtualCallTarget());
        });
    }

    private PriorDispatchTable createPriorDispatchTable(HostedType hType) {
        PriorDispatchSlot[] dispatchSlots;
        SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
        SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader hubInfo = loader.getDynamicHubInfo(hType.getWrapped());
        PrimitiveList.Int.Reader localSlotIds = hubInfo.getLocallyDeclaredSlotsHostedMethodIndexes();
        PriorDispatchMethod[] locallyDeclaredSlots = new PriorDispatchMethod[hubInfo.getLocallyDeclaredSlotsHostedMethodIndexes().size()];
        for (int i = 0; i < locallyDeclaredSlots.length; ++i) {
            locallyDeclaredSlots[i] = this.createPriorDispatchMethodInfo(localSlotIds.get(i));
        }
        if (hubInfo.hasDispatchTableSlotValues()) {
            StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader> dispatchSlotsReader = hubInfo.getDispatchTableSlotValues();
            dispatchSlots = new PriorDispatchSlot[dispatchSlotsReader.size()];
            for (int i = 0; i < dispatchSlots.length; ++i) {
                PriorDispatchSlot dispatchSlot;
                SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader slotInfo = (SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader)((Object)dispatchSlotsReader.get(i));
                PriorDispatchMethod declaredMethod = this.createPriorDispatchMethodInfo(slotInfo.getDeclaredHostedMethodIndex());
                PriorDispatchMethod resolvedMethod = null;
                if (slotInfo.getResolvedHostedMethodIndex() != -1) {
                    resolvedMethod = this.createPriorDispatchMethodInfo(slotInfo.getResolvedHostedMethodIndex());
                }
                SlotResolutionStatus status = SlotResolutionStatus.values()[slotInfo.getResolutionStatus()];
                String slotSymbolName = slotInfo.getSlotSymbolName().toString();
                dispatchSlots[i] = dispatchSlot = new PriorDispatchSlot(declaredMethod, resolvedMethod, slotInfo.getSlotIndex(), status, slotSymbolName);
            }
        } else {
            dispatchSlots = PriorDispatchSlot.EMPTY_ARRAY;
        }
        return new PriorDispatchTable(hubInfo.getTypeId(), hubInfo.getInstalled(), locallyDeclaredSlots, dispatchSlots);
    }

    private PriorDispatchTable getPriorDispatchTable(HostedType hType) {
        if (hType.getWrapped().isInBaseLayer()) {
            return this.priorDispatchTableCache.computeIfAbsent(hType, this::createPriorDispatchTable);
        }
        return null;
    }

    private static Set<String> getPriorUnresolvedSymbols() {
        HashSet<String> unresolvedSymbols = new HashSet<String>();
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader> hubInfos = HostedImageLayerBuildingSupport.singleton().getLoader().getDynamicHubInfos();
        for (SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader hubInfo : hubInfos) {
            if (!hubInfo.getInstalled()) continue;
            assert (hubInfo.hasDispatchTableSlotValues());
            StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader> dispatchSlots = hubInfo.getDispatchTableSlotValues();
            for (SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader slotInfo : dispatchSlots) {
                SlotResolutionStatus status = SlotResolutionStatus.values()[slotInfo.getResolutionStatus()];
                String slotSymbolName = slotInfo.getSlotSymbolName().toString();
                if (status != SlotResolutionStatus.UNRESOLVED && status != SlotResolutionStatus.NOT_COMPILED) continue;
                assert (!slotSymbolName.equals("invalid"));
                unresolvedSymbols.add(slotSymbolName);
            }
        }
        return Collections.unmodifiableSet(unresolvedSymbols);
    }

    static Stream<AnalysisMethod> getPriorVirtualCallTargets() {
        SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader> methods = loader.getHostedMethods();
        return StreamSupport.stream(methods.spliterator(), false).filter(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader::getIsVirtualCallTarget).map(data -> {
            assert (data.getMethodId() != -1);
            return loader.getAnalysisMethodForBaseLayerId(data.getMethodId());
        });
    }

    public static LayeredDispatchTableFeature singleton() {
        return (LayeredDispatchTableFeature)ImageSingletons.lookup(LayeredDispatchTableFeature.class);
    }

    void installBuilderModules(Set<Module> newCoreTypes) {
        assert (this.builderModules == null) : this.builderModules;
        this.builderModules = newCoreTypes;
    }

    public void recordVirtualCallTarget(HostedMethod caller, HostedMethod callee) {
        Module callerModule = caller.getDeclaringClass().getJavaClass().getModule();
        Module calleeModule = callee.getDeclaringClass().getJavaClass().getModule();
        if (!this.builderModules.contains(callerModule) && !this.builderModules.contains(calleeModule)) {
            this.virtualCallTargets.add(callee);
        }
    }

    public void registerDeclaredDispatchInfo(HostedType type, List<HostedMethod> declaredMethods) {
        HostedDispatchTable dispatchTable = new HostedDispatchTable();
        dispatchTable.type = type;
        dispatchTable.locallyDeclaredSlots = (HostedMethod[])declaredMethods.toArray(HostedMethod[]::new);
        HostedDispatchTable prev = this.typeToDispatchTable.put(type, dispatchTable);
        assert (prev == null) : prev;
    }

    public void registerArrayDispatchTable(HostedType arrayType, HostedType objectType) {
        assert (!this.typeToDispatchTable.containsKey(arrayType));
        HostedDispatchTable objDispatchTable = this.typeToDispatchTable.get(objectType);
        HostedDispatchTable arrayDispatchTable = new HostedDispatchTable();
        arrayDispatchTable.type = arrayType;
        arrayDispatchTable.locallyDeclaredSlots = objDispatchTable.locallyDeclaredSlots;
        arrayDispatchTable.status = HubStatus.DISPATCH_INFO_CALCULATED;
        arrayDispatchTable.slots = (HostedDispatchSlot[])Arrays.stream(objDispatchTable.slots).map(objSlotInfo -> {
            HostedDispatchSlot arraySlotInfo = new HostedDispatchSlot();
            arraySlotInfo.dispatchTable = arrayDispatchTable;
            arraySlotInfo.declaredMethod = objSlotInfo.declaredMethod;
            arraySlotInfo.resolvedMethod = objSlotInfo.resolvedMethod;
            arraySlotInfo.slotIndex = objSlotInfo.slotIndex;
            arraySlotInfo.status = objSlotInfo.status;
            return arraySlotInfo;
        }).toArray(HostedDispatchSlot[]::new);
        this.injectPriorLayerInfo(arrayType, arrayDispatchTable);
        HostedDispatchTable prev = this.typeToDispatchTable.put(arrayType, arrayDispatchTable);
        assert (prev == null) : prev;
    }

    public void registerNonArrayDispatchTable(HostedType type, boolean[] validTarget) {
        HostedDispatchTable dispatchTable = this.typeToDispatchTable.get(type);
        dispatchTable.status = HubStatus.DISPATCH_INFO_CALCULATED;
        assert (dispatchTable.slots == null);
        HostedMethod[] resolvedMethods = type.getOpenTypeWorldDispatchTables();
        HostedMethod[] targetMethods = type.getOpenTypeWorldDispatchTableSlotTargets();
        int length = validTarget.length;
        assert (resolvedMethods.length == length && targetMethods.length == length) : Assertions.errorMessage((Object[])new Object[]{resolvedMethods, targetMethods, validTarget});
        HostedDispatchSlot[] slotInfos = new HostedDispatchSlot[length];
        for (int i = 0; i < length; ++i) {
            HostedDispatchSlot slot = new HostedDispatchSlot();
            slot.dispatchTable = dispatchTable;
            slot.slotIndex = i;
            slot.resolvedMethod = validTarget[i] ? resolvedMethods[i] : null;
            slot.declaredMethod = targetMethods[i];
            slot.status = validTarget[i] ? SlotResolutionStatus.COMPUTED : SlotResolutionStatus.UNRESOLVED;
            slotInfos[i] = slot;
        }
        dispatchTable.slots = slotInfos;
        this.injectPriorLayerInfo(type, dispatchTable);
    }

    private void injectPriorLayerInfo(HostedType type, HostedDispatchTable dispatchTable) {
        PriorDispatchTable priorInfo;
        if (type.getWrapped().isInBaseLayer() && (priorInfo = this.getPriorDispatchTable(type)) != null) {
            LayeredDispatchTableFeature.compareTypeInfo(dispatchTable, priorInfo);
            HubStatus hubStatus = dispatchTable.status = priorInfo.installed ? HubStatus.INSTALLED_PRIOR_LAYER : HubStatus.COMPUTED_PRIOR_LAYER;
            if (priorInfo.installed) {
                for (int i = 0; i < dispatchTable.slots.length; ++i) {
                    HostedDispatchSlot slot = dispatchTable.slots[i];
                    PriorDispatchSlot priorSlot = priorInfo.slots[i];
                    if (!priorSlot.status.isCompiled()) continue;
                    slot.status = SlotResolutionStatus.PRIOR_LAYER;
                    assert (!priorSlot.slotSymbolName.equals("invalid"));
                    slot.symbol = priorSlot.slotSymbolName;
                }
            }
        }
    }

    private static String compareMethod(HostedMethod curMethod, PriorDispatchMethod priorMethod) {
        int curVTableIdx;
        String priorSymbol;
        String curSymbol;
        Object errorMessage = "";
        int priorId = priorMethod.methodId();
        int curId = curMethod.getWrapped().getId();
        if (priorId != -1 && curId != priorId) {
            errorMessage = (String)errorMessage + String.format("mismatch in id %s %s%n", curId, priorId);
        }
        if (!(curSymbol = NativeImage.localSymbolNameForMethod(curMethod)).equals(priorSymbol = priorMethod.symbolName)) {
            errorMessage = (String)errorMessage + String.format("mismatch in symbol name %s %s%n", curSymbol, priorSymbol);
        }
        int priorVTableIdx = priorMethod.vtableIndex;
        int n = curVTableIdx = curMethod.hasVTableIndex() ? curMethod.getVTableIndex() : -1;
        if (priorVTableIdx != -1 && curVTableIdx != -1 && priorVTableIdx != curVTableIdx) {
            errorMessage = (String)errorMessage + String.format("mismatch in vtable index %s %s%n", curVTableIdx, priorVTableIdx);
        }
        if (!((String)errorMessage).isEmpty()) {
            errorMessage = String.format("Issue while comparing method %s %s%n", curMethod.getQualifiedName(), priorMethod) + (String)errorMessage;
        }
        return errorMessage;
    }

    private static void compareTypeInfo(HostedDispatchTable curInfo, PriorDispatchTable priorInfo) {
        int i;
        if (!Options.LogLayeredDispatchTableDiscrepancies.getValue().booleanValue() && !Options.ErrorOnLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
            return;
        }
        Object errorMessage = "";
        if (curInfo.locallyDeclaredSlots.length == priorInfo.locallyDeclaredSlots.length) {
            for (i = 0; i < curInfo.locallyDeclaredSlots.length; ++i) {
                errorMessage = (String)errorMessage + LayeredDispatchTableFeature.compareMethod(curInfo.locallyDeclaredSlots[i], priorInfo.locallyDeclaredSlots[i]);
            }
        } else {
            errorMessage = (String)errorMessage + String.format("Mismatch in locally declared slot length %s %s%n", curInfo.locallyDeclaredSlots.length, priorInfo.locallyDeclaredSlots.length);
        }
        if (curInfo.slots.length == priorInfo.slots.length) {
            for (i = 0; i < curInfo.slots.length; ++i) {
                HostedDispatchSlot curSlotInfo = curInfo.slots[i];
                PriorDispatchSlot priorSlotInfo = priorInfo.slots[i];
                LayeredDispatchTableFeature.compareMethod(curSlotInfo.declaredMethod, priorSlotInfo.declaredMethod);
                if (curSlotInfo.resolvedMethod == null || !priorSlotInfo.status.isResolved()) continue;
                LayeredDispatchTableFeature.compareMethod(curSlotInfo.resolvedMethod, priorSlotInfo.resolvedMethod);
            }
        } else {
            errorMessage = (String)errorMessage + String.format("Mismatch in dispatch table slot length %s %s%n", curInfo.slots.length, priorInfo.slots.length);
        }
        if (!((String)errorMessage).isEmpty()) {
            String message = String.format("Issue while comparing dispatch table info: %s and %s%n%s", curInfo, priorInfo, errorMessage);
            if (Options.ErrorOnLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
                throw VMError.shouldNotReachHere(message);
            }
            if (Options.LogLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
                System.out.println(message);
            }
        }
    }

    public void onDynamicHubWritten(LayeredImageHooks.WrittenDynamicHubInfo hubInfo) {
        AnalysisType aType = ((SVMHost)hubInfo.aUniverse().hostVM()).lookupType(hubInfo.hub());
        HostedType hType = hubInfo.hUniverse().lookup((JavaType)aType);
        assert (hType.getWrapped().isReachable()) : "All installed hubs should be reachable " + String.valueOf(hType);
        Object vTable = hubInfo.vTable();
        int vtableLength = Array.getLength(vTable);
        if (VTableBuilder.hasEmptyDispatchTable(hType)) {
            assert (vtableLength == 0) : hType;
            return;
        }
        HostedDispatchTable dispatchTable = this.typeToDispatchTable.get(hType);
        assert (dispatchTable.status == HubStatus.DISPATCH_INFO_CALCULATED || dispatchTable.status == HubStatus.COMPUTED_PRIOR_LAYER) : dispatchTable;
        dispatchTable.status = HubStatus.INSTALLED_CURRENT_LAYER;
        assert (dispatchTable.slots.length == vtableLength) : Assertions.errorMessage((Object[])new Object[]{vTable, dispatchTable.slots});
        for (int i = 0; i < vtableLength; ++i) {
            MethodPointer methodPointer = (MethodPointer)Array.get(vTable, i);
            HostedDispatchSlot slot = dispatchTable.slots[i];
            HostedDispatchSlot prev = this.methodPointerToDispatchSlot.put(methodPointer, slot);
            assert (prev == null) : prev;
        }
    }

    private static String computeUnresolvedMethodSymbol(HostedDispatchSlot slotInfo, Map<ResolvedJavaMethod, String> methodToSymbolMap) {
        ResolvedJavaMethod resolvedMethod = null;
        if (slotInfo.status == SlotResolutionStatus.NOT_COMPILED) {
            resolvedMethod = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)slotInfo.resolvedMethod);
        } else {
            assert (slotInfo.status == SlotResolutionStatus.UNRESOLVED) : slotInfo;
            ResolvedJavaType originalType = OriginalClassProvider.getOriginalType((JavaType)slotInfo.dispatchTable.type);
            ResolvedJavaMethod originalMethod = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)slotInfo.declaredMethod);
            if (originalMethod != null) {
                resolvedMethod = originalType.resolveMethod(originalMethod, originalMethod.getDeclaringClass());
            }
        }
        Object unresolvedTableSymbol = resolvedMethod != null ? methodToSymbolMap.computeIfAbsent(resolvedMethod, k -> String.format("%s_unresolvedVTableSym", NativeImage.localSymbolNameForMethod(k))) : SubstrateOptions.ImageSymbolsPrefix.getValue() + String.format("unresolvedVTableSym_typeid%s_slot%s", slotInfo.dispatchTable.type.getWrapped().getId(), slotInfo.slotIndex);
        return unresolvedTableSymbol;
    }

    /*
     * WARNING - void declaration
     */
    public void defineDispatchTableSlotSymbols(ObjectFile objectFile, ObjectFile.Section textSection, NativeImageCodeCache codeCache, HostedMetaAccess metaAccess) {
        HostedMethod invalidMethod = metaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        HashMap<String, HostedMethod> resolvedPriorVTableMap = new HashMap<String, HostedMethod>();
        HashSet<String> unresolvedVTableSymbolNames = this.generateUnresolvedSymbolNames ? new HashSet<String>() : null;
        HashMap<ResolvedJavaMethod, String> deduplicatedMethodMap = new HashMap<ResolvedJavaMethod, String>();
        for (HostedDispatchSlot hostedDispatchSlot : this.methodPointerToDispatchSlot.values()) {
            void var11_15;
            assert (hostedDispatchSlot.dispatchTable.status == HubStatus.INSTALLED_CURRENT_LAYER);
            if (hostedDispatchSlot.status == SlotResolutionStatus.COMPUTED) {
                hostedDispatchSlot.status = hostedDispatchSlot.resolvedMethod.isCompiled() ? SlotResolutionStatus.CURRENT_LAYER : SlotResolutionStatus.NOT_COMPILED;
            }
            Object var11_16 = null;
            if (!hostedDispatchSlot.status.isCompiled()) {
                String string;
                assert (hostedDispatchSlot.status == SlotResolutionStatus.UNRESOLVED || hostedDispatchSlot.status == SlotResolutionStatus.NOT_COMPILED) : hostedDispatchSlot;
                if (this.generateUnresolvedSymbolNames && unresolvedVTableSymbolNames.add(string = LayeredDispatchTableFeature.computeUnresolvedMethodSymbol(hostedDispatchSlot, deduplicatedMethodMap))) {
                    objectFile.createUndefinedSymbol(string, 0, true);
                }
            } else {
                String string = NativeImage.localSymbolNameForMethod(hostedDispatchSlot.resolvedMethod);
            }
            hostedDispatchSlot.symbol = var11_15;
        }
        for (HostedDispatchTable hostedDispatchTable : this.typeToDispatchTable.values()) {
            if (hostedDispatchTable.status != HubStatus.INSTALLED_PRIOR_LAYER) continue;
            for (HostedDispatchSlot slotInfo : hostedDispatchTable.slots) {
                if (slotInfo.status != SlotResolutionStatus.COMPUTED || !slotInfo.resolvedMethod.isCompiled()) continue;
                PriorDispatchTable priorInfo = this.getPriorDispatchTable(slotInfo.dispatchTable.type);
                String symName = priorInfo.slots[slotInfo.slotIndex].slotSymbolName;
                HostedMethod prev = resolvedPriorVTableMap.put(symName, slotInfo.resolvedMethod);
                assert (prev == null || prev.equals(slotInfo.resolvedMethod));
            }
        }
        for (Map.Entry entry : resolvedPriorVTableMap.entrySet()) {
            String string = (String)entry.getKey();
            HostedMethod method = (HostedMethod)entry.getValue();
            CompilationResult result = codeCache.compilationResultFor(method);
            int size = result == null ? 0 : result.getTargetCodeSize();
            objectFile.createDefinedSymbol(string, (ObjectFile.Element)textSection, (long)method.getCodeAddressOffset(), size, true, true);
        }
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            LayeredDispatchTableFeature.getPriorUnresolvedSymbols().forEach(symbol -> {
                if (!resolvedPriorVTableMap.containsKey(symbol)) {
                    CompilationResult result = codeCache.compilationResultFor(invalidMethod);
                    int size = result == null ? 0 : result.getTargetCodeSize();
                    objectFile.createDefinedSymbol(symbol, (ObjectFile.Element)textSection, (long)invalidMethod.getCodeAddressOffset(), size, true, true);
                }
            });
        }
    }

    public String getSymbolName(MethodPointer methodPointer, HostedMethod target, boolean injectedNotCompiled) {
        HostedDispatchSlot slotInfo = this.methodPointerToDispatchSlot.get(methodPointer);
        String symbol = NativeImage.localSymbolNameForMethod(target);
        if (slotInfo != null) {
            if (!slotInfo.status.isCompiled()) {
                assert (slotInfo.status == SlotResolutionStatus.UNRESOLVED || slotInfo.status == SlotResolutionStatus.NOT_COMPILED) : slotInfo;
                if (this.generateUnresolvedSymbolNames) {
                    assert (slotInfo.symbol != null) : slotInfo;
                    symbol = slotInfo.symbol;
                }
            } else assert (slotInfo.symbol.equals(symbol));
        }
        return symbol;
    }

    public HostedMethod[] acquireHostedMethodArray() {
        return (HostedMethod[])this.persistedHostedMethodIndexMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).toArray(HostedMethod[]::new);
    }

    public void releaseHostedMethodArray() {
        this.persistedHostedMethodIndexMap = null;
    }

    public void persistHostedMethod(HostedMethod hMethod, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Builder> methodInfoBuilderSupplier) {
        assert (this.persistedHostedMethodIndexMap.containsKey(hMethod));
        boolean persistedMethod = hMethod.getWrapped().isTrackedAcrossLayers();
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Builder builder = methodInfoBuilderSupplier.get();
        builder.setIndex(this.persistedHostedMethodIndexMap.get(hMethod));
        builder.setMethodId(persistedMethod ? hMethod.getWrapped().getId() : -1);
        builder.setSymbolName(NativeImage.localSymbolNameForMethod(hMethod));
        builder.setVTableIndex(hMethod.hasVTableIndex() ? hMethod.getVTableIndex() : -1);
        builder.setIsVirtualCallTarget(this.virtualCallTargets.contains(hMethod));
        builder.setInstalledOffset(hMethod.isCodeAddressOffsetValid() ? hMethod.getCodeAddressOffset() : -1);
        if (persistedMethod) {
            builder.setHostedMethodName(hMethod.getName());
            builder.setHostedMethodUniqueName(hMethod.getUniqueShortName());
        }
    }

    public int getPersistedHostedMethodIndex(HostedMethod hMethod) {
        int nextIdx = this.persistedHostedMethodIndexMap.size();
        this.persistedHostedMethodIndexMap.putIfAbsent(hMethod, nextIdx);
        return this.persistedHostedMethodIndexMap.get(hMethod);
    }

    public void persistDynamicHubInfo(HostedType hType, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Builder> typeInfoBuilderSupplier) {
        SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Builder typeInfoBuilder = typeInfoBuilderSupplier.get();
        typeInfoBuilder.setTypeId(hType.getWrapped().getId());
        typeInfoBuilder.setTypecheckId(hType.getTypeID());
        typeInfoBuilder.setNumClassTypes(hType.getNumClassTypes());
        typeInfoBuilder.setNumInterfaceTypes(hType.getNumInterfaceTypes());
        SVMImageLayerWriter.initInts(typeInfoBuilder::initTypecheckSlotValues, Arrays.stream(hType.getOpenTypeWorldTypeCheckSlots()));
        HostedDispatchTable hDispatchTable = this.typeToDispatchTable.get(hType);
        if (hDispatchTable != null) {
            boolean hubInstalled = hDispatchTable.status == HubStatus.INSTALLED_CURRENT_LAYER;
            typeInfoBuilder.setInstalled(hubInstalled);
            SVMImageLayerWriter.initInts(typeInfoBuilder::initLocallyDeclaredSlotsHostedMethodIndexes, Arrays.stream(hDispatchTable.locallyDeclaredSlots).mapToInt(this::getPersistedHostedMethodIndex));
            assert (hDispatchTable.status != HubStatus.UNINITIALIZED || hDispatchTable.slots == null) : hType;
            if (hDispatchTable.slots != null) {
                SVMImageLayerWriter.initSortedArray(typeInfoBuilder::initDispatchTableSlotValues, hDispatchTable.slots, (dispatchSlot, dispatchSlotInfoSupplier) -> this.persistDynamicSlot((HostedDispatchSlot)dispatchSlot, (Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Builder>)dispatchSlotInfoSupplier, hubInstalled));
            }
        } else assert (hType.isPrimitive()) : hType;
    }

    private void persistDynamicSlot(HostedDispatchSlot dispatchSlot, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Builder> dispatchSlotInfoSupplier, boolean hubInstalled) {
        SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Builder dispatchSlotBuilder = dispatchSlotInfoSupplier.get();
        dispatchSlotBuilder.setSlotIndex(dispatchSlot.slotIndex);
        dispatchSlotBuilder.setResolutionStatus(dispatchSlot.status.ordinal());
        dispatchSlotBuilder.setDeclaredHostedMethodIndex(this.getPersistedHostedMethodIndex(dispatchSlot.declaredMethod));
        dispatchSlotBuilder.setResolvedHostedMethodIndex(dispatchSlot.status.isResolved() ? this.getPersistedHostedMethodIndex(dispatchSlot.resolvedMethod) : -1);
        dispatchSlotBuilder.setSlotSymbolName(hubInstalled ? dispatchSlot.symbol : "invalid");
    }

    record PriorDispatchMethod(int methodId, String symbolName, int vtableIndex, boolean isVirtualCallTarget) {
        static final int UNPERSISTED_METHOD_ID = -1;
    }

    record PriorDispatchSlot(PriorDispatchMethod declaredMethod, PriorDispatchMethod resolvedMethod, int slotIndex, SlotResolutionStatus status, String slotSymbolName) {
        static final String INVALID_SYMBOL_NAME = "invalid";
        static final PriorDispatchSlot[] EMPTY_ARRAY = new PriorDispatchSlot[0];
    }

    static enum SlotResolutionStatus {
        UNRESOLVED,
        COMPUTED,
        NOT_COMPILED,
        PRIOR_LAYER,
        CURRENT_LAYER;


        public boolean isResolved() {
            return this != UNRESOLVED;
        }

        public boolean isCompiled() {
            return this == PRIOR_LAYER || this == CURRENT_LAYER;
        }
    }

    record PriorDispatchTable(int typeID, boolean installed, PriorDispatchMethod[] locallyDeclaredSlots, PriorDispatchSlot[] slots) {
    }

    static class HostedDispatchTable {
        HostedType type;
        HostedMethod[] locallyDeclaredSlots;
        HostedDispatchSlot[] slots;
        HubStatus status = HubStatus.UNINITIALIZED;

        HostedDispatchTable() {
        }
    }

    static enum HubStatus {
        UNINITIALIZED,
        DISPATCH_INFO_CALCULATED,
        COMPUTED_PRIOR_LAYER,
        INSTALLED_PRIOR_LAYER,
        INSTALLED_CURRENT_LAYER;

    }

    static class HostedDispatchSlot {
        HostedDispatchTable dispatchTable;
        HostedMethod declaredMethod;
        HostedMethod resolvedMethod;
        int slotIndex;
        SlotResolutionStatus status;
        String symbol;

        HostedDispatchSlot() {
        }
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> LogLayeredDispatchTableDiscrepancies = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> ErrorOnLayeredDispatchTableDiscrepancies = new HostedOptionKey<Boolean>(false);
    }
}

