/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.ClassInclusionPolicy;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.JRTSupport;
import com.oracle.svm.core.jdk.localization.BundleContentSubstitutedLocalizationSupport;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.SecurityServicesFeature;
import com.oracle.svm.hosted.driver.IncludeOptionsSupport;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class PreserveOptionsSupport
extends IncludeOptionsSupport {
    public static final String PRESERVE_ALL = "all";
    public static final String PRESERVE_NONE = "none";
    public static final Set<String> JDK_MODULES_TO_PRESERVE = Set.of("java.base", "java.desktop", "java.xml", "java.xml.crypto", "jdk.xml.dom", "java.rmi", "jdk.net", "java.smartcardio", "jdk.charsets", "java.sql", "java.sql.rowset", "java.transaction.xa", "java.datatransfer", "java.security.sasl", "jdk.security.jgss", "jdk.security.auth", "jdk.crypto.cryptoki", "java.logging", "jdk.management", "java.management", "java.naming", "jdk.naming.dns", "jdk.httpserver", "jdk.zipfs", "jdk.nio.mapmode", "java.instrument", "java.prefs", "jdk.unsupported", "jdk.unsupported.desktop", "jdk.accessibility");

    private static String preservePossibleOptions() {
        return String.format("[%s, %s, %s]", PRESERVE_ALL, PRESERVE_NONE, IncludeOptionsSupport.possibleExtendedOptions());
    }

    public static void parsePreserveOption(EconomicMap<OptionKey<?>, Object> hostedValues, NativeImageClassLoaderSupport classLoaderSupport) {
        OptionValues optionValues = new OptionValues(hostedValues);
        AccumulatingLocatableMultiOptionValue.Strings preserve = (AccumulatingLocatableMultiOptionValue.Strings)SubstrateOptions.Preserve.getValue(optionValues);
        Stream<LocatableMultiOptionValue.ValueWithOrigin<LocatableMultiOptionValue.ValueWithOrigin>> valuesWithOrigins = preserve.getValuesWithOrigins();
        valuesWithOrigins.forEach(valueWithOrigin -> {
            String optionArgument = SubstrateOptionsParser.commandArgument(SubstrateOptions.Preserve, (String)valueWithOrigin.value(), true, false);
            if (!valueWithOrigin.origin().commandLineLike()) {
                throw UserError.abort("Using %s is only allowed on command line. The option was used from %s", optionArgument, valueWithOrigin.origin());
            }
            List<String> options = Arrays.stream(((String)valueWithOrigin.value()).split(",")).toList();
            block8: for (String option : options) {
                UserError.guarantee(!option.isEmpty(), "Option %s from %s cannot be passed an empty string. The possible options are: %s", optionArgument, valueWithOrigin.origin(), PreserveOptionsSupport.preservePossibleOptions());
                switch (option) {
                    case "all": {
                        classLoaderSupport.setPreserveAll((LocatableMultiOptionValue.ValueWithOrigin<String>)valueWithOrigin);
                        continue block8;
                    }
                    case "none": {
                        classLoaderSupport.clearPreserveSelectors();
                        continue block8;
                    }
                }
                PreserveOptionsSupport.parseIncludeSelector(optionArgument, valueWithOrigin, classLoaderSupport.getPreserveSelectors(), IncludeOptionsSupport.ExtendedOption.parse(option), PreserveOptionsSupport.preservePossibleOptions());
            }
        });
        if (classLoaderSupport.isPreserveMode()) {
            if (PointstoOptions.UseConservativeUnsafeAccess.hasBeenSet(optionValues)) {
                UserError.guarantee((Boolean)PointstoOptions.UseConservativeUnsafeAccess.getValue(optionValues), "%s can not be used together with %s. Please unset %s.", SubstrateOptionsParser.commandArgument(PointstoOptions.UseConservativeUnsafeAccess, "-"), SubstrateOptionsParser.commandArgument(SubstrateOptions.Preserve, "<value>"), SubstrateOptionsParser.commandArgument(PointstoOptions.UseConservativeUnsafeAccess, "-"));
            }
            PointstoOptions.UseConservativeUnsafeAccess.update(hostedValues, (Object)true);
        }
        if (classLoaderSupport.isPreserveAll()) {
            LocalizationFeature.Options.AddAllCharsets.update(hostedValues, true);
            LocalizationFeature.Options.IncludeAllLocales.update(hostedValues, true);
            JRTSupport.Options.AllowJRTFileSystem.update(hostedValues, true);
            List<String> missingJDKProtocols = List.of("http", "https", "ftp", "jar", "mailto", "jrt", "jmod");
            for (String missingProtocol : missingJDKProtocols) {
                SubstrateOptions.EnableURLProtocols.update(hostedValues, missingProtocol);
            }
            SecurityServicesFeature.Options.AdditionalSecurityProviders.update(hostedValues, PreserveOptionsSupport.getSecurityProvidersCSV());
            MetadataTracer.Options.MetadataTracingSupport.update(hostedValues, true);
        }
    }

    private static String getSecurityProvidersCSV() {
        StringJoiner joiner = new StringJoiner(",");
        for (Provider provider : Security.getProviders()) {
            Class<?> aClass = provider.getClass();
            String typeName = aClass.getTypeName();
            joiner.add(typeName);
        }
        return joiner.toString();
    }

    public static void registerPreservedClasses(NativeImageClassLoaderSupport classLoaderSupport) {
        Set classesOrPackagesToIgnore = SubstrateOptions.IgnorePreserveForClasses.getValue().valuesAsSet();
        List<Class> classesToPreserve = classLoaderSupport.getClassesToPreserve().filter(ClassInclusionPolicy::isClassIncludedBase).filter(c -> !classesOrPackagesToIgnore.contains(c.getPackageName()) && !classesOrPackagesToIgnore.contains(c.getName())).sorted(Comparator.comparing(ReflectionUtil::getClassHierarchyDepth).reversed()).toList();
        RuntimeReflectionSupport reflection = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        RuntimeResourceSupport resources = RuntimeResourceSupport.singleton();
        RuntimeProxyCreationSupport proxy = (RuntimeProxyCreationSupport)ImageSingletons.lookup(RuntimeProxyCreationSupport.class);
        RuntimeSerializationSupport serialization = RuntimeSerializationSupport.singleton();
        ConfigurationCondition always = ConfigurationCondition.alwaysTrue();
        classesToPreserve.forEach(c -> {
            PreserveOptionsSupport.registerType(reflection, c);
            TypeDescriptor.OfField arrayType = c.arrayType();
            PreserveOptionsSupport.registerType(reflection, arrayType);
            PreserveOptionsSupport.registerType(reflection, ((Class)arrayType).arrayType());
            if (c.getModule() == null && c.isInterface()) {
                proxy.addProxyClass(always, new Class[]{c});
            }
            try {
                for (Field declaredField : c.getDeclaredFields()) {
                    reflection.register(always, false, new Field[]{declaredField});
                }
            }
            catch (LinkageError arr$) {
                // empty catch block
            }
            if (SubstrateOptions.JNI.getValue().booleanValue()) {
                RuntimeJNIAccessSupport jni = (RuntimeJNIAccessSupport)ImageSingletons.lookup(RuntimeJNIAccessSupport.class);
                jni.register(always, new Class[]{c});
                try {
                    for (Method method : c.getDeclaredMethods()) {
                        jni.register(always, false, new Executable[]{method});
                    }
                    for (Executable executable : c.getDeclaredConstructors()) {
                        jni.register(always, false, new Executable[]{executable});
                    }
                    for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                        jni.register(always, false, new Field[]{accessibleObject});
                    }
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            reflection.register(always, !c.isArray() && !c.isInterface() && !c.isPrimitive() && !Modifier.isAbstract(c.getModifiers()), c);
            if (BundleContentSubstitutedLocalizationSupport.isBundleSupported(c)) {
                resources.addResourceBundles((Object)always, c.getTypeName());
            }
        });
        classesToPreserve.reversed().forEach(c -> {
            reflection.registerAllFields(always, c);
            reflection.registerAllMethodsQuery(always, false, c);
            serialization.register((Object)always, c);
        });
        for (String className : classLoaderSupport.getClassNamesToPreserve()) {
            if (classesOrPackagesToIgnore.contains(className)) continue;
            reflection.registerClassLookup(always, className);
        }
    }

    private static void registerType(RuntimeReflectionSupport reflection, Class<?> c) {
        ConfigurationCondition always = ConfigurationCondition.alwaysTrue();
        reflection.register(always, false, c);
        reflection.registerAllDeclaredFields(always, c);
        reflection.registerAllDeclaredMethodsQuery(always, false, c);
        reflection.registerAllDeclaredConstructorsQuery(always, false, c);
        reflection.registerAllConstructorsQuery(always, false, c);
        reflection.registerAllClassesQuery(always, c);
        reflection.registerAllDeclaredClassesQuery(always, c);
        reflection.registerAllNestMembersQuery(always, c);
        reflection.registerAllPermittedSubclassesQuery(always, c);
        reflection.registerAllRecordComponentsQuery(always, c);
        reflection.registerAllSignersQuery(always, c);
    }
}

