/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.VectorAPIDeoptimizationSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.VectorAPIEnabled;
import com.oracle.svm.core.jdk.VectorAPISupport;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jdk.VarHandleFeature;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.vector.replacements.vectorapi.VectorAPIIntrinsics;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class VectorAPIFeature
implements InternalFeature {
    public static final String VECTOR_API_PACKAGE_NAME = "jdk.incubator.vector";
    public static final Class<?> PAYLOAD_CLASS = ReflectionUtil.lookupClass((String)"jdk.internal.vm.vector.VectorSupport$VectorPayload");
    static final Unsafe UNSAFE = Unsafe.getUnsafe();

    public String getDescription() {
        return "Registers Vector API classes for initialization at build time and pre-populates some caches.";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        boolean vectorAPIAvailable;
        boolean vectorAPIEnabled = VectorAPIEnabled.getValue();
        boolean bl = vectorAPIAvailable = access.findClassByName("jdk.incubator.vector.VectorShape") != null;
        if (vectorAPIEnabled && !vectorAPIAvailable) {
            LogUtils.warning((String)"Native image option %s was used, but the application does not have access to the Vector API module. Did you forget to add '--add-modules %s'?", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(SubstrateOptions.VectorAPISupport, "+"), VECTOR_API_PACKAGE_NAME});
        }
        if (!vectorAPIEnabled && vectorAPIAvailable) {
            LogUtils.warning((String)"The application has access to the Vector API module %s. Consider using %s to optimize Vector API operations.", (Object[])new Object[]{VECTOR_API_PACKAGE_NAME, SubstrateOptionsParser.commandArgument(SubstrateOptions.VectorAPISupport, "+")});
        }
        return vectorAPIEnabled && vectorAPIAvailable;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{VECTOR_API_PACKAGE_NAME});
        Class vectorShapeClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorShape");
        UNSAFE.ensureClassInitialized(vectorShapeClass);
        int maxVectorBits = Math.max(VectorAPISupport.singleton().getMaxVectorBytes() * 8, 64);
        Class[] vectorElements = new Class[]{Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE};
        LaneType[] laneTypes = new LaneType[vectorElements.length];
        for (int i = 0; i < vectorElements.length; ++i) {
            laneTypes[i] = LaneType.fromVectorElement(vectorElements[i], i + 1);
        }
        String[] vectorSizes = new String[]{"64", "128", "256", "512", "Max"};
        Shape[] shapes = new Shape[vectorSizes.length];
        for (int i = 0; i < vectorSizes.length; ++i) {
            shapes[i] = new Shape(vectorSizes[i], i + 1);
        }
        Object maxBitShape = ReflectionUtil.readStaticField((Class)vectorShapeClass, (String)"S_Max_BIT");
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)vectorShapeClass, (String)"vectorBitSize"), (receiver, originalValue) -> receiver == maxBitShape ? Integer.valueOf(maxVectorBits) : originalValue);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)vectorShapeClass, (String)"vectorBitSizeLog2"), (receiver, originalValue) -> receiver == maxBitShape ? Integer.valueOf(Integer.numberOfTrailingZeros(maxVectorBits)) : originalValue);
        int maxSizeIndex = Math.min(Integer.numberOfTrailingZeros(maxVectorBits / 64), vectorSizes.length - 1);
        String maxSizeName = shapes[maxSizeIndex].shapeName();
        Object preferredShape = ReflectionUtil.readStaticField((Class)vectorShapeClass, (String)("S_" + maxSizeName + "_BIT"));
        EconomicMap speciesStableFields = EconomicMap.create();
        Class laneTypeClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.LaneType");
        UNSAFE.ensureClassInitialized(laneTypeClass);
        Class speciesClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.AbstractSpecies");
        Object speciesCache = Array.newInstance(speciesClass, (Integer)ReflectionUtil.readStaticField((Class)laneTypeClass, (String)"SK_LIMIT"), (Integer)ReflectionUtil.readStaticField((Class)vectorShapeClass, (String)"SK_LIMIT"));
        UNSAFE.ensureClassInitialized(speciesClass);
        for (LaneType laneType : laneTypes) {
            Method species = ReflectionUtil.lookupMethod(laneType.vectorClass(), (String)"species", (Class[])new Class[]{vectorShapeClass});
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(laneType.vectorClass(), (String)"SPECIES_PREFERRED"), (receiver, originalValue) -> ReflectionUtil.invokeMethod((Method)species, null, (Object[])new Object[]{preferredShape}));
            Class<?> maxVectorClass = VectorAPIFeature.vectorClass(laneType, shapes[shapes.length - 1]);
            int laneCount = VectorAPISupport.singleton().getMaxLaneCount(laneType.elementClass());
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(maxVectorClass, (String)"VSIZE"), (receiver, originalValue) -> maxVectorBits);
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(maxVectorClass, (String)"VLENGTH"), (receiver, originalValue) -> laneCount);
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(maxVectorClass, (String)"ZERO"), (receiver, originalValue) -> VectorAPIFeature.makeZeroVector(maxVectorClass, laneType.elementClass(), laneCount));
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(maxVectorClass, (String)"IOTA"), (receiver, originalValue) -> VectorAPIFeature.makeIotaVector(maxVectorClass, laneType.elementClass(), laneCount));
        }
        Class valueLayoutClass = ReflectionUtil.lookupClass((String)"java.lang.foreign.ValueLayout");
        Method valueLayoutVarHandle = ReflectionUtil.lookupMethod((Class)valueLayoutClass, (String)"varHandle", (Class[])new Class[0]);
        for (LaneType laneType : laneTypes) {
            Object valueLayout = ReflectionUtil.readStaticField(laneType.vectorClass(), (String)"ELEMENT_LAYOUT");
            VarHandle varHandle = (VarHandle)ReflectionUtil.invokeMethod((Method)valueLayoutVarHandle, (Object)valueLayout, (Object[])new Object[0]);
            VarHandleFeature.eagerlyInitializeVarHandle(varHandle);
            for (Shape shape : shapes) {
                String fieldName = "SPECIES_" + shape.shapeName().toUpperCase(Locale.ROOT);
                Object species = ReflectionUtil.readStaticField(laneType.vectorClass(), (String)fieldName);
                int vectorBitSize = shape.shapeName().equals("Max") ? maxVectorBits : Integer.parseInt(shape.shapeName());
                int vectorByteSize = vectorBitSize / 8;
                int laneCount = shape.shapeName().equals("Max") ? VectorAPISupport.singleton().getMaxLaneCount(laneType.elementClass()) : vectorBitSize / laneType.elementBits();
                int laneCountLog2P1 = Integer.numberOfTrailingZeros(laneCount) + 1;
                Method makeDummyVector = ReflectionUtil.lookupMethod((Class)speciesClass, (String)"makeDummyVector", (Class[])new Class[0]);
                Object dummyVector = ReflectionUtil.invokeMethod((Method)makeDummyVector, (Object)species, (Object[])new Object[0]);
                Object laneTypeObject = ReflectionUtil.readStaticField((Class)laneTypeClass, (String)laneType.elementName().toUpperCase(Locale.ROOT));
                speciesStableFields.put(species, (Object)new AbstractSpeciesStableFields(laneCount, laneCountLog2P1, vectorBitSize, vectorByteSize, dummyVector, laneTypeObject));
                Array.set(Array.get(speciesCache, laneType.switchKey()), shape.switchKey(), species);
            }
        }
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"laneCount"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::laneCount));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"laneCountLog2P1"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::laneCountLog2P1));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"vectorBitSize"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::vectorBitSize));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"vectorByteSize"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::vectorByteSize));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"dummyVector"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::dummyVector));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"laneType"), new OverrideFromMap<AbstractSpeciesStableFields>(speciesStableFields, AbstractSpeciesStableFields::laneType));
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)speciesClass, (String)"CACHES"), (receiver, originalValue) -> speciesCache);
        for (LaneType laneType : laneTypes) {
            for (Shape shape : shapes) {
                Class<?> shuffleClass = VectorAPIFeature.vectorShuffleClass(laneType, shape);
                Class<?> maskClass = VectorAPIFeature.vectorMaskClass(laneType, shape);
                access.registerAsUsed(shuffleClass);
                access.registerAsUsed(maskClass);
                if (!shape.shapeName().equals("Max")) continue;
                int laneCount = VectorAPISupport.singleton().getMaxLaneCount(laneType.elementClass());
                Class<Integer> shuffleElement = laneType.elementClass() == Float.TYPE ? Integer.TYPE : (laneType.elementClass() == Double.TYPE ? Long.TYPE : laneType.elementClass());
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(shuffleClass, (String)"VLENGTH"), (receiver, originalValue) -> laneCount);
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(shuffleClass, (String)"IOTA"), (receiver, originalValue) -> VectorAPIFeature.makeIotaVector(shuffleClass, shuffleElement, laneCount));
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(maskClass, (String)"TRUE_MASK"), (receiver, originalValue) -> VectorAPIFeature.makeNewInstanceWithBooleanPayload(maskClass, laneCount, true));
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(maskClass, (String)"FALSE_MASK"), (receiver, originalValue) -> VectorAPIFeature.makeNewInstanceWithBooleanPayload(maskClass, laneCount, false));
            }
        }
        WarmupData warmupData = new WarmupData();
        for (LaneType laneType : laneTypes) {
            VectorAPIFeature.warmupImplCache(laneType.vectorClass(), "UN_IMPL", "unaryOperations", warmupData);
            VectorAPIFeature.warmupImplCache(laneType.vectorClass(), "BIN_IMPL", "binaryOperations", warmupData);
            VectorAPIFeature.warmupImplCache(laneType.vectorClass(), "TERN_IMPL", "ternaryOperations", warmupData);
            VectorAPIFeature.warmupImplCache(laneType.vectorClass(), "REDUCE_IMPL", "reductionOperations", warmupData);
            if (laneType.elementName().equals("Float") || laneType.elementName().equals("Double")) continue;
            VectorAPIFeature.warmupImplCache(laneType.vectorClass(), "BIN_INT_IMPL", "broadcastIntOperations", warmupData);
        }
        Method asIntegral = ReflectionUtil.lookupMethod((Class)speciesClass, (String)"asIntegral", (Class[])new Class[0]);
        Method asFloating = ReflectionUtil.lookupMethod((Class)speciesClass, (String)"asFloating", (Class[])new Class[0]);
        for (LaneType laneType : laneTypes) {
            for (Shape shape : shapes) {
                String fieldName = "SPECIES_" + shape.shapeName().toUpperCase(Locale.ROOT);
                Object species = ReflectionUtil.readStaticField(laneType.vectorClass(), (String)fieldName);
                try {
                    asIntegral.invoke(species, new Object[0]);
                    if (!laneType.elementName().equals("Int") && !laneType.elementName().equals("Long")) continue;
                    asFloating.invoke(species, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
            }
        }
        Class conversionImplClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorOperators$ConversionImpl");
        UNSAFE.ensureClassInitialized(conversionImplClass);
        VectorAPIFeature.makeConversionOperations(conversionImplClass, warmupData);
        if (DeoptimizationSupport.enabled()) {
            VectorAPIDeoptimizationSupport deoptSupport = new VectorAPIDeoptimizationSupport();
            for (LaneType laneType : laneTypes) {
                int elementBytes = laneType.elementBits() >> 3;
                for (Shape shape : shapes) {
                    int vectorLength = shape.shapeName().equals("Max") ? VectorAPISupport.singleton().getMaxLaneCount(laneType.elementClass()) : Integer.parseInt(shape.shapeName()) / 8 / elementBytes;
                    Class<?> vectorClass = VectorAPIFeature.vectorClass(laneType, shape);
                    deoptSupport.putLayout(vectorClass, new VectorAPIDeoptimizationSupport.PayloadLayout(laneType.elementClass(), vectorLength));
                    Class<?> shuffleClass = VectorAPIFeature.vectorShuffleClass(laneType, shape);
                    Class<Integer> shuffleElement = laneType.elementClass() == Float.TYPE ? Integer.TYPE : (laneType.elementClass() == Double.TYPE ? Long.TYPE : laneType.elementClass());
                    deoptSupport.putLayout(shuffleClass, new VectorAPIDeoptimizationSupport.PayloadLayout(shuffleElement, vectorLength));
                    Class<?> maskClass = VectorAPIFeature.vectorMaskClass(laneType, shape);
                    deoptSupport.putLayout(maskClass, new VectorAPIDeoptimizationSupport.PayloadLayout(Boolean.TYPE, vectorLength));
                }
            }
            ImageSingletons.add(VectorAPIDeoptimizationSupport.class, (Object)deoptSupport);
        }
    }

    private static Class<?> vectorClass(LaneType laneType, Shape shape) {
        String baseName = laneType.elementName() + shape.shapeName();
        String vectorClassName = "jdk.incubator.vector." + baseName + "Vector";
        Class vectorClass = ReflectionUtil.lookupClass((String)vectorClassName);
        UNSAFE.ensureClassInitialized(vectorClass);
        return vectorClass;
    }

    private static Class<?> vectorShuffleClass(LaneType laneType, Shape shape) {
        String baseName = laneType.elementName() + shape.shapeName();
        String vectorClassName = "jdk.incubator.vector." + baseName + "Vector";
        Class shuffleClass = ReflectionUtil.lookupClass((String)(vectorClassName + "$" + baseName + "Shuffle"));
        UNSAFE.ensureClassInitialized(shuffleClass);
        return shuffleClass;
    }

    private static Class<?> vectorMaskClass(LaneType laneType, Shape shape) {
        String baseName = laneType.elementName() + shape.shapeName();
        String vectorClassName = "jdk.incubator.vector." + baseName + "Vector";
        Class maskClass = ReflectionUtil.lookupClass((String)(vectorClassName + "$" + baseName + "Mask"));
        UNSAFE.ensureClassInitialized(maskClass);
        return maskClass;
    }

    private static void warmupImplCache(Class<?> vectorClass, String cacheName, String cachedMethodName, WarmupData warmupData) {
        Object cacheObject = ReflectionUtil.readStaticField(vectorClass, (String)cacheName);
        Method cachedMethod = ReflectionUtil.lookupMethod(vectorClass, (String)cachedMethodName, (Class[])new Class[]{Integer.TYPE});
        for (int opcode : warmupData.vectorOpcodes) {
            try {
                Object implFn = cachedMethod.invoke(null, opcode);
                Object[] cacheArray = (Object[])warmupData.implCacheField.get(cacheObject);
                cacheArray[opcode] = implFn;
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof UnsupportedOperationException) continue;
                throw VMError.shouldNotReachHere(ex);
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static void makeConversionOperations(Class<?> conversionImplClass, WarmupData warmupData) {
        Method makeConv = ReflectionUtil.lookupMethod(conversionImplClass, (String)"makeConv", (Class[])new Class[]{Character.TYPE, warmupData.laneTypeClass, warmupData.laneTypeClass});
        for (char kind : WarmupData.CONVERSION_KINDS) {
            for (Object dom : warmupData.laneTypes) {
                for (Object ran : warmupData.laneTypes) {
                    if (kind == 'I' && dom != ran) continue;
                    ReflectionUtil.invokeMethod((Method)makeConv, null, (Object[])new Object[]{Character.valueOf(kind), dom, ran});
                }
            }
        }
    }

    private static Object makeZeroVector(Class<?> vectorClass, Class<?> vectorElement, int laneCount) {
        Object zeroPayload = Array.newInstance(vectorElement, laneCount);
        return ReflectionUtil.newInstance((Constructor)ReflectionUtil.lookupConstructor(vectorClass, (Class[])new Class[]{zeroPayload.getClass()}), (Object[])new Object[]{zeroPayload});
    }

    private static Object makeNewInstanceWithBooleanPayload(Class<?> maskClass, int laneCount, boolean fillValue) {
        Object newInstance = ReflectionUtil.newInstance((Constructor)ReflectionUtil.lookupConstructor(maskClass, (Class[])new Class[]{Boolean.TYPE}), (Object[])new Object[]{true});
        boolean[] payload = new boolean[laneCount];
        Arrays.fill(payload, fillValue);
        ReflectionUtil.writeField(PAYLOAD_CLASS, (String)"payload", (Object)newInstance, (Object)payload);
        return newInstance;
    }

    private static Object makeIotaVector(Class<?> vectorClass, Class<?> vectorElement, int laneCount) {
        int hostLaneCount = (Integer)ReflectionUtil.readStaticField(vectorClass, (String)"VLENGTH");
        Object dummyPayload = Array.newInstance(vectorElement, hostLaneCount);
        for (int i = 0; i < hostLaneCount; ++i) {
            Array.setByte(dummyPayload, i, (byte)0);
        }
        Object iotaVector = ReflectionUtil.newInstance((Constructor)ReflectionUtil.lookupConstructor(vectorClass, (Class[])new Class[]{dummyPayload.getClass()}), (Object[])new Object[]{dummyPayload});
        Object iotaPayload = Array.newInstance(vectorElement, laneCount);
        for (int i = 0; i < laneCount; ++i) {
            if ((byte)i == i) {
                Array.setByte(iotaPayload, i, (byte)i);
            } else if ((short)i == i) {
                Array.setShort(iotaPayload, i, (short)i);
            } else {
                Array.setInt(iotaPayload, i, i);
            }
            VMError.guarantee(Array.getDouble(iotaPayload, i) == (double)i, "wrong initialization of iota array: %s at %s", Array.getDouble(iotaPayload, i), i);
        }
        ReflectionUtil.writeField(PAYLOAD_CLASS, (String)"payload", (Object)iotaVector, (Object)iotaPayload);
        return iotaVector;
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (VectorAPIIntrinsics.intrinsificationSupported((OptionValues)HostedOptionValues.singleton())) {
            VectorAPIIntrinsics.registerPlugins((InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)providers.getReplacements());
        }
    }

    private record LaneType(Class<?> elementClass, Class<?> vectorClass, String elementName, int elementBits, int switchKey) {
        private static LaneType fromVectorElement(Class<?> elementClass, int switchKey) {
            String elementName = elementClass.getName().substring(0, 1).toUpperCase(Locale.ROOT) + elementClass.getName().substring(1);
            String generalVectorName = "jdk.incubator.vector." + elementName + "Vector";
            Class vectorClass = ReflectionUtil.lookupClass((String)generalVectorName);
            UNSAFE.ensureClassInitialized(vectorClass);
            int elementBits = JavaKind.fromJavaClass(elementClass).getBitCount();
            return new LaneType(elementClass, vectorClass, elementName, elementBits, switchKey);
        }
    }

    private record Shape(String shapeName, int switchKey) {
    }

    private record AbstractSpeciesStableFields(int laneCount, int laneCountLog2P1, int vectorBitSize, int vectorByteSize, Object dummyVector, Object laneType) {
    }

    private record OverrideFromMap<E>(EconomicMap<Object, E> map, Function<E, Object> accessor) implements FieldValueTransformer
    {
        public Object transform(Object receiver, Object originalValue) {
            return this.accessor.apply(this.map.get(receiver));
        }
    }

    private static final class WarmupData {
        final Class<?> implCacheClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.VectorOperators$ImplCache");
        final Field implCacheField = ReflectionUtil.lookupField(this.implCacheClass, (String)"cache");
        final int[] vectorOpcodes;
        final Class<?> laneTypeClass;
        final Object[] laneTypes;
        private static final String[] LANE_TYPE_NAMES = new String[]{"FLOAT", "DOUBLE", "BYTE", "SHORT", "INT", "LONG"};
        private static final char[] CONVERSION_KINDS = "ICRZ".toCharArray();

        private WarmupData() {
            int i;
            Class vectorSupportClass = ReflectionUtil.lookupClass((String)"jdk.internal.vm.vector.VectorSupport");
            ArrayList<Integer> opcodeList = new ArrayList<Integer>();
            for (Field f : vectorSupportClass.getDeclaredFields()) {
                if (f.getType() != Integer.TYPE || !f.accessFlags().contains((Object)AccessFlag.STATIC) || !f.accessFlags().contains((Object)AccessFlag.FINAL) || !f.getName().startsWith("VECTOR_OP_")) continue;
                opcodeList.add((Integer)ReflectionUtil.readStaticField((Class)vectorSupportClass, (String)f.getName()));
            }
            int[] opcodes = new int[opcodeList.size()];
            for (i = 0; i < opcodes.length; ++i) {
                opcodes[i] = (Integer)opcodeList.get(i);
            }
            this.vectorOpcodes = opcodes;
            this.laneTypeClass = ReflectionUtil.lookupClass((String)"jdk.incubator.vector.LaneType");
            this.laneTypes = new Object[LANE_TYPE_NAMES.length];
            for (i = 0; i < this.laneTypes.length; ++i) {
                this.laneTypes[i] = ReflectionUtil.readStaticField(this.laneTypeClass, (String)LANE_TYPE_NAMES[i]);
            }
        }
    }
}

