/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class DumpIsolateCreationOnlyOptionsFeature
implements InternalFeature,
FeatureSingleton,
UnsavedSingleton {
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (Options.DumpIsolateCreationOnlyOptions.getValue().booleanValue()) {
            DumpIsolateCreationOnlyOptionsFeature.dumpIsolateOnlyOptions();
        }
    }

    private static void dumpIsolateOnlyOptions() {
        Path dumpPath = NativeImageGenerator.getOutputDirectory().resolve("isolate-creation-only-options.txt");
        try (OutputStream out = Files.newOutputStream(dumpPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            RuntimeOptionParser.singleton().getDescriptors().forEach(descriptor -> {
                OptionKey patt0$temp = descriptor.getOptionKey();
                if (!(patt0$temp instanceof RuntimeOptionKey)) {
                    return;
                }
                RuntimeOptionKey runtimeOptionKey = (RuntimeOptionKey)patt0$temp;
                if (!runtimeOptionKey.isIsolateCreationOnly()) {
                    return;
                }
                try {
                    writer.append(descriptor.getOptionValueType().getCanonicalName());
                    writer.append(' ');
                    writer.append(descriptor.getName());
                    writer.newLine();
                }
                catch (IOException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            });
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, dumpPath);
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> DumpIsolateCreationOnlyOptions = new HostedOptionKey<Boolean>(false);
    }
}

