/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompilationExceptionDispatch;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordBase;

public final class IsolatedCompileClient
extends IsolatedCompilationExceptionDispatch {
    private static final FastThreadLocalObject<IsolatedCompileClient> currentClient = FastThreadLocalFactory.createObject(IsolatedCompileClient.class, "IsolatedCompileClient.currentClient");
    private final CompilerIsolateThread compiler;
    private final ThreadLocalHandles<ObjectHandle> handles = new ThreadLocalHandles(64);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolatedCompileClient get() {
        return currentClient.get();
    }

    public static void set(IsolatedCompileClient client) {
        assert (client == null != (currentClient.get() == null));
        currentClient.set(client);
    }

    public IsolatedCompileClient(CompilerIsolateThread compiler) {
        this.compiler = compiler;
    }

    public CompilerIsolateThread getCompiler() {
        return this.compiler;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected IsolateThread getOtherIsolate() {
        return this.compiler;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    ThreadLocalHandles<ObjectHandle> getHandleSet() {
        return this.handles;
    }

    public <T> ClientHandle<T> hand(T object) {
        return (ClientHandle)this.handles.create(object);
    }

    public <T> T unhand(ClientHandle<? extends T> handle) {
        return (T)this.handles.getObject(handle);
    }

    public CompilerHandle<String> createStringInCompiler(String s) {
        try (CTypeConversion.CCharPointerHolder cstr = CTypeConversion.toCString((CharSequence)s);){
            CompilerHandle<String> compilerHandle = IsolatedCompileClient.createStringInCompiler0(this.compiler, cstr.get());
            return compilerHandle;
        }
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static CompilerHandle<String> createStringInCompiler0(CompilerIsolateThread compiler, CCharPointer cstr) {
        return IsolatedCompileContext.get().hand(CTypeConversion.toJavaString((CCharPointer)cstr));
    }

    public static final class WordExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static WordBase handle(Throwable t) {
            int v = IsolatedCompileClient.get().handleException(t);
            return Word.signed((int)v);
        }
    }

    public static final class BooleanExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static boolean handle(Throwable t) {
            return IsolatedCompileClient.get().handleException(t) != 0;
        }
    }

    public static final class IntExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static int handle(Throwable t) {
            return IsolatedCompileClient.get().handleException(t);
        }
    }

    public static final class VoidExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static void handle(Throwable t) {
            IsolatedCompileClient.get().handleException(t);
        }
    }

    public static final class ExceptionRethrowCallerEpilogue
    implements CEntryPointOptions.CallerEpilogue {
        static void callerEpilogue() {
            IsolatedCompileClient.throwPendingException();
        }
    }
}

