/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompilationMethod;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedRuntimeCodeInstaller;
import com.oracle.svm.graal.meta.SubstrateCodeCacheProvider;
import com.oracle.svm.graal.meta.SubstrateMethod;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.word.ComparableWord;

public final class IsolateAwareCodeCacheProvider
extends SubstrateCodeCacheProvider {
    public IsolateAwareCodeCacheProvider(TargetDescription target, RegisterConfig registerConfig) {
        super(target, registerConfig);
    }

    @Override
    public InstalledCode installCode(ResolvedJavaMethod method, CompiledCode compiledCode, InstalledCode predefinedInstalledCode, SpeculationLog log, boolean isDefault) {
        ClientHandle<SubstrateInstalledCode> installedCode;
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            return super.installCode(method, compiledCode, predefinedInstalledCode, log, isDefault);
        }
        VMError.guarantee(!isDefault);
        IsolatedCodeInstallBridge installBridge = (IsolatedCodeInstallBridge)predefinedInstalledCode;
        ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle = installBridge.getSubstrateInstalledCodeFactoryHandle();
        CompilationResult result = ((SubstrateCompiledCode)compiledCode).getCompilationResult();
        if (method instanceof IsolatedCompilationMethod) {
            IsolatedCompilationMethod compilerMethod = (IsolatedCompilationMethod)method;
            ClientHandle clientMethodHandle = compilerMethod.getMirror();
            assert (!clientMethodHandle.equal((ComparableWord)IsolatedHandles.nullHandle())) : "Client method must not be null";
            installedCode = IsolatedRuntimeCodeInstaller.installInClientIsolate(compilerMethod, clientMethodHandle, result, installedCodeFactoryHandle);
        } else {
            ImageHeapRef<SubstrateMethod> methodRef = ImageHeapObjects.ref((SubstrateMethod)method);
            installedCode = IsolatedRuntimeCodeInstaller.installInClientIsolate(methodRef, result, installedCodeFactoryHandle);
        }
        installBridge.setSubstrateInstalledCodeHandle(installedCode);
        DebugContext debug = DebugContext.forCurrentThread();
        if (debug.isDumpEnabled(1)) {
            debug.dump(1, (Object)installBridge, "After code installation");
        }
        return installBridge;
    }
}

