/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ConstantData;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.meta.SubstrateMemoryAccessProviderImpl;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;

final class ConstantDataConverter {
    private static final char IMAGE_HEAP_REF_KIND = '*';
    private static final char OBJECT_HANDLE_KIND = JavaKind.Object.getTypeChar();

    static void fromCompiler(Constant constant, ConstantData data) {
        data.setRepresentsNull(false);
        if (constant instanceof DirectSubstrateObjectConstant) {
            data.setRawBits((WordBase)ImageHeapObjects.ref(((DirectSubstrateObjectConstant)constant).getObject()));
            data.setKind('*');
            data.setCompressed(((SubstrateObjectConstant)constant).isCompressed());
        } else if (constant instanceof IsolatedObjectConstant) {
            data.setRawBits((WordBase)((IsolatedObjectConstant)constant).getHandle());
            data.setKind(OBJECT_HANDLE_KIND);
            data.setCompressed(((SubstrateObjectConstant)constant).isCompressed());
        } else {
            VMError.guarantee(!(constant instanceof SubstrateObjectConstant), "invalid constant");
            ConstantDataConverter.fromCompilerOrClient((JavaConstant)constant, data);
        }
    }

    static void fromClient(Constant constant, ConstantData data) {
        data.setRepresentsNull(false);
        if (constant instanceof DirectSubstrateObjectConstant) {
            Object target = ((DirectSubstrateObjectConstant)constant).getObject();
            data.setRawBits((WordBase)IsolatedCompileClient.get().hand(target));
            data.setKind(OBJECT_HANDLE_KIND);
            data.setCompressed(((DirectSubstrateObjectConstant)constant).isCompressed());
        } else {
            VMError.guarantee(!(constant instanceof SubstrateObjectConstant), "invalid constant");
            ConstantDataConverter.fromCompilerOrClient((JavaConstant)constant, data);
        }
    }

    private static void fromCompilerOrClient(JavaConstant constant, ConstantData data) {
        Object rawBits;
        if (constant == null) {
            data.setRepresentsNull(true);
            return;
        }
        JavaKind kind = constant.getJavaKind();
        if (kind.isObject() && constant.isNull()) {
            rawBits = IsolatedHandles.nullHandle();
            data.setCompressed(SubstrateObjectConstant.isCompressed(constant));
        } else if (kind.isNumericInteger()) {
            rawBits = Word.signed((long)constant.asLong());
        } else if (kind == JavaKind.Float) {
            rawBits = Word.unsigned((int)Float.floatToRawIntBits(constant.asFloat()));
        } else if (kind == JavaKind.Double) {
            rawBits = Word.unsigned((long)Double.doubleToRawLongBits(constant.asDouble()));
        } else {
            throw VMError.shouldNotReachHere("unsupported constant kind: " + String.valueOf(kind));
        }
        data.setRawBits((WordBase)rawBits);
        data.setKind(kind.getTypeChar());
    }

    static JavaConstant toCompiler(ConstantData data) {
        if (data.getRepresentsNull()) {
            return null;
        }
        char kind = data.getKind();
        if (kind == OBJECT_HANDLE_KIND) {
            ClientHandle handle = (ClientHandle)data.getRawBits();
            if (handle.equal((ComparableWord)IsolatedHandles.nullHandle())) {
                return SubstrateObjectConstant.forObject(null, data.getCompressed());
            }
            return new IsolatedObjectConstant(handle, data.getCompressed());
        }
        return ConstantDataConverter.toCompilerOrClient(data);
    }

    static JavaConstant toClient(ConstantData data) {
        if (data.getRepresentsNull()) {
            return null;
        }
        char kindChar = data.getKind();
        if (kindChar == '*') {
            return SubstrateObjectConstant.forObject(ImageHeapObjects.deref((ImageHeapRef)data.getRawBits()), data.getCompressed());
        }
        if (kindChar == OBJECT_HANDLE_KIND) {
            Object target = IsolatedCompileClient.get().unhand((ClientHandle)data.getRawBits());
            return SubstrateObjectConstant.forObject(target, data.getCompressed());
        }
        return ConstantDataConverter.toCompilerOrClient(data);
    }

    private static JavaConstant toCompilerOrClient(ConstantData data) {
        JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)data.getKind());
        return SubstrateMemoryAccessProviderImpl.toConstant(kind, data.getRawBits().rawValue());
    }

    private ConstantDataConverter() {
    }
}

