/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;

public class ArchiveSupport {
    final boolean isVerbose;
    private static final String deletedFileSuffix = ".deleted";

    public ArchiveSupport(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void compressDirToJar(Path inputRootDir, Path outputFilePath, Manifest manifest) {
        try (JarOutputStream jarOutStream = new JarOutputStream(Files.newOutputStream(outputFilePath, new OpenOption[0]), manifest);
             Stream<Path> walk = Files.walk(inputRootDir, new FileVisitOption[0]);){
            walk.filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).forEach(entry -> this.addFileToJar(inputRootDir, (Path)entry, outputFilePath, jarOutStream));
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Failed to create JAR file " + String.valueOf(outputFilePath.getFileName()), e);
        }
    }

    public void addFileToJar(Path inputDir, Path inputFile, Path outputFilePath, JarOutputStream jarOutStream) {
        String jarEntryName = inputDir.relativize(inputFile).toString();
        JarEntry entry = new JarEntry(jarEntryName.replace(File.separator, "/"));
        try {
            entry.setTime(Files.getLastModifiedTime(inputFile, new LinkOption[0]).toMillis());
            jarOutStream.putNextEntry(entry);
            Files.copy(inputFile, jarOutStream);
            jarOutStream.closeEntry();
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Failed to copy " + String.valueOf(inputFile) + " into JAR file " + String.valueOf(outputFilePath.getFileName()), e);
        }
    }

    public Manifest createManifest() {
        return this.createManifest(null);
    }

    public Manifest createManifest(String mainClass) {
        Manifest mf = new Manifest();
        Attributes attributes = mf.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        return mf;
    }

    public void expandJarToDir(Path inputJarFilePath, Path outputDir) {
        this.expandJarToDir(Function.identity(), inputJarFilePath, outputDir, () -> false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expandJarToDir(Function<Path, Path> relativizeEntry, Path inputJarFilePath, Path outputDir, BooleanSupplier outputDirDeleted) {
        try (JarFile archive = new JarFile(inputJarFilePath.toFile());){
            Enumeration<JarEntry> jarEntries = archive.entries();
            while (jarEntries.hasMoreElements() && !outputDirDeleted.getAsBoolean()) {
                JarEntry jarEntry = jarEntries.nextElement();
                Path originalEntry = outputDir.resolve(jarEntry.getName());
                Path targetEntry = relativizeEntry.apply(originalEntry);
                try {
                    Path targetParent = targetEntry.getParent();
                    if (targetParent != null) {
                        Files.createDirectories(targetParent, new FileAttribute[0]);
                    }
                    Files.copy(archive.getInputStream(jarEntry), targetEntry, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw VMError.shouldNotReachHere("Unable to copy " + jarEntry.getName() + " from " + String.valueOf(targetEntry) + " to " + String.valueOf(targetEntry), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Unable to expand JAR file " + String.valueOf(inputJarFilePath.getFileName()), e);
        }
    }

    public static Map<String, String> loadProperties(Path propertiesPath) {
        if (Files.isReadable(propertiesPath)) {
            try {
                return ArchiveSupport.loadProperties(Files.newInputStream(propertiesPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Could not read properties-file: " + String.valueOf(propertiesPath), e);
            }
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> loadProperties(InputStream propertiesInputStream) {
        Properties properties = new Properties();
        try (InputStream input = propertiesInputStream;){
            properties.load(input);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Could not read properties", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    private static boolean isDeletedPath(Path toDelete) {
        Path fileName = toDelete.getFileName();
        if (fileName == null) {
            throw VMError.shouldNotReachHere("Cannot determine file name for path.");
        }
        return fileName.toString().endsWith(deletedFileSuffix);
    }

    public void deleteAllFiles(Path toDelete) {
        block3: {
            try {
                Path deletedPath = toDelete;
                if (!ArchiveSupport.isDeletedPath(deletedPath)) {
                    deletedPath = toDelete.resolveSibling(String.valueOf(toDelete.getFileName()) + deletedFileSuffix);
                    Files.move(toDelete, deletedPath, new CopyOption[0]);
                }
                Files.walk(deletedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                if (!this.isVerbose) break block3;
                LogUtils.info((String)("Could not recursively delete path: " + String.valueOf(toDelete)));
                e.printStackTrace();
            }
        }
    }

    public <T extends Throwable> Path createTempDir(String tempDirPrefix, AtomicBoolean tempDirDeleted) {
        try {
            Path tempDir = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                tempDirDeleted.set(true);
                this.deleteAllFiles(tempDir);
            }));
            return tempDir;
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Unable to create temp directory for prefix " + tempDirPrefix, e);
        }
    }

    public void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw VMError.shouldNotReachHere("File " + String.valueOf(dir) + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Could not create directory " + String.valueOf(dir));
            }
        }
    }

    public static String currentTime() {
        return ZonedDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String parseTimestamp(String timestamp) {
        String localDateStr;
        try {
            ZonedDateTime dateTime = ZonedDateTime.parse(timestamp, DateTimeFormatter.ISO_DATE_TIME);
            localDateStr = dateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL));
        }
        catch (DateTimeParseException e) {
            localDateStr = "unknown time";
        }
        return localDateStr;
    }
}

