/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationInternals;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.Parker;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_java_util_concurrent_ForkJoinWorkerThread;
import com.oracle.svm.core.thread.Target_java_util_concurrent_ThreadPoolExecutor_Worker;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.ThreadData;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public abstract class PlatformThreads {
    private static final Field FIELDHOLDER_STATUS_FIELD = ImageInfo.inImageCode() ? ReflectionUtil.lookupField(Target_java_lang_Thread_FieldHolder.class, (String)"threadStatus") : null;
    protected static final CEntryPointLiteral<CFunctionPointer> threadStartRoutine = CEntryPointLiteral.create(PlatformThreads.class, (String)"threadStartRoutine", (Class[])new Class[]{ThreadStartData.class});
    static final FastThreadLocalObject<Thread> currentThread = (FastThreadLocalObject)FastThreadLocalFactory.createObject(Thread.class, "PlatformThreads.currentThread").setMaxOffset(127);
    private static final UninterruptibleUtils.AtomicInteger nonDaemonThreads = new UninterruptibleUtils.AtomicInteger(0);
    private final AtomicInteger unattachedStartedThreads = new AtomicInteger(0);
    final ThreadGroup mainGroup = Thread.currentThread().getThreadGroup();
    public final ThreadGroup systemGroup;
    final Thread mainThread;
    final Thread[] mainGroupThreadsArray;
    static final Method FORK_JOIN_POOL_TRY_TERMINATE_METHOD;

    @Fold
    public static PlatformThreads singleton() {
        return (PlatformThreads)ImageSingletons.lookup(PlatformThreads.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PlatformThreads() {
        VMError.guarantee(this.mainGroup.getName().equals("main"), "Wrong ThreadGroup for main");
        this.systemGroup = this.mainGroup.getParent();
        VMError.guarantee(this.systemGroup.getParent() == null && this.systemGroup.getName().equals("system"), "Wrong ThreadGroup for system");
        this.mainThread = new Thread(this.mainGroup, "main");
        this.mainThread.setDaemon(false);
        this.mainGroupThreadsArray = new Thread[4];
        this.mainGroupThreadsArray[0] = this.mainThread;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getThreadAllocatedBytes() {
        return Heap.getHeap().getThreadAllocatedMemory(CurrentIsolate.getCurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.")
    public static long getThreadAllocatedBytes(long javaThreadId) {
        Thread curThread = currentThread.get();
        if (curThread != null && JavaThreads.getThreadId(curThread) == javaThreadId) {
            return PlatformThreads.getThreadAllocatedBytes();
        }
        VMThreads.lockThreadMutexInNativeCode();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread javaThread = currentThread.get(isolateThread);
                if (javaThread != null && JavaThreads.getThreadId(javaThread) == javaThreadId) {
                    long l = Heap.getHeap().getThreadAllocatedMemory(isolateThread);
                    return l;
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
            long l = -1L;
            return l;
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.")
    public static long getThreadCpuTime(long javaThreadId, boolean includeSystemTime) {
        if (!ImageSingletons.contains(ThreadCpuTimeSupport.class)) {
            return -1L;
        }
        Thread curThread = currentThread.get();
        if (curThread != null && JavaThreads.getThreadId(curThread) == javaThreadId) {
            return ThreadCpuTimeSupport.getInstance().getCurrentThreadCpuTime(includeSystemTime);
        }
        VMThreads.lockThreadMutexInNativeCode();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread javaThread = currentThread.get(isolateThread);
                if (javaThread != null && JavaThreads.getThreadId(javaThread) == javaThreadId) {
                    long l = ThreadCpuTimeSupport.getInstance().getThreadCpuTime(isolateThread, includeSystemTime);
                    return l;
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
            long l = -1L;
            return l;
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.")
    public static void getThreadAllocatedBytes(long[] javaThreadIds, long[] result) {
        VMThreads.lockThreadMutexInNativeCode();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread javaThread = currentThread.get(isolateThread);
                if (javaThread != null) {
                    for (int i = 0; i < javaThreadIds.length; ++i) {
                        if (JavaThreads.getThreadId(javaThread) != javaThreadIds[i]) continue;
                        result[i] = Heap.getHeap().getThreadAllocatedMemory(isolateThread);
                        break;
                    }
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Thread fromVMThread(IsolateThread thread) {
        assert (CurrentIsolate.getCurrentThread() == thread || VMOperation.isInProgressAtSafepoint() || VMThreads.THREAD_MUTEX.isOwner() || SubstrateDiagnostics.isFatalErrorHandlingThread()) : "must prevent the isolate thread from exiting";
        return currentThread.get(thread);
    }

    public static IsolateThread getIsolateThreadUnsafe(Thread t) {
        return JavaThreads.toTarget((Thread)t).isolateThread;
    }

    public static IsolateThread getIsolateThread(Thread t) {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        return PlatformThreads.getIsolateThreadUnsafe(t);
    }

    @Uninterruptible(reason="Only uninterruptible code may be executed after Thread.exit.")
    static void afterThreadExit(IsolateThread thread) {
        VMError.guarantee(thread.equal((ComparableWord)CurrentIsolate.getCurrentThread()), "Cleanup must execute in detaching thread");
        Thread javaThread = currentThread.get(thread);
        if (javaThread != null) {
            ThreadListenerSupport.get().afterThreadExit(thread, javaThread);
        }
    }

    public void joinAllNonDaemons() {
        int expectedNonDaemonThreads = currentThread.get().isDaemon() ? 0 : 1;
        PlatformThreads.joinAllNonDaemonsTransition(expectedNonDaemonThreads);
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static void joinAllNonDaemonsTransition(int expectedNonDaemonThreads) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        PlatformThreads.joinAllNonDaemonsInNative(expectedNonDaemonThreads);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void joinAllNonDaemonsInNative(int expectedNonDaemonThreads) {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            while (nonDaemonThreads.get() > expectedNonDaemonThreads) {
                VMThreads.THREAD_LIST_CONDITION.blockNoTransition();
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    public static long getRequestedStackSize(Thread thread) {
        Target_java_lang_Thread tjlt = JavaThreads.toTarget(thread);
        long threadSpecificStackSize = tjlt.holder.stackSize;
        long stackSize = threadSpecificStackSize > 0L ? threadSpecificStackSize : SubstrateOptions.StackSize.getValue();
        if (stackSize != 0L) {
            stackSize += (long)StackOverflowCheck.singleton().yellowAndRedZoneSize();
        }
        return stackSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isCurrentAssigned() {
        return currentThread.get() != null;
    }

    public static boolean ensureCurrentAssigned() {
        return PlatformThreads.ensureCurrentAssigned(null, null, true);
    }

    public static boolean ensureCurrentAssigned(String name, ThreadGroup group, boolean asDaemon) {
        if (currentThread.get() == null) {
            Thread thread = JavaThreads.fromTarget(new Target_java_lang_Thread(name, group, asDaemon));
            PlatformThreads.assignCurrent(thread);
            ThreadListenerSupport.get().beforeThreadRun();
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Ensure consistency of nonDaemonThreads.")
    static void assignCurrent(Thread thread) {
        if (!VMThreads.wasStartedByCurrentIsolate(CurrentIsolate.getCurrentThread()) && thread.isDaemon()) {
            PlatformThreads.decrementNonDaemonThreadsAndNotify();
        }
        PlatformThreads.setThreadStatus(thread, 5);
        PlatformThreads.assignCurrent0(thread);
    }

    @Uninterruptible(reason="Ensure consistency of vthread and cached vthread id.")
    private static void assignCurrent0(Thread thread) {
        VMError.guarantee(currentThread.get() == null, "overwriting existing java.lang.Thread");
        JavaThreads.currentVThreadId.set(JavaThreads.getThreadId(thread));
        currentThread.set(thread);
        assert (JavaThreads.toTarget((Thread)thread).isolateThread.isNull());
        JavaThreads.toTarget((Thread)thread).isolateThread = CurrentIsolate.getCurrentThread();
        ThreadListenerSupport.get().beforeThreadStart(CurrentIsolate.getCurrentThread(), thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Thread getMountedVirtualThread(Thread thread) {
        assert (thread == currentThread.get() || VMOperation.isInProgressAtSafepoint());
        assert (!JavaThreads.isVirtual(thread));
        return JavaThreads.toTarget((Thread)thread).vthread;
    }

    @Uninterruptible(reason="Called during isolate creation.")
    public void assignMainThread() {
        PlatformThreads.assignCurrent0(this.mainThread);
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    public static void detach(IsolateThread vmThread) {
        Thread thread = currentThread.get(vmThread);
        if (thread != null) {
            JavaThreads.toTarget((Thread)thread).threadData.detach();
            JavaThreads.toTarget((Thread)thread).isolateThread = (IsolateThread)Word.nullPointer();
            if (!thread.isDaemon()) {
                PlatformThreads.decrementNonDaemonThreads();
            }
        } else if (!VMThreads.wasStartedByCurrentIsolate(vmThread)) {
            PlatformThreads.decrementNonDaemonThreads();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMThreads.OSThreadHandle startThreadUnmanaged(CFunctionPointer threadRoutine, PointerBase userData, int stackSize) {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.startThreadUnmanaged directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean joinThreadUnmanaged(VMThreads.OSThreadHandle threadHandle, WordPointer threadExitStatus) {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.joinThreadUnmanaged directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ThreadLocalKey createUnmanagedThreadLocal() {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.createNativeThreadLocal directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void deleteUnmanagedThreadLocal(ThreadLocalKey key) {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.deleteNativeThreadLocal directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends WordBase> T getUnmanagedThreadLocalValue(ThreadLocalKey key) {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.getNativeThreadLocalValue directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setUnmanagedThreadLocalValue(ThreadLocalKey key, WordBase value) {
        throw VMError.shouldNotReachHere("Shouldn't call PlatformThreads.setNativeThreadLocalValue directly.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void closeOSThreadHandle(VMThreads.OSThreadHandle threadHandle) {
    }

    public static boolean tearDownOtherThreads() {
        Log trace = Log.noopLog().string("[PlatformThreads.tearDownPlatformThreads:").newline().flush();
        VMThreads.setTearingDown();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        FetchApplicationThreadsOperation operation = new FetchApplicationThreadsOperation(threads);
        operation.enqueue();
        Set<ExecutorService> pools = Collections.newSetFromMap(new IdentityHashMap());
        Set poolsWithNonDaemons = Collections.newSetFromMap(new IdentityHashMap());
        for (Thread thread : threads) {
            ThreadPoolExecutor executor;
            Set<ExecutorService> set;
            assert (thread != null);
            if (thread == currentThread.get()) continue;
            trace.string("  interrupting: ").string(thread.getName()).newline();
            try {
                thread.interrupt();
            }
            catch (Throwable t) {
                trace.string(" threw (ignored): ").exception(t).newline();
            }
            trace.newline().flush();
            Set<ExecutorService> set2 = set = thread.isDaemon() ? pools : poolsWithNonDaemons;
            if (thread instanceof ForkJoinWorkerThread) {
                ForkJoinPool pool = SubstrateUtil.cast((Object)thread, Target_java_util_concurrent_ForkJoinWorkerThread.class).pool;
                if (pool == null || pool.getClass() != ForkJoinPool.class) continue;
                set.add(pool);
                continue;
            }
            Target_java_lang_Thread tjlt = JavaThreads.toTarget(thread);
            Runnable target = tjlt.holder.task;
            if (!Target_java_util_concurrent_ThreadPoolExecutor_Worker.class.isInstance(target) || (executor = SubstrateUtil.cast((Object)target, Target_java_util_concurrent_ThreadPoolExecutor_Worker.class).executor) == null || executor.getClass() != ThreadPoolExecutor.class && executor.getClass() != ScheduledThreadPoolExecutor.class) continue;
            set.add(executor);
        }
        pools.removeAll(poolsWithNonDaemons);
        for (ExecutorService pool : pools) {
            trace.string("  initiating shutdown: ").object(pool);
            try {
                if (pool == ForkJoinPool.commonPool()) {
                    FORK_JOIN_POOL_TRY_TERMINATE_METHOD.invoke((Object)pool, true, true);
                } else {
                    pool.shutdownNow();
                }
            }
            catch (Throwable t) {
                trace.string(" threw (ignored): ").exception(t).newline();
            }
            trace.newline().flush();
            trace.string("  shutdown initiated: ").object(pool).newline().flush();
        }
        boolean result = PlatformThreads.waitForTearDown();
        trace.string("  returns: ").bool(result).string("]").newline().flush();
        return result;
    }

    private static boolean waitForTearDown() {
        long startNanos;
        assert (PlatformThreads.isApplicationThread(CurrentIsolate.getCurrentThread())) : "we count the application threads until only the current one remains";
        Log trace = Log.noopLog().string("[PlatformThreads.waitForTearDown:").newline();
        long warningNanos = SubstrateOptions.getTearDownWarningNanos();
        String warningMessage = "PlatformThreads.waitForTearDown is taking too long.";
        long failureNanos = SubstrateOptions.getTearDownFailureNanos();
        String failureMessage = "PlatformThreads.waitForTearDown took too long.";
        long loopNanos = startNanos = System.nanoTime();
        AtomicBoolean printLaggards = new AtomicBoolean(false);
        Log counterLog = warningNanos == 0L ? trace : Log.log();
        CheckReadyForTearDownOperation operation = new CheckReadyForTearDownOperation(counterLog, printLaggards);
        while (true) {
            long previousLoopNanos = loopNanos;
            operation.enqueue();
            if (operation.isReadyForTearDown()) {
                trace.string("  returns true]").newline();
                return true;
            }
            loopNanos = TimeUtils.doNotLoopTooLong(startNanos, loopNanos, warningNanos, "PlatformThreads.waitForTearDown is taking too long.");
            boolean fatallyTooLong = TimeUtils.maybeFatallyTooLong(startNanos, failureNanos, "PlatformThreads.waitForTearDown took too long.");
            if (fatallyTooLong) {
                trace.string("Took too long to tear down the VM.").newline();
                return false;
            }
            printLaggards.set(previousLoopNanos != loopNanos);
            Thread.yield();
        }
    }

    private static boolean isApplicationThread(IsolateThread isolateThread) {
        return !VMOperationControl.isDedicatedVMOperationThread(isolateThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN"}, justification="notifyAll is necessary for Java semantics, no shared state needs to be modified beforehand")
    public static void exit(Thread thread) {
        ThreadListenerSupport.get().afterThreadRun();
        try {
            JavaThreads.toTarget(thread).exit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread thread2 = thread;
        synchronized (thread2) {
            PlatformThreads.setThreadStatus(thread, 2);
            thread.notifyAll();
        }
    }

    protected <T extends ThreadStartData> T prepareStart(Thread thread, int startDataSize) {
        ThreadStartData startData = (ThreadStartData)Word.nullPointer();
        ObjectHandle threadHandle = (ObjectHandle)Word.zero();
        try {
            startData = (ThreadStartData)NativeMemory.malloc(startDataSize, NmtCategory.Threading);
            threadHandle = ObjectHandles.getGlobal().create((Object)thread);
            startData.setIsolate(CurrentIsolate.getIsolate());
            startData.setThreadHandle(threadHandle);
        }
        catch (Throwable e) {
            if (startData.isNonNull()) {
                PlatformThreads.freeStartData(startData);
            }
            if (threadHandle.notEqual((ComparableWord)Word.zero())) {
                ObjectHandles.getGlobal().destroy(threadHandle);
            }
            throw e;
        }
        try {
            int numThreads = this.unattachedStartedThreads.incrementAndGet();
            assert (numThreads > 0);
            if (!thread.isDaemon()) {
                PlatformThreads.incrementNonDaemonThreads();
            }
            return (T)startData;
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere("No exception must be thrown after creating the thread start data.", e);
        }
    }

    protected void undoPrepareStartOnError(Thread thread, ThreadStartData startData) {
        if (!thread.isDaemon()) {
            PlatformThreads.decrementNonDaemonThreadsAndNotify();
        }
        int numThreads = this.unattachedStartedThreads.decrementAndGet();
        assert (numThreads >= 0);
        PlatformThreads.freeStartData(startData);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void incrementNonDaemonThreads() {
        int numThreads = nonDaemonThreads.incrementAndGet();
        assert (numThreads > 0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void decrementNonDaemonThreads() {
        int numThreads = nonDaemonThreads.decrementAndGet();
        assert (numThreads >= 0);
    }

    @Uninterruptible(reason="Holding threads lock.")
    private static void decrementNonDaemonThreadsAndNotify() {
        VMThreads.lockThreadMutexInNativeCode();
        try {
            PlatformThreads.decrementNonDaemonThreads();
            VMThreads.THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    protected static void freeStartData(ThreadStartData startData) {
        NativeMemory.free(startData);
    }

    void startThread(Thread thread, long stackSize) {
        boolean started = this.doStartThread(thread, stackSize);
        if (!started) {
            throw new OutOfMemoryError("Unable to create native thread: possibly out of memory or process/resource limits reached");
        }
    }

    protected abstract boolean doStartThread(Thread var1, long var2);

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=ThreadStartRoutinePrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    protected static WordBase threadStartRoutine(ThreadStartData data) {
        ObjectHandle threadHandle = data.getThreadHandle();
        PlatformThreads.freeStartData(data);
        PlatformThreads.threadStartRoutine(threadHandle);
        return Word.nullPointer();
    }

    @SuppressFBWarnings(value={"Ru"}, justification="We really want to call Thread.run and not Thread.start because we are in the low-level thread start routine")
    protected static void threadStartRoutine(ObjectHandle threadHandle) {
        Thread thread = (Thread)ObjectHandles.getGlobal().get(threadHandle);
        try {
            PlatformThreads.assignCurrent(thread);
            ObjectHandles.getGlobal().destroy(threadHandle);
            PlatformThreads.singleton().unattachedStartedThreads.decrementAndGet();
            PlatformThreads.singleton().beforeThreadRun(thread);
            if (VMThreads.isTearingDown()) {
                currentThread.get().interrupt();
            }
            ThreadListenerSupport.get().beforeThreadRun();
            thread.run();
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(thread, ex);
        }
    }

    protected void beforeThreadRun(Thread thread) {
    }

    protected abstract void setNativeName(Thread var1, String var2);

    protected abstract void yieldCurrent();

    protected static void wakeUpVMConditionWaiters(Thread thread) {
        if (ReferenceHandler.useDedicatedThread() && ReferenceHandlerThread.isReferenceHandlerThread(thread)) {
            Heap.getHeap().wakeUpReferencePendingListWaiters();
        }
    }

    static StackTraceElement[] getStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        assert (!JavaThreads.isVirtual(thread));
        if (thread != null && thread == currentThread.get()) {
            Pointer startSP = PlatformThreads.getCarrierSPOrElse(thread, callerSP);
            return StackTraceUtils.getCurrentThreadStackTrace(filterExceptions, startSP, (Pointer)Word.nullPointer());
        }
        assert (!filterExceptions) : "exception stack traces can be taken only for the current thread";
        return StackTraceUtils.asyncGetStackTrace(thread);
    }

    static void visitCurrentStackFrames(Pointer callerSP, StackFrameVisitor visitor) {
        assert (!JavaThreads.isVirtual(Thread.currentThread()));
        Pointer startSP = PlatformThreads.getCarrierSPOrElse(Thread.currentThread(), callerSP);
        StackTraceUtils.visitCurrentThreadStackFrames(startSP, (Pointer)Word.nullPointer(), visitor);
    }

    static StackTraceElement[] getStackTraceAtSafepoint(Thread thread, Pointer callerSP) {
        assert (thread != null && !JavaThreads.isVirtual(thread)) : "may only be called for platform or carrier threads";
        Pointer carrierSP = PlatformThreads.getCarrierSPOrElse(thread, (Pointer)Word.nullPointer());
        IsolateThread isolateThread = PlatformThreads.getIsolateThread(thread);
        if (isolateThread == CurrentIsolate.getCurrentThread()) {
            Pointer startSP = carrierSP.isNonNull() ? carrierSP : callerSP;
            return StackTraceUtils.getCurrentThreadStackTrace(false, startSP, (Pointer)Word.nullPointer());
        }
        if (carrierSP.isNonNull()) {
            return StackTraceUtils.getStackTraceAtSafepoint(isolateThread, carrierSP, (Pointer)Word.nullPointer());
        }
        return StackTraceUtils.getStackTraceAtSafepoint(isolateThread);
    }

    static Pointer getCarrierSPOrElse(Thread carrier, Pointer other) {
        for (Target_jdk_internal_vm_Continuation cont = JavaThreads.toTarget((Thread)carrier).cont; cont != null; cont = cont.getParent()) {
            if (cont.getScope() != Target_java_lang_VirtualThread.VTHREAD_SCOPE) continue;
            return ContinuationInternals.getBaseSP(cont);
        }
        return other;
    }

    static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        GetAllStackTracesOperation vmOp = new GetAllStackTracesOperation();
        vmOp.enqueue();
        return vmOp.result;
    }

    static Thread[] getAllThreads() {
        GetAllThreadsOperation vmOp = new GetAllThreadsOperation();
        vmOp.enqueue();
        return vmOp.result.toArray(new Thread[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parkCurrentPlatformOrCarrierThread(boolean isAbsolute, long time) {
        VMOperationControl.guaranteeOkayToBlock("[PlatformThreads.parkCurrentPlatformOrCarrierThread: Should not park when it is not okay to block.]");
        Parker parker = PlatformThreads.getCurrentThreadData().ensureUnsafeParker();
        if (parker.tryFastPark()) {
            return;
        }
        Thread thread = currentThread.get();
        if (JavaThreads.isInterrupted(thread)) {
            return;
        }
        if (time < 0L || isAbsolute && time == 0L) {
            return;
        }
        boolean timed = time != 0L;
        int oldStatus = PlatformThreads.getThreadStatus(thread);
        int newStatus = MonitorSupport.singleton().getParkedThreadStatus(currentThread.get(), timed);
        PlatformThreads.setThreadStatus(thread, newStatus);
        try {
            parker.park(isAbsolute, time);
        }
        finally {
            PlatformThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void unpark(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        ThreadData threadData = PlatformThreads.acquireThreadData(thread);
        if (threadData != null) {
            try {
                threadData.ensureUnsafeParker().unpark();
            }
            finally {
                threadData.release();
            }
        }
    }

    static void sleep(long nanos) throws InterruptedException {
        assert (!JavaThreads.isCurrentThreadVirtual());
        if (nanos < 0L) {
            throw new IllegalArgumentException("Timeout value is negative");
        }
        PlatformThreads.sleep0(nanos);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep0(long durationNanos) {
        VMOperationControl.guaranteeOkayToBlock("[PlatformThreads.sleep(long): Should not sleep when it is not okay to block.]");
        Thread thread = currentThread.get();
        Parker sleepEvent = PlatformThreads.getCurrentThreadData().ensureSleepParker();
        sleepEvent.reset();
        Unsafe.getUnsafe().fullFence();
        if (JavaThreads.isInterrupted(thread)) {
            return;
        }
        int oldStatus = PlatformThreads.getThreadStatus(thread);
        PlatformThreads.setThreadStatus(thread, 225);
        try {
            long remainingNanos = durationNanos;
            long startNanos = System.nanoTime();
            while (remainingNanos > 0L) {
                sleepEvent.park(false, remainingNanos);
                if (JavaThreads.isInterrupted(thread)) {
                    return;
                }
                remainingNanos = durationNanos - (System.nanoTime() - startNanos);
            }
        }
        finally {
            PlatformThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void interruptSleep(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        ThreadData threadData = PlatformThreads.acquireThreadData(thread);
        if (threadData != null) {
            try {
                Parker sleepEvent = threadData.getSleepParker();
                if (sleepEvent != null) {
                    sleepEvent.unpark();
                }
            }
            finally {
                threadData.release();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getThreadStatus(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        return JavaThreads.toTarget((Thread)thread).holder.threadStatus;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setThreadStatus(Thread thread, int threadStatus) {
        assert (!JavaThreads.isVirtual(thread));
        assert (JavaThreads.toTarget((Thread)thread).holder.threadStatus != 2) : "once a thread is marked as terminated, its status must not change";
        JavaThreads.toTarget((Thread)thread).holder.threadStatus = threadStatus;
    }

    static boolean compareAndSetThreadStatus(Thread thread, int expectedStatus, int newStatus) {
        assert (!JavaThreads.isVirtual(thread));
        return Unsafe.getUnsafe().compareAndSetInt(JavaThreads.toTarget((Thread)thread).holder, Unsafe.getUnsafe().objectFieldOffset(FIELDHOLDER_STATUS_FIELD), expectedStatus, newStatus);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isAlive(Thread thread) {
        int threadStatus = PlatformThreads.getThreadStatus(thread);
        return threadStatus != 0 && threadStatus != 2;
    }

    private static ThreadData acquireThreadData(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).threadData.acquire();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static ThreadData getCurrentThreadData() {
        return (ThreadData)JavaThreads.toTarget((Thread)PlatformThreads.currentThread.get()).threadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void blockedOn(Target_sun_nio_ch_Interruptible b) {
        assert (!JavaThreads.isCurrentThreadVirtual());
        Target_java_lang_Thread me = JavaThreads.toTarget(currentThread.get());
        Object object = me.interruptLock;
        synchronized (object) {
            me.nioBlocker = b;
        }
    }

    static {
        VMError.guarantee(ImageInfo.inImageBuildtimeCode(), "PlatformThreads must be initialized at build time.");
        FORK_JOIN_POOL_TRY_TERMINATE_METHOD = ReflectionUtil.lookupMethod(ForkJoinPool.class, (String)"tryTerminate", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE});
    }

    private static class FetchApplicationThreadsOperation
    extends JavaVMOperation {
        private final List<Thread> list;

        FetchApplicationThreadsOperation(List<Thread> list) {
            super(VMOperationInfos.get(FetchApplicationThreadsOperation.class, "Fetch application threads", VMOperation.SystemEffect.NONE));
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            this.list.clear();
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    Thread thread;
                    if (PlatformThreads.isApplicationThread(isolateThread) && (thread = PlatformThreads.fromVMThread(isolateThread)) != null) {
                        this.list.add(thread);
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class CheckReadyForTearDownOperation
    extends JavaVMOperation {
        private final Log trace;
        private final AtomicBoolean printLaggards;
        private boolean readyForTearDown;

        CheckReadyForTearDownOperation(Log trace, AtomicBoolean printLaggards) {
            super(VMOperationInfos.get(CheckReadyForTearDownOperation.class, "Check ready for teardown", VMOperation.SystemEffect.NONE));
            this.trace = trace;
            this.printLaggards = printLaggards;
        }

        boolean isReadyForTearDown() {
            return this.readyForTearDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            int unattachedStartedCount;
            int attachedCount = 0;
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    if (PlatformThreads.isApplicationThread(isolateThread)) {
                        ++attachedCount;
                        if (this.printLaggards.get() && this.trace.isEnabled() && isolateThread != this.queuingThread) {
                            this.trace.string("  laggard isolateThread: ").hex((WordBase)isolateThread);
                            Thread thread = PlatformThreads.fromVMThread(isolateThread);
                            if (thread != null) {
                                String name = thread.getName();
                                Thread.State status = thread.getState();
                                boolean interruptedStatus = JavaThreads.isInterrupted(thread);
                                this.trace.string("  thread.getName(): ").string(name).string("  interruptedStatus: ").bool(interruptedStatus).string("  getState(): ").string(status.name()).newline();
                                for (StackTraceElement e : thread.getStackTrace()) {
                                    this.trace.string(e.toString()).newline();
                                }
                            }
                            this.trace.newline().flush();
                        }
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
                unattachedStartedCount = PlatformThreads.singleton().unattachedStartedThreads.get();
            }
            finally {
                lock.unlock();
            }
            this.readyForTearDown = attachedCount == 1 && unattachedStartedCount == 0;
        }
    }

    @RawStructure
    protected static interface ThreadStartData
    extends PointerBase {
        @RawField
        public ObjectHandle getThreadHandle();

        @RawField
        public void setThreadHandle(ObjectHandle var1);

        @RawField
        public Isolate getIsolate();

        @RawField
        public void setIsolate(Isolate var1);
    }

    private static class GetAllStackTracesOperation
    extends JavaVMOperation {
        private final Map<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>();

        GetAllStackTracesOperation() {
            super(VMOperationInfos.get(GetAllStackTracesOperation.class, "Get all stack traces", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                Thread thread = PlatformThreads.fromVMThread(cur);
                if (thread != null && !thread.isVirtual()) {
                    this.result.put(thread, StackTraceUtils.getStackTraceAtSafepoint(thread));
                }
                cur = VMThreads.nextThread(cur);
            }
        }
    }

    private static class GetAllThreadsOperation
    extends JavaVMOperation {
        private final ArrayList<Thread> result = new ArrayList();

        GetAllThreadsOperation() {
            super(VMOperationInfos.get(GetAllThreadsOperation.class, "Get all threads", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                Thread thread = PlatformThreads.fromVMThread(cur);
                if (thread != null && !thread.isVirtual()) {
                    this.result.add(thread);
                }
                cur = VMThreads.nextThread(cur);
            }
        }
    }

    public static interface ThreadLocalKey
    extends ComparableWord {
    }

    protected static class ThreadStartRoutinePrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to attach a newly launched thread.");

        protected ThreadStartRoutinePrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(ThreadStartData data) {
            int code = CEntryPointActions.enterAttachThread(data.getIsolate(), true, false);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }
}

