/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.hub.ConstantPoolProvider;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.reflect.target.EncodedRuntimeMetadataSupplier;
import com.oracle.svm.core.reflect.target.ExecutableAccessorComputer;
import com.oracle.svm.core.reflect.target.MethodUtil;
import com.oracle.svm.core.reflect.target.ReflectionMetadataComputer;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import jdk.internal.reflect.ConstantPool;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;
import sun.reflect.generics.repository.MethodRepository;

@TargetClass(value=Method.class)
public final class Target_java_lang_reflect_Method {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private MethodRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationsComputer.class)
    byte[] annotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ParameterAnnotationsComputer.class)
    byte[] parameterAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationDefaultComputer.class)
    byte[] annotationDefault;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    public Target_jdk_internal_reflect_MethodAccessor methodAccessor;
    @Alias
    private Class<?> clazz;
    @Alias
    private int slot;
    @Alias
    private String name;
    @Alias
    private Class<?> returnType;
    @Alias
    private Class<?>[] parameterTypes;
    @Alias
    private Class<?>[] exceptionTypes;
    @Alias
    private int modifiers;
    @Alias
    private transient String signature;
    @Alias
    private Method root;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_MethodAccessor methodAccessorFromMetadata;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=LayerIdComputer.class)
    public int layerId;

    @Alias
    @TargetElement(name="<init>")
    native void constructor(Class<?> var1, String var2, Class<?>[] var3, Class<?> var4, Class<?>[] var5, int var6, int var7, String var8, byte[] var9, byte[] var10, byte[] var11);

    @Alias
    public native Class<?> getReturnType();

    @Alias
    public native Class<?> getDeclaringClass();

    @Substitute
    public Target_jdk_internal_reflect_MethodAccessor acquireMethodAccessor() {
        RuntimeConditionSet conditions = SubstrateUtil.cast((Object)this, Target_java_lang_reflect_AccessibleObject.class).conditions;
        if (MetadataTracer.enabled()) {
            MethodUtil.traceMethodAccess(SubstrateUtil.cast(this, Executable.class));
        }
        if (this.methodAccessorFromMetadata == null || !conditions.satisfied()) {
            throw MissingReflectionRegistrationUtils.reportInvokedExecutable(SubstrateUtil.cast(this, Executable.class));
        }
        return this.methodAccessorFromMetadata;
    }

    @Substitute
    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class<?> memberType = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object result = AnnotationParser.parseMemberValue(memberType, ByteBuffer.wrap(this.annotationDefault), ImageLayerBuildingSupport.buildingImageLayer() ? SubstrateUtil.cast(ConstantPoolProvider.singletons()[this.layerId].getConstantPool(), ConstantPool.class) : null, this.getDeclaringClass());
        if (result instanceof ExceptionProxy) {
            if (result instanceof TypeNotPresentExceptionProxy) {
                TypeNotPresentExceptionProxy proxy = (TypeNotPresentExceptionProxy)result;
                throw new TypeNotPresentException(proxy.typeName(), proxy.getCause());
            }
            throw new AnnotationFormatError("Invalid default: " + String.valueOf(this));
        }
        return result;
    }

    @Substitute
    Target_java_lang_reflect_Method copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Method");
        }
        Target_java_lang_reflect_Method res = new Target_java_lang_reflect_Method();
        res.constructor(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        res.root = SubstrateUtil.cast(this, Method.class);
        res.methodAccessor = this.methodAccessor;
        res.genericInfo = this.genericInfo;
        res.layerId = this.layerId;
        return res;
    }

    static class LayerIdComputer
    implements FieldValueTransformer {
        LayerIdComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            if (ImageLayerBuildingSupport.buildingImageLayer()) {
                return DynamicImageLayerInfo.getCurrentLayerNumber();
            }
            return -1;
        }
    }

    static class AnnotationDefaultComputer
    extends ReflectionMetadataComputer {
        AnnotationDefaultComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getAnnotationDefaultEncoding((Method)receiver);
        }
    }

    static class ParameterAnnotationsComputer
    extends ReflectionMetadataComputer {
        ParameterAnnotationsComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getParameterAnnotationsEncoding((Executable)receiver);
        }
    }

    static class AnnotationsComputer
    extends ReflectionMetadataComputer {
        AnnotationsComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getAnnotationsEncoding((AccessibleObject)receiver);
        }
    }
}

