/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import java.lang.reflect.Field;

public class UnsafeFieldUtil {
    public static long getFieldOffset(Target_java_lang_reflect_Field field) {
        if (field == null) {
            throw new NullPointerException();
        }
        if (MetadataTracer.enabled()) {
            UnsafeFieldUtil.traceFieldAccess(SubstrateUtil.cast(field, Field.class));
        }
        int offset = field.root == null ? field.offset : field.root.offset;
        boolean conditionsSatisfied = SubstrateUtil.cast((Object)field, Target_java_lang_reflect_AccessibleObject.class).conditions.satisfied();
        if (offset <= 0 || !conditionsSatisfied) {
            throw MissingReflectionRegistrationUtils.reportAccessedField(SubstrateUtil.cast(field, Field.class));
        }
        return offset;
    }

    private static void traceFieldAccess(Field f) {
        MetadataTracer.singleton().traceFieldAccess(f.getDeclaringClass(), f.getName(), ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
    }
}

