/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.headers.Sysctl;
import com.oracle.svm.core.posix.headers.darwin.DarwinSysctl;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@AutomaticallyRegisteredImageSingleton(value={PhysicalMemory.PhysicalMemorySupport.class})
class DarwinPhysicalMemorySupportImpl
implements PhysicalMemory.PhysicalMemorySupport {
    DarwinPhysicalMemorySupportImpl() {
    }

    @Override
    public UnsignedWord size() {
        CIntPointer namePointer = UnsafeStackValue.get(2, CIntPointer.class);
        namePointer.write(0, DarwinSysctl.CTL_HW());
        namePointer.write(1, DarwinSysctl.HW_MEMSIZE());
        WordPointer physicalMemoryPointer = UnsafeStackValue.get(WordPointer.class);
        WordPointer physicalMemorySizePointer = UnsafeStackValue.get(WordPointer.class);
        physicalMemorySizePointer.write((WordBase)SizeOf.unsigned(WordPointer.class));
        int sysctlResult = Sysctl.sysctl(namePointer, 2L, (PointerBase)physicalMemoryPointer, physicalMemorySizePointer, Word.nullPointer(), 0L);
        if (sysctlResult != 0) {
            Log.log().string("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size(): sysctl() returns with errno: ").signed(LibC.errno()).newline();
            throw VMError.shouldNotReachHere("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size() failed.");
        }
        return (UnsignedWord)physicalMemoryPointer.read();
    }
}

