/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.ImageHeapList;
import java.util.List;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public class RuntimeOptionValidationSupport {
    private final List<RuntimeOptionValidation<?>> validations = ImageHeapList.createGeneric(RuntimeOptionValidation.class);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeOptionValidationSupport() {
    }

    @Fold
    public static RuntimeOptionValidationSupport singleton() {
        return (RuntimeOptionValidationSupport)ImageSingletons.lookup(RuntimeOptionValidationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(RuntimeOptionValidation<?> validation) {
        assert (validation != null);
        this.validations.add(validation);
    }

    public void validate() {
        for (RuntimeOptionValidation<?> validation : this.validations) {
            validation.validate();
        }
    }

    public static class RuntimeOptionValidation<T> {
        private final Consumer<RuntimeOptionKey<T>> validation;
        private final RuntimeOptionKey<T> optionKey;

        public RuntimeOptionValidation(Consumer<RuntimeOptionKey<T>> validation, RuntimeOptionKey<T> optionKey) {
            this.validation = validation;
            this.optionKey = optionKey;
        }

        void validate() {
            this.validation.accept(this.optionKey);
        }
    }
}

