/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTypeRepository
implements JfrRepository {
    private final Set<Class<?>> flushedClasses = new HashSet();
    private final Map<String, PackageInfo> flushedPackages = new HashMap<String, PackageInfo>();
    private final Map<Module, Long> flushedModules = new HashMap<Module, Long>();
    private final Map<ClassLoader, Long> flushedClassLoaders = new HashMap<ClassLoader, Long>();
    private long currentPackageId = 0L;
    private long currentModuleId = 0L;
    private long currentClassLoaderId = 0L;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrTypeRepository() {
    }

    public void teardown() {
        this.clearEpochData();
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getClassId(Class<?> clazz) {
        return JfrTraceId.load(clazz);
    }

    @Override
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        TypeInfo typeInfo = this.collectTypeInfo(flushpoint);
        int count = this.writeClasses(writer, typeInfo, flushpoint);
        count += this.writePackages(writer, typeInfo, flushpoint);
        count += this.writeModules(writer, typeInfo, flushpoint);
        count += JfrTypeRepository.writeClassLoaders(writer, typeInfo, flushpoint);
        if (flushpoint) {
            this.flushedClasses.addAll(typeInfo.classes);
            this.flushedPackages.putAll(typeInfo.packages);
            this.flushedModules.putAll(typeInfo.modules);
            this.flushedClassLoaders.putAll(typeInfo.classLoaders);
        } else {
            this.clearEpochData();
        }
        return count;
    }

    private TypeInfo collectTypeInfo(boolean flushpoint) {
        TypeInfo typeInfo = new TypeInfo();
        Heap.getHeap().visitLoadedClasses(clazz -> {
            if (flushpoint) {
                if (JfrTraceId.isUsedCurrentEpoch(clazz)) {
                    this.visitClass(typeInfo, (Class<?>)clazz);
                }
            } else if (JfrTraceId.isUsedPreviousEpoch(clazz)) {
                JfrTraceId.clearUsedPreviousEpoch(clazz);
                this.visitClass(typeInfo, (Class<?>)clazz);
            }
        });
        return typeInfo;
    }

    private void visitClass(TypeInfo typeInfo, Class<?> clazz) {
        if (clazz != null && this.addClass(typeInfo, clazz)) {
            this.visitClassLoader(typeInfo, clazz.getClassLoader());
            this.visitPackage(typeInfo, clazz.getPackage(), clazz.getModule());
            this.visitClass(typeInfo, clazz.getSuperclass());
        }
    }

    private void visitPackage(TypeInfo typeInfo, Package pkg, Module module) {
        if (pkg != null && this.addPackage(typeInfo, pkg, module)) {
            this.visitModule(typeInfo, module);
        }
    }

    private void visitModule(TypeInfo typeInfo, Module module) {
        if (module != null && this.addModule(typeInfo, module)) {
            this.visitClassLoader(typeInfo, module.getClassLoader());
        }
    }

    private void visitClassLoader(TypeInfo typeInfo, ClassLoader classLoader) {
        if (classLoader != null && this.addClassLoader(typeInfo, classLoader)) {
            this.visitClass(typeInfo, classLoader.getClass());
        }
    }

    private int writeClasses(JfrChunkWriter writer, TypeInfo typeInfo, boolean flushpoint) {
        if (typeInfo.classes.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Class.getId());
        writer.writeCompressedInt(typeInfo.classes.size());
        for (Class<?> clazz : typeInfo.classes) {
            this.writeClass(typeInfo, writer, clazz, flushpoint);
        }
        return 1;
    }

    private void writeClass(TypeInfo typeInfo, JfrChunkWriter writer, Class<?> clazz, boolean flushpoint) {
        writer.writeCompressedLong(JfrTraceId.getTraceId(clazz));
        writer.writeCompressedLong(this.getClassLoaderId(typeInfo, clazz.getClassLoader()));
        writer.writeCompressedLong(JfrTypeRepository.getSymbolId(writer, clazz.getName(), flushpoint, true));
        writer.writeCompressedLong(this.getPackageId(typeInfo, clazz.getPackage()));
        writer.writeCompressedLong(clazz.getModifiers());
        writer.writeBoolean(clazz.isHidden());
    }

    @Uninterruptible(reason="Needed for JfrSymbolRepository.getSymbolId().")
    private static long getSymbolId(JfrChunkWriter writer, String symbol, boolean flushpoint, boolean replaceDotWithSlash) {
        assert (writer.isLockedByCurrentThread());
        return SubstrateJVM.getSymbolRepository().getSymbolId(symbol, !flushpoint, replaceDotWithSlash);
    }

    private int writePackages(JfrChunkWriter writer, TypeInfo typeInfo, boolean flushpoint) {
        if (typeInfo.packages.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Package.getId());
        writer.writeCompressedInt(typeInfo.packages.size());
        for (Map.Entry<String, PackageInfo> pkgInfo : typeInfo.packages.entrySet()) {
            this.writePackage(typeInfo, writer, pkgInfo.getKey(), pkgInfo.getValue(), flushpoint);
        }
        return 1;
    }

    private void writePackage(TypeInfo typeInfo, JfrChunkWriter writer, String pkgName, PackageInfo pkgInfo, boolean flushpoint) {
        writer.writeCompressedLong(pkgInfo.id);
        writer.writeCompressedLong(JfrTypeRepository.getSymbolId(writer, pkgName, flushpoint, true));
        writer.writeCompressedLong(this.getModuleId(typeInfo, pkgInfo.module));
        writer.writeBoolean(false);
    }

    private int writeModules(JfrChunkWriter writer, TypeInfo typeInfo, boolean flushpoint) {
        if (typeInfo.modules.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Module.getId());
        writer.writeCompressedInt(typeInfo.modules.size());
        for (Map.Entry<Module, Long> modInfo : typeInfo.modules.entrySet()) {
            this.writeModule(typeInfo, writer, modInfo.getKey(), modInfo.getValue(), flushpoint);
        }
        return 1;
    }

    private void writeModule(TypeInfo typeInfo, JfrChunkWriter writer, Module module, long id, boolean flushpoint) {
        writer.writeCompressedLong(id);
        writer.writeCompressedLong(JfrTypeRepository.getSymbolId(writer, module.getName(), flushpoint, false));
        writer.writeCompressedLong(0L);
        writer.writeCompressedLong(0L);
        writer.writeCompressedLong(this.getClassLoaderId(typeInfo, module.getClassLoader()));
    }

    private static int writeClassLoaders(JfrChunkWriter writer, TypeInfo typeInfo, boolean flushpoint) {
        if (typeInfo.classLoaders.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.ClassLoader.getId());
        writer.writeCompressedInt(typeInfo.classLoaders.size());
        for (Map.Entry<ClassLoader, Long> clInfo : typeInfo.classLoaders.entrySet()) {
            JfrTypeRepository.writeClassLoader(writer, clInfo.getKey(), clInfo.getValue(), flushpoint);
        }
        return 1;
    }

    private static void writeClassLoader(JfrChunkWriter writer, ClassLoader cl, long id, boolean flushpoint) {
        writer.writeCompressedLong(id);
        if (cl == null) {
            writer.writeCompressedLong(0L);
            writer.writeCompressedLong(JfrTypeRepository.getSymbolId(writer, "bootstrap", flushpoint, false));
        } else {
            writer.writeCompressedLong(JfrTraceId.getTraceId(cl.getClass()));
            writer.writeCompressedLong(JfrTypeRepository.getSymbolId(writer, cl.getName(), flushpoint, false));
        }
    }

    private boolean addClass(TypeInfo typeInfo, Class<?> clazz) {
        if (this.isClassVisited(typeInfo, clazz)) {
            return false;
        }
        return typeInfo.classes.add(clazz);
    }

    private boolean isClassVisited(TypeInfo typeInfo, Class<?> clazz) {
        return typeInfo.classes.contains(clazz) || this.flushedClasses.contains(clazz);
    }

    private boolean addPackage(TypeInfo typeInfo, Package pkg, Module module) {
        if (this.isPackageVisited(typeInfo, pkg)) {
            assert (module == (this.flushedPackages.containsKey(pkg.getName()) ? this.flushedPackages.get((Object)pkg.getName()).module : typeInfo.packages.get((Object)pkg.getName()).module));
            return false;
        }
        long id = pkg.getName().isEmpty() ? 0L : (this.currentPackageId = this.currentPackageId + 1L);
        typeInfo.packages.put(pkg.getName(), new PackageInfo(id, module));
        return true;
    }

    private boolean isPackageVisited(TypeInfo typeInfo, Package pkg) {
        return this.flushedPackages.containsKey(pkg.getName()) || typeInfo.packages.containsKey(pkg.getName());
    }

    private long getPackageId(TypeInfo typeInfo, Package pkg) {
        if (pkg != null) {
            if (this.flushedPackages.containsKey(pkg.getName())) {
                return this.flushedPackages.get((Object)pkg.getName()).id;
            }
            return typeInfo.packages.get((Object)pkg.getName()).id;
        }
        return 0L;
    }

    private boolean addModule(TypeInfo typeInfo, Module module) {
        if (this.isModuleVisited(typeInfo, module)) {
            return false;
        }
        typeInfo.modules.put(module, ++this.currentModuleId);
        return true;
    }

    private boolean isModuleVisited(TypeInfo typeInfo, Module module) {
        return typeInfo.modules.containsKey(module) || this.flushedModules.containsKey(module);
    }

    private long getModuleId(TypeInfo typeInfo, Module module) {
        if (module != null) {
            if (this.flushedModules.containsKey(module)) {
                return this.flushedModules.get(module);
            }
            return typeInfo.modules.get(module);
        }
        return 0L;
    }

    private boolean addClassLoader(TypeInfo typeInfo, ClassLoader classLoader) {
        if (this.isClassLoaderVisited(typeInfo, classLoader)) {
            return false;
        }
        typeInfo.classLoaders.put(classLoader, ++this.currentClassLoaderId);
        return true;
    }

    private boolean isClassLoaderVisited(TypeInfo typeInfo, ClassLoader classLoader) {
        return this.flushedClassLoaders.containsKey(classLoader) || typeInfo.classLoaders.containsKey(classLoader);
    }

    private long getClassLoaderId(TypeInfo typeInfo, ClassLoader classLoader) {
        if (classLoader != null) {
            if (this.flushedClassLoaders.containsKey(classLoader)) {
                return this.flushedClassLoaders.get(classLoader);
            }
            return typeInfo.classLoaders.get(classLoader);
        }
        return 0L;
    }

    private void clearEpochData() {
        this.flushedClasses.clear();
        this.flushedPackages.clear();
        this.flushedModules.clear();
        this.flushedClassLoaders.clear();
        this.currentPackageId = 0L;
        this.currentModuleId = 0L;
        this.currentClassLoaderId = 0L;
    }

    private static final class TypeInfo {
        final Set<Class<?>> classes = new HashSet();
        final Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
        final Map<Module, Long> modules = new HashMap<Module, Long>();
        final Map<ClassLoader, Long> classLoaders = new HashMap<ClassLoader, Long>();

        private TypeInfo() {
        }
    }

    private static class PackageInfo {
        private final long id;
        private final Module module;

        PackageInfo(long id, Module module) {
            this.id = id;
            this.module = module;
        }
    }
}

