/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.jfr.JfrSerializer;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrSerializerSupport {
    private JfrSerializer[] serializers = new JfrSerializer[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrSerializerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(JfrSerializer serializer) {
        assert (serializer != null);
        int oldLength = this.serializers.length;
        this.serializers = Arrays.copyOf(this.serializers, oldLength + 1);
        this.serializers[oldLength] = serializer;
    }

    @Fold
    public static JfrSerializerSupport get() {
        return (JfrSerializerSupport)ImageSingletons.lookup(JfrSerializerSupport.class);
    }

    public JfrSerializer[] getSerializers() {
        return this.serializers;
    }
}

