/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.runtimeinit;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SecurityProvidersInitializedAtRunTime;
import com.oracle.svm.core.jdk.SecurityProvidersSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.net.URL;
import java.security.Provider;
import java.util.Map;
import java.util.WeakHashMap;

@TargetClass(className="javax.crypto.JceSecurity", onlyWith={SecurityProvidersInitializedAtRunTime.class})
@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/java.base/share/classes/javax/crypto/JceSecurity.java.template")
final class Target_javax_crypto_JceSecurity {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static Map<Object, Object> verificationResults;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static Map<Provider, Object> verifyingProviders;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static Map<Class<?>, URL> codeBaseCacheRef;

    Target_javax_crypto_JceSecurity() {
    }

    @Substitute
    static Exception getVerificationResult(Provider p) {
        Object o = SecurityProvidersSupport.singleton().getSecurityProviderVerificationResult(p.getName());
        if (o == Boolean.TRUE) {
            return null;
        }
        if (o != null) {
            return (Exception)o;
        }
        throw new SecurityException("Attempted to verify a provider that was not registered at build time: " + String.valueOf(p) + ". All security providers must be registered and verified during native image generation. Try adding the option: -H:AdditionalSecurityProviders=" + String.valueOf(p) + " and rebuild the image.");
    }

    static {
        codeBaseCacheRef = new WeakHashMap();
    }
}

