/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.shaded.org.objectweb.asm.ClassReader;
import com.oracle.svm.shaded.org.objectweb.asm.ClassVisitor;
import com.oracle.svm.shaded.org.objectweb.asm.ClassWriter;
import com.oracle.svm.shaded.org.objectweb.asm.MethodVisitor;
import com.oracle.svm.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.Digest;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class PredefinedClassesSupport {
    public static final String ENABLE_BYTECODES_OPTION = SubstrateOptionsParser.commandArgument(Options.SupportPredefinedClasses, "+");
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Consumer<Class<?>> validator = null;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<Class<?>> predefinedClasses = new HashSet();
    private final ReentrantLock lock = new ReentrantLock();
    private final EconomicMap<String, Class<?>> predefinedClassesByHash = ImageHeapMap.create("predefinedClassesByHash");
    private final EconomicMap<String, Class<?>> loadedClassesByName = EconomicMap.create();

    @Fold
    public static boolean supportsBytecodes() {
        return Options.SupportPredefinedClasses.getValue();
    }

    @Fold
    public static boolean hasBytecodeClasses() {
        return PredefinedClassesSupport.supportsBytecodes() && !PredefinedClassesSupport.singleton().predefinedClassesByHash.isEmpty();
    }

    @Fold
    static PredefinedClassesSupport singleton() {
        return (PredefinedClassesSupport)ImageSingletons.lookup(PredefinedClassesSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setRegistrationValidator(Consumer<Class<?>> consumer) {
        this.validator = consumer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(String hash, Class<?> clazz) {
        Class existing;
        if (PredefinedClassesSupport.singleton().validator != null) {
            PredefinedClassesSupport.singleton().validator.accept(clazz);
        }
        if ((existing = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.putIfAbsent((Object)hash, clazz)) != clazz) {
            VMError.guarantee(existing == null, "Can define only one class per hash");
            if (LambdaUtils.isLambdaClass(clazz)) {
                PredefinedClassesSupport.registerLambdaForReflection(clazz);
            }
            PredefinedClassesSupport.singleton().predefinedClasses.add(clazz);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void registerLambdaForReflection(Class<?> lambdaClass) {
        try {
            RuntimeReflection.register((Field[])new Field[]{lambdaClass.getDeclaredField("LAMBDA_INSTANCE$")});
        }
        catch (NoSuchFieldException ignored) {
            RuntimeReflection.register((Executable[])lambdaClass.getDeclaredConstructors());
        }
        if (Serializable.class.isAssignableFrom(lambdaClass) && SerializationSupport.currentLayer().isLambdaCapturingClassRegistered(LambdaUtils.capturingClass((String)lambdaClass.getName()))) {
            try {
                Method serializeLambdaMethod = lambdaClass.getDeclaredMethod("writeReplace", new Class[0]);
                RuntimeReflection.register((Executable[])new Executable[]{serializeLambdaMethod});
            }
            catch (NoSuchMethodException e) {
                throw VMError.shouldNotReachHere("Serializable lambda class must contain the writeReplace method.");
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        if (PredefinedClassesSupport.singleton().validator != null) {
            PredefinedClassesSupport.singleton().validator.accept(clazz);
        }
        PredefinedClassesSupport.singleton().predefinedClasses.add(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isPredefined(Class<?> clazz) {
        return PredefinedClassesSupport.singleton().predefinedClasses.contains(clazz);
    }

    public static Class<?> knownClass(byte[] data, int offset, int length) {
        String hash = PredefinedClassesSupport.getHash(data, offset, length);
        Class clazz = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.get((Object)hash);
        return clazz;
    }

    public static String getHash(byte[] data, int offset, int length) {
        return Digest.digest((byte[])data, (int)offset, (int)length);
    }

    public static void loadClass(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        boolean loaded = PredefinedClassesSupport.loadClassIfNotLoaded(classLoader, protectionDomain, clazz);
        if (!loaded) {
            if (classLoader == clazz.getClassLoader()) {
                throw new LinkageError("Loader " + String.valueOf(classLoader) + " attempted duplicate class definition for " + clazz.getName() + " defined by " + String.valueOf(clazz.getClassLoader()));
            }
            throw VMError.unsupportedFeature("A predefined class can be loaded (defined) at runtime only once by a single class loader. Hierarchies of class loaders and distinct sets of classes are not supported. Class " + clazz.getName() + " has already been loaded by class loader: " + String.valueOf(clazz.getClassLoader()));
        }
    }

    public static boolean loadClassIfNotLoaded(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        return PredefinedClassesSupport.singleton().loadClass0(classLoader, protectionDomain, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadClass0(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        if (DynamicHub.fromClass(clazz).isLoaded()) {
            return false;
        }
        PredefinedClassesSupport.loadSuperType(clazz, clazz.getSuperclass(), classLoader);
        for (Class<?> intf : clazz.getInterfaces()) {
            PredefinedClassesSupport.loadSuperType(clazz, intf, classLoader);
        }
        this.lock.lock();
        try {
            if (DynamicHub.fromClass(clazz).isLoaded()) {
                boolean bl = false;
                return bl;
            }
            DynamicHub hub = DynamicHub.fromClass(clazz);
            hub.setClassLoaderAtRuntime(classLoader);
            if (protectionDomain != null) {
                hub.setProtectionDomainAtRuntime(protectionDomain);
            }
            this.loadedClassesByName.put((Object)clazz.getName(), clazz);
            int n = 1;
            return n != 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void loadSuperType(Class<?> clazz, Class<?> supertype, ClassLoader classLoader) {
        if (supertype == null) {
            return;
        }
        if (classLoader != null && !DynamicHub.fromClass(supertype).isLoaded()) {
            Class<?> loaded;
            try {
                loaded = classLoader.loadClass(supertype.getName());
            }
            catch (ClassNotFoundException e) {
                throw PredefinedClassesSupport.throwUnresolvable(supertype, e);
            }
            if (loaded != supertype) {
                throw new LinkageError("Loader " + String.valueOf(classLoader) + " supplied unexpected class " + loaded.getName() + " for supertype of " + clazz.getName() + " when expecting " + supertype.getName());
            }
        } else {
            PredefinedClassesSupport.throwIfUnresolvable(supertype, classLoader);
        }
    }

    public static void throwIfUnresolvable(Class<?> clazz, ClassLoader classLoader) {
        if (clazz == null) {
            return;
        }
        DynamicHub hub = DynamicHub.fromClass(clazz);
        if (!hub.isLoaded() || !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)classLoader)) {
            throw PredefinedClassesSupport.throwUnresolvable(clazz, null);
        }
    }

    private static RuntimeException throwUnresolvable(Class<?> clazz, ClassNotFoundException cause) {
        String name = clazz.getName();
        NoClassDefFoundError error = new NoClassDefFoundError(name.replace('.', '/'));
        error.initCause(cause != null ? cause : new ClassNotFoundException(name));
        throw error;
    }

    static Class<?> getLoadedForNameOrNull(String name, ClassLoader classLoader) {
        Class<?> clazz = PredefinedClassesSupport.singleton().getLoaded(name);
        if (clazz == null || !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)classLoader)) {
            return null;
        }
        return clazz;
    }

    private Class<?> getLoaded(String name) {
        this.lock.lock();
        try {
            Class clazz = (Class)this.loadedClassesByName.get((Object)name);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> maybeAdjustLambdaNestHost(String className, Class<?> javaClass, ClassLoader classLoader, Class<?> originalNestHost) {
        Class<?> lambdaNestHost = originalNestHost;
        if (LambdaUtils.isLambdaClassName((String)className) && PredefinedClassesSupport.isPredefined(javaClass)) {
            Class<?> capturingClass;
            try {
                capturingClass = Class.forName(LambdaUtils.capturingClass((String)className), false, classLoader);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            lambdaNestHost = capturingClass.getNestHost();
        }
        return lambdaNestHost;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static byte[] changeLambdaClassName(byte[] data, final String oldName, final String newName) {
        ClassReader cr = new ClassReader(data);
        ClassWriter cw = new ClassWriter(2);
        cr.accept(new ClassVisitor(327680, cw){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, newName, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String originalName, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(this, 327680, super.visitMethod(access, originalName, desc, signature, exceptions)){

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        String name = type.equals(oldName) ? newName : type;
                        super.visitTypeInsn(opcode, name);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String methodName, String descriptor, boolean isInterface) {
                        String name = owner.equals(oldName) ? newName : owner;
                        super.visitMethodInsn(opcode, name, methodName, descriptor, isInterface);
                    }

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String fieldName, String descriptor) {
                        String name = owner.equals(oldName) ? newName : owner;
                        super.visitFieldInsn(opcode, name, fieldName, descriptor);
                    }
                };
            }
        }, 8);
        return cw.toByteArray();
    }

    public static final class Options {
        static final HostedOptionKey<Boolean> SupportPredefinedClasses = new HostedOptionKey<Boolean>(true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class TestingBackdoor {
        public static Set<Class<?>> getConfigurationPredefinedClasses() {
            HashSet set = new HashSet();
            for (Class clazz : PredefinedClassesSupport.singleton().predefinedClassesByHash.getValues()) {
                set.add(clazz);
            }
            return set;
        }
    }
}

